/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import software.amazon.ion.IonException;
import software.amazon.ion.Timestamp;

public final class JarInfo {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final String BUILD_TIME_ATTRIBUTE = "Ion-Java-Build-Time";
    private static final String PROJECT_VERSION_ATTRIBUTE = "Ion-Java-Project-Version";
    private String ourProjectVersion;
    private Timestamp ourBuildTime;

    public JarInfo() throws IonException {
        Enumeration<URL> enumeration;
        try {
            enumeration = this.getClass().getClassLoader().getResources(MANIFEST_FILE);
        }
        catch (IOException iOException) {
            throw new IonException("Unable to load manifests.", iOException);
        }
        ArrayList<Manifest> arrayList = new ArrayList<Manifest>();
        while (enumeration.hasMoreElements()) {
            try {
                arrayList.add(new Manifest(enumeration.nextElement().openStream()));
            }
            catch (IOException iOException) {}
        }
        this.loadBuildProperties(arrayList);
    }

    JarInfo(List<Manifest> list) {
        this.loadBuildProperties(list);
    }

    public String getProjectVersion() {
        return this.ourProjectVersion;
    }

    public Timestamp getBuildTime() {
        return this.ourBuildTime;
    }

    private void loadBuildProperties(List<Manifest> list) throws IonException {
        boolean bl = false;
        for (Manifest manifest : list) {
            boolean bl2 = this.tryLoadBuildProperties(manifest);
            if (bl2 && bl) {
                throw new IonException("Found multiple manifests with ion-java version info on the classpath.");
            }
            bl |= bl2;
        }
        if (!bl) {
            throw new IonException("Unable to locate manifest with ion-java version info on the classpath.");
        }
    }

    private boolean tryLoadBuildProperties(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(PROJECT_VERSION_ATTRIBUTE);
        String string2 = attributes.getValue(BUILD_TIME_ATTRIBUTE);
        if (string == null || string2 == null) {
            return false;
        }
        this.ourProjectVersion = string;
        try {
            this.ourBuildTime = Timestamp.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }
}

