/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.IOException;
import java.math.BigDecimal;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.PrivateIonTextAppender;
import software.amazon.ion.impl.PrivateIonTextWriterBuilder;

public class IonTextUtils {
    public static boolean isWhitespace(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericStop(int n) {
        switch (n) {
            case -1: 
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDigit(int n, int n2) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return n2 == 8 || n2 == 10 || n2 == 16;
            }
            case 56: 
            case 57: {
                return n2 == 10 || n2 == 16;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return n2 == 16;
            }
        }
        return false;
    }

    public static boolean isIdentifierStart(int n) {
        return PrivateIonTextAppender.isIdentifierStart(n);
    }

    public static boolean isIdentifierPart(int n) {
        return PrivateIonTextAppender.isIdentifierPart(n);
    }

    public static boolean isOperatorPart(int n) {
        return PrivateIonTextAppender.isOperatorPart(n);
    }

    public static SymbolVariant symbolVariant(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            throw new EmptySymbolException();
        }
        if (PrivateIonTextAppender.isIdentifierKeyword(charSequence)) {
            return SymbolVariant.QUOTED;
        }
        char c = charSequence.charAt(0);
        if (IonTextUtils.isIdentifierStart(c)) {
            for (int i = 0; i < n; ++i) {
                c = charSequence.charAt(i);
                if (c != '\'' && c >= ' ' && c <= '~' && IonTextUtils.isIdentifierPart(c)) continue;
                return SymbolVariant.QUOTED;
            }
            return SymbolVariant.IDENTIFIER;
        }
        if (IonTextUtils.isOperatorPart(c)) {
            for (int i = 0; i < n; ++i) {
                c = charSequence.charAt(i);
                if (IonTextUtils.isOperatorPart(c)) continue;
                return SymbolVariant.QUOTED;
            }
            return SymbolVariant.OPERATOR;
        }
        return SymbolVariant.QUOTED;
    }

    public static void printStringCodePoint(Appendable appendable, int n) throws IOException {
        IonTextUtils.printCodePoint(appendable, n, EscapeMode.ION_STRING);
    }

    public static void printSymbolCodePoint(Appendable appendable, int n) throws IOException {
        IonTextUtils.printCodePoint(appendable, n, EscapeMode.ION_SYMBOL);
    }

    public static void printJsonCodePoint(Appendable appendable, int n) throws IOException {
        IonTextUtils.printCodePoint(appendable, n, EscapeMode.JSON);
    }

    private static void printCodePoint(Appendable appendable, int n, EscapeMode escapeMode) throws IOException {
        switch (n) {
            case 0: {
                appendable.append(escapeMode == EscapeMode.JSON ? "\\u0000" : "\\0");
                return;
            }
            case 9: {
                appendable.append("\\t");
                return;
            }
            case 10: {
                if (escapeMode == EscapeMode.ION_LONG_STRING) {
                    appendable.append('\n');
                } else {
                    appendable.append("\\n");
                }
                return;
            }
            case 13: {
                appendable.append("\\r");
                return;
            }
            case 12: {
                appendable.append("\\f");
                return;
            }
            case 8: {
                appendable.append("\\b");
                return;
            }
            case 7: {
                appendable.append(escapeMode == EscapeMode.JSON ? "\\u0007" : "\\a");
                return;
            }
            case 11: {
                appendable.append(escapeMode == EscapeMode.JSON ? "\\u000b" : "\\v");
                return;
            }
            case 34: {
                if (escapeMode != EscapeMode.JSON && escapeMode != EscapeMode.ION_STRING) break;
                appendable.append("\\\"");
                return;
            }
            case 39: {
                if (escapeMode != EscapeMode.ION_SYMBOL && escapeMode != EscapeMode.ION_LONG_STRING) break;
                appendable.append("\\'");
                return;
            }
            case 92: {
                appendable.append("\\\\");
                return;
            }
        }
        if (n < 32) {
            if (escapeMode == EscapeMode.JSON) {
                IonTextUtils.printCodePointAsFourHexDigits(appendable, n);
            } else {
                IonTextUtils.printCodePointAsTwoHexDigits(appendable, n);
            }
        } else if (n < 127) {
            appendable.append((char)n);
        } else if (n <= 255) {
            if (escapeMode == EscapeMode.JSON) {
                IonTextUtils.printCodePointAsFourHexDigits(appendable, n);
            } else {
                IonTextUtils.printCodePointAsTwoHexDigits(appendable, n);
            }
        } else if (n <= 65535) {
            IonTextUtils.printCodePointAsFourHexDigits(appendable, n);
        } else if (escapeMode == EscapeMode.JSON) {
            IonTextUtils.printCodePointAsSurrogatePairHexDigits(appendable, n);
        } else {
            IonTextUtils.printCodePointAsEightHexDigits(appendable, n);
        }
    }

    private static void printCodePointAsTwoHexDigits(Appendable appendable, int n) throws IOException {
        String string = Integer.toHexString(n);
        appendable.append("\\x");
        if (string.length() < 2) {
            appendable.append(PrivateIonTextAppender.ZERO_PADDING[2 - string.length()]);
        }
        appendable.append(string);
    }

    private static void printCodePointAsFourHexDigits(Appendable appendable, int n) throws IOException {
        String string = Integer.toHexString(n);
        appendable.append("\\u");
        appendable.append(PrivateIonTextAppender.ZERO_PADDING[4 - string.length()]);
        appendable.append(string);
    }

    private static void printCodePointAsEightHexDigits(Appendable appendable, int n) throws IOException {
        String string = Integer.toHexString(n);
        appendable.append("\\U");
        appendable.append(PrivateIonTextAppender.ZERO_PADDING[8 - string.length()]);
        appendable.append(string);
    }

    private static void printCodePointAsSurrogatePairHexDigits(Appendable appendable, int n) throws IOException {
        for (char c : Character.toChars(n)) {
            IonTextUtils.printCodePointAsFourHexDigits(appendable, c);
        }
    }

    public static void printString(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            appendable.append("null.string");
        } else {
            appendable.append('\"');
            IonTextUtils.printCodePoints(appendable, charSequence, EscapeMode.ION_STRING);
            appendable.append('\"');
        }
    }

    public static void printJsonString(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            appendable.append("null");
        } else {
            appendable.append('\"');
            IonTextUtils.printCodePoints(appendable, charSequence, EscapeMode.JSON);
            appendable.append('\"');
        }
    }

    public static String printString(CharSequence charSequence) {
        if (charSequence == null) {
            return "null.string";
        }
        if (charSequence.length() == 0) {
            return "\"\"";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
        try {
            IonTextUtils.printString(stringBuilder, charSequence);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static String printLongString(CharSequence charSequence) {
        if (charSequence == null) {
            return "null.string";
        }
        if (charSequence.length() == 0) {
            return "''''''";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 6);
        try {
            IonTextUtils.printLongString(stringBuilder, charSequence);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static void printLongString(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            appendable.append("null.string");
        } else {
            appendable.append("'''");
            IonTextUtils.printCodePoints(appendable, charSequence, EscapeMode.ION_LONG_STRING);
            appendable.append("'''");
        }
    }

    public static String printCodePointAsString(int n) {
        StringBuilder stringBuilder = new StringBuilder(12);
        stringBuilder.append('\"');
        try {
            IonTextUtils.printStringCodePoint(stringBuilder, n);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static void printSymbol(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            appendable.append("null.symbol");
        } else if (PrivateIonTextAppender.symbolNeedsQuoting(charSequence, true)) {
            IonTextUtils.printQuotedSymbol(appendable, charSequence);
        } else {
            appendable.append(charSequence);
        }
    }

    public static String printSymbol(CharSequence charSequence) {
        if (charSequence == null) {
            return "null.symbol";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
        try {
            IonTextUtils.printSymbol(stringBuilder, charSequence);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static void printQuotedSymbol(Appendable appendable, CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            appendable.append("null.symbol");
        } else {
            if (charSequence.length() == 0) {
                throw new EmptySymbolException();
            }
            appendable.append('\'');
            IonTextUtils.printCodePoints(appendable, charSequence, EscapeMode.ION_SYMBOL);
            appendable.append('\'');
        }
    }

    public static String printQuotedSymbol(CharSequence charSequence) {
        if (charSequence == null) {
            return "null.symbol";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 2);
        try {
            IonTextUtils.printQuotedSymbol(stringBuilder, charSequence);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    private static void printCodePoints(Appendable appendable, CharSequence charSequence, EscapeMode escapeMode) throws IOException {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2 = charSequence.charAt(i);
            if (PrivateIonConstants.isHighSurrogate(n2)) {
                char c;
                if (++i >= n || !PrivateIonConstants.isLowSurrogate(c = charSequence.charAt(i))) {
                    String string = "text is invalid UTF-16. It contains an unmatched high surrogate 0x" + Integer.toHexString(n2) + " at index " + i;
                    throw new IllegalArgumentException(string);
                }
                n2 = PrivateIonConstants.makeUnicodeScalar(n2, c);
            } else if (PrivateIonConstants.isLowSurrogate(n2)) {
                String string = "text is invalid UTF-16. It contains an unmatched low surrogate 0x" + Integer.toHexString(n2) + " at index " + i;
                throw new IllegalArgumentException(string);
            }
            IonTextUtils.printCodePoint(appendable, n2, escapeMode);
        }
    }

    public static void printDecimal(Appendable appendable, BigDecimal bigDecimal) throws IOException {
        PrivateIonTextAppender privateIonTextAppender = PrivateIonTextAppender.forAppendable(appendable);
        privateIonTextAppender.printDecimal(PrivateIonTextWriterBuilder.STANDARD, bigDecimal);
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "null.decimal";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            IonTextUtils.printDecimal(stringBuilder, bigDecimal);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static void printFloat(Appendable appendable, double d) throws IOException {
        PrivateIonTextAppender privateIonTextAppender = PrivateIonTextAppender.forAppendable(appendable);
        privateIonTextAppender.printFloat(d);
    }

    public static String printFloat(double d) {
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            IonTextUtils.printFloat((Appendable)stringBuilder, d);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static void printFloat(Appendable appendable, Double d) throws IOException {
        PrivateIonTextAppender privateIonTextAppender = PrivateIonTextAppender.forAppendable(appendable);
        privateIonTextAppender.printFloat(d);
    }

    public static String printFloat(Double d) {
        if (d == null) {
            return "null.float";
        }
        return IonTextUtils.printFloat((double)d);
    }

    public static void printBlob(Appendable appendable, byte[] byArray) throws IOException {
        if (byArray == null) {
            appendable.append("null.blob");
        } else {
            PrivateIonTextAppender privateIonTextAppender = PrivateIonTextAppender.forAppendable(appendable);
            privateIonTextAppender.printBlob(PrivateIonTextWriterBuilder.STANDARD, byArray, 0, byArray.length);
        }
    }

    public static String printBlob(byte[] byArray) {
        if (byArray == null) {
            return "null.blob";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            IonTextUtils.printBlob(stringBuilder, byArray);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    public static void printClob(Appendable appendable, byte[] byArray) throws IOException {
        if (byArray == null) {
            appendable.append("null.clob");
        } else {
            PrivateIonTextAppender privateIonTextAppender = PrivateIonTextAppender.forAppendable(appendable);
            privateIonTextAppender.printClob(PrivateIonTextWriterBuilder.STANDARD, byArray, 0, byArray.length);
        }
    }

    public static String printClob(byte[] byArray) {
        if (byArray == null) {
            return "null.clob";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            IonTextUtils.printClob(stringBuilder, byArray);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return stringBuilder.toString();
    }

    private static enum EscapeMode {
        JSON,
        ION_SYMBOL,
        ION_STRING,
        ION_LONG_STRING;

    }

    public static enum SymbolVariant {
        IDENTIFIER,
        OPERATOR,
        QUOTED;

    }
}

