/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.system;

import java.nio.charset.Charset;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.impl.PrivateIonTextWriterBuilder;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.system.IonWriterBuilder;
import software.amazon.ion.system.IonWriterBuilderBase;

public abstract class IonTextWriterBuilder
extends IonWriterBuilderBase<IonTextWriterBuilder> {
    public static final Charset ASCII = PrivateUtils.ASCII_CHARSET;
    public static final Charset UTF8 = PrivateUtils.UTF8_CHARSET;
    private Charset myCharset;
    private IonWriterBuilder.InitialIvmHandling myInitialIvmHandling;
    private IonWriterBuilder.IvmMinimizing myIvmMinimizing;
    private LstMinimizing myLstMinimizing;
    private int myLongStringThreshold;

    public static IonTextWriterBuilder standard() {
        return PrivateIonTextWriterBuilder.standard();
    }

    public static IonTextWriterBuilder minimal() {
        return IonTextWriterBuilder.standard().withMinimalSystemData();
    }

    public static IonTextWriterBuilder pretty() {
        return IonTextWriterBuilder.standard().withPrettyPrinting();
    }

    public static IonTextWriterBuilder json() {
        return IonTextWriterBuilder.standard().withJsonDowngrade();
    }

    protected IonTextWriterBuilder() {
    }

    protected IonTextWriterBuilder(IonTextWriterBuilder ionTextWriterBuilder) {
        super(ionTextWriterBuilder);
        this.myCharset = ionTextWriterBuilder.myCharset;
        this.myInitialIvmHandling = ionTextWriterBuilder.myInitialIvmHandling;
        this.myIvmMinimizing = ionTextWriterBuilder.myIvmMinimizing;
        this.myLstMinimizing = ionTextWriterBuilder.myLstMinimizing;
        this.myLongStringThreshold = ionTextWriterBuilder.myLongStringThreshold;
    }

    @Override
    public abstract IonTextWriterBuilder copy();

    @Override
    public abstract IonTextWriterBuilder immutable();

    @Override
    public abstract IonTextWriterBuilder mutable();

    @Override
    public final IonTextWriterBuilder withCatalog(IonCatalog ionCatalog) {
        return (IonTextWriterBuilder)super.withCatalog(ionCatalog);
    }

    @Override
    public final IonTextWriterBuilder withImports(SymbolTable ... symbolTableArray) {
        return (IonTextWriterBuilder)super.withImports(symbolTableArray);
    }

    public final Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.mutationCheck();
        if (charset != null && !charset.equals(ASCII) && !charset.equals(UTF8)) {
            throw new IllegalArgumentException("Unsupported Charset " + charset);
        }
        this.myCharset = charset;
    }

    public final IonTextWriterBuilder withCharset(Charset charset) {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setCharset(charset);
        return ionTextWriterBuilder;
    }

    public final IonTextWriterBuilder withCharsetAscii() {
        return this.withCharset(ASCII);
    }

    public final IonTextWriterBuilder withMinimalSystemData() {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setInitialIvmHandling(IonWriterBuilder.InitialIvmHandling.SUPPRESS);
        ionTextWriterBuilder.setIvmMinimizing(IonWriterBuilder.IvmMinimizing.DISTANT);
        ionTextWriterBuilder.setLstMinimizing(LstMinimizing.EVERYTHING);
        return ionTextWriterBuilder;
    }

    public abstract IonTextWriterBuilder withPrettyPrinting();

    public abstract IonTextWriterBuilder withJsonDowngrade();

    @Override
    public final IonWriterBuilder.InitialIvmHandling getInitialIvmHandling() {
        return this.myInitialIvmHandling;
    }

    public void setInitialIvmHandling(IonWriterBuilder.InitialIvmHandling initialIvmHandling) {
        this.mutationCheck();
        this.myInitialIvmHandling = initialIvmHandling;
    }

    public final IonTextWriterBuilder withInitialIvmHandling(IonWriterBuilder.InitialIvmHandling initialIvmHandling) {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setInitialIvmHandling(initialIvmHandling);
        return ionTextWriterBuilder;
    }

    @Override
    public final IonWriterBuilder.IvmMinimizing getIvmMinimizing() {
        return this.myIvmMinimizing;
    }

    public void setIvmMinimizing(IonWriterBuilder.IvmMinimizing ivmMinimizing) {
        this.mutationCheck();
        this.myIvmMinimizing = ivmMinimizing;
    }

    public final IonTextWriterBuilder withIvmMinimizing(IonWriterBuilder.IvmMinimizing ivmMinimizing) {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setIvmMinimizing(ivmMinimizing);
        return ionTextWriterBuilder;
    }

    public final LstMinimizing getLstMinimizing() {
        return this.myLstMinimizing;
    }

    public void setLstMinimizing(LstMinimizing lstMinimizing) {
        this.mutationCheck();
        this.myLstMinimizing = lstMinimizing;
    }

    public final IonTextWriterBuilder withLstMinimizing(LstMinimizing lstMinimizing) {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setLstMinimizing(lstMinimizing);
        return ionTextWriterBuilder;
    }

    public final int getLongStringThreshold() {
        return this.myLongStringThreshold;
    }

    public void setLongStringThreshold(int n) {
        this.mutationCheck();
        this.myLongStringThreshold = n;
    }

    public final IonTextWriterBuilder withLongStringThreshold(int n) {
        IonTextWriterBuilder ionTextWriterBuilder = this.mutable();
        ionTextWriterBuilder.setLongStringThreshold(n);
        return ionTextWriterBuilder;
    }

    public abstract IonWriter build(Appendable var1);

    public static enum LstMinimizing {
        LOCALS,
        EVERYTHING;

    }
}

