/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.system;

import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonSystem;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.impl.PrivateIonBinaryWriterBuilder;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.PrivateLiteDomTrampoline;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.system.SimpleCatalog;

public class IonSystemBuilder {
    private static final IonSystemBuilder STANDARD = new IonSystemBuilder();
    IonCatalog myCatalog;
    boolean myStreamCopyOptimized = false;

    public static IonSystemBuilder standard() {
        return STANDARD;
    }

    private IonSystemBuilder() {
    }

    private IonSystemBuilder(IonSystemBuilder ionSystemBuilder) {
        this.myCatalog = ionSystemBuilder.myCatalog;
        this.myStreamCopyOptimized = ionSystemBuilder.myStreamCopyOptimized;
    }

    public final IonSystemBuilder copy() {
        return new Mutable(this);
    }

    public IonSystemBuilder immutable() {
        return this;
    }

    public IonSystemBuilder mutable() {
        return this.copy();
    }

    void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public final IonCatalog getCatalog() {
        return this.myCatalog;
    }

    public final void setCatalog(IonCatalog ionCatalog) {
        this.mutationCheck();
        this.myCatalog = ionCatalog;
    }

    public final IonSystemBuilder withCatalog(IonCatalog ionCatalog) {
        IonSystemBuilder ionSystemBuilder = this.mutable();
        ionSystemBuilder.setCatalog(ionCatalog);
        return ionSystemBuilder;
    }

    public final boolean isStreamCopyOptimized() {
        return this.myStreamCopyOptimized;
    }

    public final void setStreamCopyOptimized(boolean bl) {
        this.mutationCheck();
        this.myStreamCopyOptimized = bl;
    }

    public final IonSystemBuilder withStreamCopyOptimized(boolean bl) {
        IonSystemBuilder ionSystemBuilder = this.mutable();
        ionSystemBuilder.setStreamCopyOptimized(bl);
        return ionSystemBuilder;
    }

    public final IonSystem build() {
        IonCatalog ionCatalog = this.myCatalog != null ? this.myCatalog : new SimpleCatalog();
        IonTextWriterBuilder ionTextWriterBuilder = IonTextWriterBuilder.standard().withCharsetAscii();
        ionTextWriterBuilder.setCatalog(ionCatalog);
        PrivateIonBinaryWriterBuilder privateIonBinaryWriterBuilder = PrivateIonBinaryWriterBuilder.standard();
        privateIonBinaryWriterBuilder.setCatalog(ionCatalog);
        privateIonBinaryWriterBuilder.setStreamCopyOptimized(this.myStreamCopyOptimized);
        SymbolTable symbolTable = PrivateUtils.systemSymtab(1);
        privateIonBinaryWriterBuilder.setInitialSymbolTable(symbolTable);
        return PrivateLiteDomTrampoline.newLiteSystem(ionTextWriterBuilder, privateIonBinaryWriterBuilder);
    }

    private static final class Mutable
    extends IonSystemBuilder {
        private Mutable(IonSystemBuilder ionSystemBuilder) {
            super(ionSystemBuilder);
        }

        @Override
        public IonSystemBuilder immutable() {
            return new IonSystemBuilder(this);
        }

        @Override
        public IonSystemBuilder mutable() {
            return this;
        }

        @Override
        void mutationCheck() {
        }
    }
}

