/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import software.amazon.ion.ContainedValueException;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonException;
import software.amazon.ion.IonValue;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ReadOnlyValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonContainer;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonDatagramLite;
import software.amazon.ion.impl.lite.IonValueLite;
import software.amazon.ion.impl.lite.TopLevelContext;

abstract class IonContainerLite
extends IonValueLite
implements PrivateIonContainer,
IonContext {
    protected int _child_count;
    protected IonValueLite[] _children;
    static final int[] INITIAL_SIZE = IonContainerLite.make_initial_size_array();
    static final int[] NEXT_SIZE = IonContainerLite.make_next_size_array();

    protected IonContainerLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonContainerLite(IonContainerLite ionContainerLite, IonContext ionContext, boolean bl) {
        super(ionContainerLite, ionContext);
        int n;
        this._child_count = n = ionContainerLite._child_count;
        if (ionContainerLite._children != null) {
            boolean bl2 = this instanceof IonDatagramLite;
            this._children = new IonValueLite[n];
            for (int i = 0; i < n; ++i) {
                IonValueLite ionValueLite = ionContainerLite._children[i];
                IonContainerLite ionContainerLite2 = bl2 ? TopLevelContext.wrap(ionValueLite.getAssignedSymbolTable(), (IonDatagramLite)this) : this;
                IonValueLite ionValueLite2 = ionValueLite.clone(ionContainerLite2);
                if (bl) {
                    ionValueLite2.setFieldName(ionValueLite.getFieldName());
                }
                this._children[i] = ionValueLite2;
            }
        }
    }

    @Override
    public abstract void accept(ValueVisitor var1) throws Exception;

    @Override
    public abstract IonContainer clone();

    @Override
    public void clear() {
        this.checkForLock();
        if (this._isNullValue()) {
            assert (this._children == null);
            assert (this._child_count == 0);
            this._isNullValue(false);
        } else if (!this.isEmpty()) {
            this.detachAllChildren();
            this._child_count = 0;
        }
    }

    private void detachAllChildren() {
        for (int i = 0; i < this._child_count; ++i) {
            IonValueLite ionValueLite = this._children[i];
            ionValueLite.detachFromContainer();
            this._children[i] = null;
        }
    }

    @Override
    public boolean isEmpty() throws NullValueException {
        this.validateThisNotNull();
        return this.size() == 0;
    }

    public IonValue get(int n) throws NullValueException {
        this.validateThisNotNull();
        IonValueLite ionValueLite = this.get_child(n);
        assert (!ionValueLite._isAutoCreated());
        return ionValueLite;
    }

    @Override
    public final Iterator<IonValue> iterator() {
        return this.listIterator(0);
    }

    public final ListIterator<IonValue> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<IonValue> listIterator(int n) {
        if (this.isNullValue()) {
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return PrivateUtils.emptyIterator();
        }
        return new SequenceContentIterator(n, this.isReadOnly());
    }

    @Override
    public void makeNull() {
        this.clear();
        this._isNullValue(true);
    }

    @Override
    public boolean remove(IonValue ionValue) {
        this.checkForLock();
        if (ionValue.getContainer() != this) {
            return false;
        }
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        int n = ionValueLite._elementid();
        IonValueLite ionValueLite2 = this.get_child(n);
        if (ionValueLite2 == ionValueLite) {
            this.remove_child(n);
            this.patch_elements_helper(n);
            return true;
        }
        throw new AssertionError((Object)"element's index is not correct");
    }

    @Override
    public int size() {
        if (this.isNullValue()) {
            return 0;
        }
        return this.get_child_count();
    }

    @Override
    void makeReadOnlyInternal() {
        if (this._isLocked()) {
            return;
        }
        if (this._children != null) {
            for (int i = 0; i < this._child_count; ++i) {
                IonValueLite ionValueLite = this._children[i];
                ionValueLite.makeReadOnlyInternal();
            }
        }
        super.clearSymbolIDValues();
        this._isLocked(true);
    }

    @Override
    public final IonContainerLite getContextContainer() {
        return this;
    }

    @Override
    public final SymbolTable getContextSymbolTable() {
        return null;
    }

    @Override
    void clearSymbolIDValues() {
        super.clearSymbolIDValues();
        for (int i = 0; i < this.get_child_count(); ++i) {
            IonValueLite ionValueLite = this.get_child(i);
            ionValueLite.clearSymbolIDValues();
        }
    }

    public boolean add(IonValue ionValue) throws NullPointerException, IllegalArgumentException, ContainedValueException {
        int n = this.get_child_count();
        this.add(n, (IonValueLite)ionValue);
        return true;
    }

    void validateNewChild(IonValue ionValue) throws ContainedValueException, NullPointerException, IllegalArgumentException {
        if (ionValue.getContainer() != null) {
            throw new ContainedValueException();
        }
        if (ionValue.isReadOnly()) {
            throw new ReadOnlyValueException();
        }
        if (ionValue instanceof IonDatagram) {
            String string = "IonDatagram can not be inserted into another IonContainer.";
            throw new IllegalArgumentException(string);
        }
        assert (ionValue instanceof IonValueLite) : "Child was not created by the same ValueFactory";
        assert (this.getSystem() == ionValue.getSystem() || this.getSystem().getClass().equals(ionValue.getSystem().getClass()));
    }

    void add(int n, IonValueLite ionValueLite) throws ContainedValueException, NullPointerException {
        if (n < 0 || n > this.get_child_count()) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForLock();
        this.validateNewChild(ionValueLite);
        this.add_child(n, ionValueLite);
        this.patch_elements_helper(n + 1);
        assert (n >= 0 && n < this.get_child_count() && ionValueLite == this.get_child(n) && ionValueLite._elementid() == n);
    }

    static int[] make_initial_size_array() {
        int[] nArray = new int[17];
        nArray[11] = 1;
        nArray[12] = 4;
        nArray[13] = 5;
        nArray[16] = 3;
        return nArray;
    }

    static int[] make_next_size_array() {
        int[] nArray = new int[17];
        nArray[11] = 4;
        nArray[12] = 8;
        nArray[13] = 8;
        nArray[16] = 10;
        return nArray;
    }

    protected final int initialSize() {
        switch (this.getType()) {
            case LIST: {
                return 1;
            }
            case SEXP: {
                return 4;
            }
            case STRUCT: {
                return 5;
            }
            case DATAGRAM: {
                return 3;
            }
        }
        return 4;
    }

    protected final int nextSize(int n, boolean bl) {
        int n2;
        if (n == 0) {
            int n3 = this.initialSize();
            return n3;
        }
        switch (this.getType()) {
            case LIST: {
                n2 = 4;
                break;
            }
            case SEXP: {
                n2 = 8;
                break;
            }
            case STRUCT: {
                n2 = 8;
                break;
            }
            case DATAGRAM: {
                n2 = 10;
                break;
            }
            default: {
                return n * 2;
            }
        }
        if (n2 > n) {
            if (bl) {
                this.transitionToLargeSize(n2);
            }
        } else {
            n2 = n * 2;
        }
        return n2;
    }

    void transitionToLargeSize(int n) {
    }

    @Override
    public final int get_child_count() {
        return this._child_count;
    }

    @Override
    public final IonValueLite get_child(int n) {
        if (n < 0 || n >= this._child_count) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this._children[n];
    }

    final IonValueLite set_child(int n, IonValueLite ionValueLite) {
        if (n < 0 || n >= this._child_count) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (ionValueLite == null) {
            throw new NullPointerException();
        }
        IonValueLite ionValueLite2 = this._children[n];
        this._children[n] = ionValueLite;
        return ionValueLite2;
    }

    protected int add_child(int n, IonValueLite ionValueLite) {
        this._isNullValue(false);
        ionValueLite.setContext(this.getContextForIndex(ionValueLite, n));
        if (this._children == null || this._child_count >= this._children.length) {
            int n2 = this._children == null ? 0 : this._children.length;
            int n3 = this.nextSize(n2, true);
            assert (n3 > n);
            IonValueLite[] ionValueLiteArray = new IonValueLite[n3];
            if (n2 > 0) {
                System.arraycopy(this._children, 0, ionValueLiteArray, 0, n2);
            }
            this._children = ionValueLiteArray;
        }
        if (n < this._child_count) {
            System.arraycopy(this._children, n, this._children, n + 1, this._child_count - n);
        }
        ++this._child_count;
        this._children[n] = ionValueLite;
        ionValueLite._elementid(n);
        return n;
    }

    IonContext getContextForIndex(IonValue ionValue, int n) {
        return this;
    }

    void remove_child(int n) {
        assert (n >= 0);
        assert (n < this.get_child_count());
        assert (this.get_child(n) != null) : "No child at index " + n;
        this._children[n].detachFromContainer();
        int n2 = this._child_count - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._children, n + 1, this._children, n, n2);
        }
        --this._child_count;
        this._children[this._child_count] = null;
    }

    public final void patch_elements_helper(int n) {
        for (int i = n; i < this.get_child_count(); ++i) {
            IonValueLite ionValueLite = this.get_child(i);
            ionValueLite._elementid(i);
        }
    }

    protected class SequenceContentIterator
    implements ListIterator<IonValue> {
        protected final boolean __readOnly;
        protected boolean __lastMoveWasPrevious;
        protected int __pos;
        protected IonValueLite __current;

        public SequenceContentIterator(int n, boolean bl) {
            if (IonContainerLite.this._isLocked() && !bl) {
                throw new IllegalStateException("you can't open an updatable iterator on a read only value");
            }
            if (n < 0 || n > IonContainerLite.this._child_count) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            this.__pos = n;
            this.__readOnly = bl;
        }

        protected final void force_position_sync() {
            if (this.__pos <= 0 || this.__pos > IonContainerLite.this._child_count) {
                return;
            }
            if (this.__current == null || this.__current == IonContainerLite.this._children[this.__pos - 1]) {
                return;
            }
            this.force_position_sync_helper();
        }

        private final void force_position_sync_helper() {
            int n;
            if (this.__readOnly) {
                throw new IonException("read only sequence was changed");
            }
            for (n = this.__pos; n < IonContainerLite.this._child_count; ++n) {
                if (IonContainerLite.this._children[n] != this.__current) continue;
                this.__pos = n;
                if (!this.__lastMoveWasPrevious) {
                    ++this.__pos;
                }
                return;
            }
            for (n = this.__pos - 1; n >= 0; --n) {
                if (IonContainerLite.this._children[n] != this.__current) continue;
                this.__pos = n;
                if (!this.__lastMoveWasPrevious) {
                    ++this.__pos;
                }
                return;
            }
            throw new IonException("current member of iterator has been removed from the containing sequence");
        }

        @Override
        public void add(IonValue ionValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return this.nextIndex() < IonContainerLite.this._child_count;
        }

        @Override
        public final boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public IonValue next() {
            int n = this.nextIndex();
            if (n >= IonContainerLite.this._child_count) {
                throw new NoSuchElementException();
            }
            this.__current = IonContainerLite.this._children[n];
            this.__pos = n + 1;
            this.__lastMoveWasPrevious = false;
            return this.__current;
        }

        @Override
        public final int nextIndex() {
            this.force_position_sync();
            if (this.__pos >= IonContainerLite.this._child_count) {
                return IonContainerLite.this._child_count;
            }
            int n = this.__pos;
            return n;
        }

        @Override
        public IonValue previous() {
            this.force_position_sync();
            int n = this.previousIndex();
            if (n < 0) {
                throw new NoSuchElementException();
            }
            this.__current = IonContainerLite.this._children[n];
            this.__pos = n;
            this.__lastMoveWasPrevious = true;
            return this.__current;
        }

        @Override
        public final int previousIndex() {
            this.force_position_sync();
            int n = this.__pos - 1;
            if (n < 0) {
                return -1;
            }
            return n;
        }

        @Override
        public void remove() {
            if (this.__readOnly) {
                throw new UnsupportedOperationException();
            }
            this.force_position_sync();
            int n = this.__pos;
            if (!this.__lastMoveWasPrevious) {
                --n;
            }
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            IonValueLite ionValueLite = this.__current;
            int n2 = ionValueLite._elementid();
            assert (n2 == n);
            IonContainerLite.this.remove_child(n);
            IonContainerLite.this.patch_elements_helper(n2);
            if (!this.__lastMoveWasPrevious) {
                --this.__pos;
            }
            this.__current = null;
        }

        @Override
        public void set(IonValue ionValue) {
            throw new UnsupportedOperationException();
        }
    }
}

