/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import software.amazon.ion.IonBool;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonBoolLite
extends IonValueLite
implements IonBool {
    private static final int HASH_SIGNATURE = IonType.BOOL.toString().hashCode();
    protected static final int TRUE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.TRUE.hashCode();
    protected static final int FALSE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.FALSE.hashCode();

    IonBoolLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonBoolLite(IonBoolLite ionBoolLite, IonContext ionContext) {
        super(ionBoolLite, ionContext);
    }

    @Override
    IonBoolLite clone(IonContext ionContext) {
        return new IonBoolLite(this, ionContext);
    }

    @Override
    public IonBoolLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    public IonType getType() {
        return IonType.BOOL;
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            n = this.booleanValue() ? TRUE_HASH : FALSE_HASH;
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public boolean booleanValue() throws NullValueException {
        this.validateThisNotNull();
        return this._isBoolTrue();
    }

    @Override
    public void setValue(boolean bl) {
        this.setValue((Boolean)bl);
    }

    @Override
    public void setValue(Boolean bl) {
        this.checkForLock();
        if (bl == null) {
            this._isBoolTrue(false);
            this._isNullValue(true);
        } else {
            this._isBoolTrue(bl);
            this._isNullValue(false);
        }
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            ionWriter.writeNull(IonType.BOOL);
        } else {
            ionWriter.writeBool(this._isBoolTrue());
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

