/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.ion.IonException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.bin.AbstractSymbolTable;

class Symbols {
    private static final List<SymbolToken> SYSTEM_TOKENS = Collections.unmodifiableList(Arrays.asList(Symbols.symbol("$ion", 1), Symbols.symbol("$ion_1_0", 2), Symbols.symbol("$ion_symbol_table", 3), Symbols.symbol("name", 4), Symbols.symbol("version", 5), Symbols.symbol("imports", 6), Symbols.symbol("symbols", 7), Symbols.symbol("max_id", 8), Symbols.symbol("$ion_shared_symbol_table", 9)));
    private static final Map<String, SymbolToken> SYSTEM_TOKEN_MAP;
    private static SymbolTable SYSTEM_SYMBOL_TABLE;

    private Symbols() {
    }

    public static SymbolToken symbol(final String string, final int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Symbol value must be positive: " + n);
        }
        return new SymbolToken(){

            @Override
            public String getText() {
                return string;
            }

            @Override
            public String assumeText() {
                return string;
            }

            @Override
            public int getSid() {
                return n;
            }

            public String toString() {
                return "(symbol '" + this.getText() + "' " + this.getSid() + ")";
            }
        };
    }

    public static Iterator<String> symbolNameIterator(final Iterator<SymbolToken> iterator2) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public String next() {
                return ((SymbolToken)iterator2.next()).getText();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static SymbolToken systemSymbol(int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("No such system SID: " + n);
        }
        return SYSTEM_TOKENS.get(n - 1);
    }

    public static SymbolTable systemSymbolTable() {
        return SYSTEM_SYMBOL_TABLE;
    }

    public static Collection<SymbolToken> systemSymbols() {
        return SYSTEM_TOKENS;
    }

    public static SymbolTable unknownSharedSymbolTable(final String string, final int n, final int n2) {
        return new AbstractSymbolTable(string, n){

            @Override
            public Iterator<String> iterateDeclaredSymbolNames() {
                return new Iterator<String>(){
                    int id = 1;

                    @Override
                    public boolean hasNext() {
                        return this.id <= n2;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.id;
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean isSystemTable() {
                return false;
            }

            @Override
            public boolean isSubstitute() {
                return true;
            }

            @Override
            public boolean isSharedTable() {
                return true;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public boolean isLocalTable() {
                return false;
            }

            @Override
            public SymbolToken intern(String string2) {
                throw new UnsupportedOperationException("Cannot intern into substitute unknown shared symbol table: " + string + " version " + n);
            }

            @Override
            public SymbolTable getSystemSymbolTable() {
                return Symbols.systemSymbolTable();
            }

            @Override
            public int getMaxId() {
                return n2;
            }

            @Override
            public SymbolTable[] getImportedTables() {
                return null;
            }

            @Override
            public int getImportedMaxId() {
                return 0;
            }

            @Override
            public String findKnownSymbol(int n3) {
                return null;
            }

            @Override
            public SymbolToken find(String string2) {
                return null;
            }
        };
    }

    static {
        HashMap<String, SymbolToken> hashMap = new HashMap<String, SymbolToken>();
        for (SymbolToken symbolToken : SYSTEM_TOKENS) {
            hashMap.put(symbolToken.getText(), symbolToken);
        }
        SYSTEM_TOKEN_MAP = Collections.unmodifiableMap(hashMap);
        SYSTEM_SYMBOL_TABLE = new AbstractSymbolTable("$ion", 1){

            @Override
            public SymbolTable[] getImportedTables() {
                return null;
            }

            @Override
            public int getImportedMaxId() {
                return 0;
            }

            @Override
            public boolean isSystemTable() {
                return true;
            }

            @Override
            public boolean isSubstitute() {
                return false;
            }

            @Override
            public boolean isSharedTable() {
                return true;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public boolean isLocalTable() {
                return false;
            }

            @Override
            public SymbolToken intern(String string) {
                SymbolToken symbolToken = (SymbolToken)SYSTEM_TOKEN_MAP.get(string);
                if (symbolToken == null) {
                    throw new IonException("Cannot intern new symbol into system symbol table");
                }
                return symbolToken;
            }

            @Override
            public String findKnownSymbol(int n) {
                if (n < 1) {
                    throw new IllegalArgumentException("SID cannot be less than 1: " + n);
                }
                if (n > 9) {
                    return null;
                }
                return ((SymbolToken)SYSTEM_TOKENS.get(n - 1)).getText();
            }

            @Override
            public SymbolToken find(String string) {
                return (SymbolToken)SYSTEM_TOKEN_MAP.get(string);
            }

            @Override
            public SymbolTable getSystemSymbolTable() {
                return this;
            }

            @Override
            public int getMaxId() {
                return 9;
            }

            @Override
            public Iterator<String> iterateDeclaredSymbolNames() {
                return Symbols.symbolNameIterator(SYSTEM_TOKENS.iterator());
            }
        };
    }
}

