/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonValue;
import software.amazon.ion.impl.IonReaderBinarySystemX;
import software.amazon.ion.impl.IonReaderBinaryUserX;
import software.amazon.ion.impl.IonReaderTextSystemX;
import software.amazon.ion.impl.IonReaderTextUserX;
import software.amazon.ion.impl.IonReaderTreeSystem;
import software.amazon.ion.impl.IonReaderTreeUserX;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.util.IonStreamUtils;

@Deprecated
public final class PrivateIonReaderFactory {
    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, byte[] byArray) {
        return PrivateIonReaderFactory.makeReader(ionSystem, ionCatalog, byArray, 0, byArray.length);
    }

    public static IonReader makeSystemReader(IonSystem ionSystem, byte[] byArray) {
        return PrivateIonReaderFactory.makeSystemReader(ionSystem, byArray, 0, byArray.length);
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, byte[] byArray, int n, int n2) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = PrivateIonReaderFactory.makeUnifiedStream(byArray, n, n2);
            return PrivateIonReaderFactory.makeReader(ionSystem, ionCatalog, unifiedInputStreamX, n);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static IonReader makeSystemReader(IonSystem ionSystem, byte[] byArray, int n, int n2) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = PrivateIonReaderFactory.makeUnifiedStream(byArray, n, n2);
            return PrivateIonReaderFactory.makeSystemReader(ionSystem, unifiedInputStreamX, n);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, char[] cArray) {
        return PrivateIonReaderFactory.makeReader(ionSystem, ionCatalog, cArray, 0, cArray.length);
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, char[] cArray) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(cArray);
        return new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, char[] cArray, int n, int n2) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(cArray, n, n2);
        return new IonReaderTextUserX(ionSystem, ionCatalog, unifiedInputStreamX, n);
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, char[] cArray, int n, int n2) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(cArray, n, n2);
        return new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, CharSequence charSequence) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(charSequence);
        return new IonReaderTextUserX(ionSystem, ionCatalog, unifiedInputStreamX);
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, CharSequence charSequence) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(charSequence);
        return new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, CharSequence charSequence, int n, int n2) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(charSequence, n, n2);
        return new IonReaderTextUserX(ionSystem, ionCatalog, unifiedInputStreamX, n);
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, CharSequence charSequence, int n, int n2) {
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(charSequence, n, n2);
        return new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, InputStream inputStream2) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = PrivateIonReaderFactory.makeUnifiedStream(inputStream2);
            return PrivateIonReaderFactory.makeReader(ionSystem, ionCatalog, unifiedInputStreamX, 0);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static IonReader makeSystemReader(IonSystem ionSystem, InputStream inputStream2) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = PrivateIonReaderFactory.makeUnifiedStream(inputStream2);
            return PrivateIonReaderFactory.makeSystemReader(ionSystem, unifiedInputStreamX, 0);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, Reader reader) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(reader);
            return new IonReaderTextUserX(ionSystem, ionCatalog, unifiedInputStreamX);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, Reader reader) {
        try {
            UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(reader);
            return new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    public static final IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, IonValue ionValue) {
        return new IonReaderTreeUserX(ionValue, ionCatalog);
    }

    public static final IonReader makeSystemReader(IonSystem ionSystem, IonValue ionValue) {
        if (ionSystem != null && ionSystem != ionValue.getSystem()) {
            throw new IonException("you can't mix values from different systems");
        }
        return new IonReaderTreeSystem(ionValue);
    }

    private static IonReader makeReader(IonSystem ionSystem, IonCatalog ionCatalog, UnifiedInputStreamX unifiedInputStreamX, int n) throws IOException {
        IonReader ionReader = PrivateIonReaderFactory.has_binary_cookie(unifiedInputStreamX) ? new IonReaderBinaryUserX(ionSystem, ionCatalog, unifiedInputStreamX, n) : new IonReaderTextUserX(ionSystem, ionCatalog, unifiedInputStreamX, n);
        return ionReader;
    }

    private static IonReader makeSystemReader(IonSystem ionSystem, UnifiedInputStreamX unifiedInputStreamX, int n) throws IOException {
        IonReader ionReader = PrivateIonReaderFactory.has_binary_cookie(unifiedInputStreamX) ? new IonReaderBinarySystemX(ionSystem, unifiedInputStreamX) : new IonReaderTextSystemX(ionSystem, unifiedInputStreamX);
        return ionReader;
    }

    private static UnifiedInputStreamX makeUnifiedStream(byte[] byArray, int n, int n2) throws IOException {
        UnifiedInputStreamX unifiedInputStreamX;
        if (IonStreamUtils.isGzip(byArray, n, n2)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            unifiedInputStreamX = UnifiedInputStreamX.makeStream(gZIPInputStream);
        } else {
            unifiedInputStreamX = UnifiedInputStreamX.makeStream(byArray, n, n2);
        }
        return unifiedInputStreamX;
    }

    private static UnifiedInputStreamX makeUnifiedStream(InputStream inputStream2) throws IOException {
        inputStream2.getClass();
        inputStream2 = IonStreamUtils.unGzip(inputStream2);
        UnifiedInputStreamX unifiedInputStreamX = UnifiedInputStreamX.makeStream(inputStream2);
        return unifiedInputStreamX;
    }

    private static final boolean has_binary_cookie(UnifiedInputStreamX unifiedInputStreamX) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[PrivateIonConstants.BINARY_VERSION_MARKER_SIZE];
        for (n2 = 0; n2 < PrivateIonConstants.BINARY_VERSION_MARKER_SIZE && (n = unifiedInputStreamX.read()) != -1; ++n2) {
            byArray[n2] = (byte)n;
        }
        n = n2;
        while (n > 0) {
            unifiedInputStreamX.unread(byArray[--n] & 0xFF);
        }
        n = IonStreamUtils.isIonBinary(byArray, 0, n2) ? 1 : 0;
        return n != 0;
    }
}

