/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.util.Arrays;
import java.util.List;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.SymbolTokenImpl;

final class LocalSymbolTableImports {
    private final SymbolTable[] myImports;
    private final int myMaxId;
    private final int[] myBaseSids;

    LocalSymbolTableImports(List<SymbolTable> list) {
        int n = list.size();
        this.myImports = list.toArray(new SymbolTable[n]);
        this.myBaseSids = new int[n];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    LocalSymbolTableImports(SymbolTable symbolTable, SymbolTable ... symbolTableArray) {
        assert (symbolTable.isSystemTable()) : "defaultSystemSymtab isn't a system symtab";
        if (symbolTableArray != null && symbolTableArray.length > 0) {
            if (symbolTableArray[0].isSystemTable()) {
                this.myImports = new SymbolTable[symbolTableArray.length];
                System.arraycopy(symbolTableArray, 0, this.myImports, 0, symbolTableArray.length);
            } else {
                this.myImports = new SymbolTable[symbolTableArray.length + 1];
                this.myImports[0] = symbolTable;
                System.arraycopy(symbolTableArray, 0, this.myImports, 1, symbolTableArray.length);
            }
        } else {
            this.myImports = new SymbolTable[]{symbolTable};
        }
        this.myBaseSids = new int[this.myImports.length];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    private static int prepBaseSids(int[] nArray, SymbolTable[] symbolTableArray) {
        SymbolTable symbolTable = symbolTableArray[0];
        assert (symbolTable.isSystemTable()) : "first symtab must be a system symtab";
        nArray[0] = 0;
        int n = symbolTable.getMaxId();
        for (int i = 1; i < symbolTableArray.length; ++i) {
            SymbolTable symbolTable2 = symbolTableArray[i];
            if (symbolTable2.isLocalTable() || symbolTable2.isSystemTable()) {
                String string = "only non-system shared tables can be imported";
                throw new IllegalArgumentException(string);
            }
            nArray[i] = n;
            n += symbolTableArray[i].getMaxId();
        }
        return n;
    }

    String findKnownSymbol(int n) {
        String string = null;
        if (n <= this.myMaxId) {
            int n2;
            int n3;
            int n4 = 0;
            for (n3 = 1; n3 < this.myImports.length && n > (n2 = this.myBaseSids[n3]); ++n3) {
                n4 = n2;
            }
            n2 = n - n4;
            string = this.myImports[n3 - 1].findKnownSymbol(n2);
        }
        return string;
    }

    int findSymbol(String string) {
        SymbolToken symbolToken = this.find(string);
        return symbolToken == null ? -1 : symbolToken.getSid();
    }

    SymbolToken find(String string) {
        for (int i = 0; i < this.myImports.length; ++i) {
            SymbolTable symbolTable = this.myImports[i];
            SymbolToken symbolToken = symbolTable.find(string);
            if (symbolToken == null) continue;
            int n = symbolToken.getSid() + this.myBaseSids[i];
            string = symbolToken.getText();
            assert (string != null);
            return new SymbolTokenImpl(string, n);
        }
        return null;
    }

    int getMaxId() {
        return this.myMaxId;
    }

    SymbolTable getSystemSymbolTable() {
        assert (this.myImports[0].isSystemTable());
        return this.myImports[0];
    }

    SymbolTable[] getImportedTables() {
        int n = this.myImports.length - 1;
        SymbolTable[] symbolTableArray = new SymbolTable[n];
        if (n > 0) {
            System.arraycopy(this.myImports, 1, symbolTableArray, 0, n);
        }
        return symbolTableArray;
    }

    SymbolTable[] getImportedTablesNoCopy() {
        return this.myImports;
    }

    public String toString() {
        return Arrays.toString(this.myImports);
    }

    boolean equalImports(LocalSymbolTableImports localSymbolTableImports) {
        return Arrays.equals(this.myImports, localSymbolTableImports.myImports);
    }
}

