/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.impl.PrivateScalarConversions;

final class IonTokenConstsX {
    public static final int TOKEN_ERROR = -1;
    public static final int TOKEN_EOF = 0;
    public static final int TOKEN_UNKNOWN_NUMERIC = 1;
    public static final int TOKEN_INT = 2;
    public static final int TOKEN_HEX = 3;
    public static final int TOKEN_DECIMAL = 4;
    public static final int TOKEN_FLOAT = 5;
    public static final int TOKEN_FLOAT_INF = 6;
    public static final int TOKEN_FLOAT_MINUS_INF = 7;
    public static final int TOKEN_TIMESTAMP = 8;
    public static final int TOKEN_SYMBOL_IDENTIFIER = 9;
    public static final int TOKEN_SYMBOL_QUOTED = 10;
    public static final int TOKEN_SYMBOL_OPERATOR = 11;
    public static final int TOKEN_STRING_DOUBLE_QUOTE = 12;
    public static final int TOKEN_STRING_TRIPLE_QUOTE = 13;
    public static final int TOKEN_DOT = 14;
    public static final int TOKEN_COMMA = 15;
    public static final int TOKEN_COLON = 16;
    public static final int TOKEN_DOUBLE_COLON = 17;
    public static final int TOKEN_OPEN_PAREN = 18;
    public static final int TOKEN_CLOSE_PAREN = 19;
    public static final int TOKEN_OPEN_BRACE = 20;
    public static final int TOKEN_CLOSE_BRACE = 21;
    public static final int TOKEN_OPEN_SQUARE = 22;
    public static final int TOKEN_CLOSE_SQUARE = 23;
    public static final int TOKEN_OPEN_DOUBLE_BRACE = 24;
    public static final int TOKEN_CLOSE_DOUBLE_BRACE = 25;
    public static final int TOKEN_BINARY = 26;
    public static final int TOKEN_MAX = 26;
    public static final int TOKEN_count = 27;
    public static final int KEYWORD_unrecognized = -1;
    public static final int KEYWORD_none = 0;
    public static final int KEYWORD_TRUE = 1;
    public static final int KEYWORD_FALSE = 2;
    public static final int KEYWORD_NULL = 3;
    public static final int KEYWORD_BOOL = 4;
    public static final int KEYWORD_INT = 5;
    public static final int KEYWORD_FLOAT = 6;
    public static final int KEYWORD_DECIMAL = 7;
    public static final int KEYWORD_TIMESTAMP = 8;
    public static final int KEYWORD_SYMBOL = 9;
    public static final int KEYWORD_STRING = 10;
    public static final int KEYWORD_BLOB = 11;
    public static final int KEYWORD_CLOB = 12;
    public static final int KEYWORD_LIST = 13;
    public static final int KEYWORD_SEXP = 14;
    public static final int KEYWORD_STRUCT = 15;
    public static final int KEYWORD_NAN = 16;
    public static final int KEYWORD_sid = 17;
    public static final char[] BLOB_TERMINATOR = new char[]{'}', '}'};
    public static final char[] CLOB_DOUBLE_QUOTED_TERMINATOR = new char[]{'\'', '\'', '\''};
    public static final char[] CLOB_TRIPLE_QUOTED_TERMINATOR = new char[]{'\"'};
    public static final boolean[] isBase64Character = IonTokenConstsX.makeBase64Array();
    public static final int base64FillerCharacter = 61;
    public static final int[] hexValue = IonTokenConstsX.makeHexValueArray();
    public static final boolean[] isHexDigit = IonTokenConstsX.makeHexDigitTestArray(hexValue);
    public static final int CLOB_CHARACTER_LIMIT = 255;
    public static final int ESCAPE_LITTLE_U_MINIMUM = 256;
    public static final int ESCAPE_BIG_U_MINIMUM = 65536;
    public static final int ESCAPE_HEX = -16;
    public static final int ESCAPE_BIG_U = -15;
    public static final int ESCAPE_LITTLE_U = -14;
    public static final int ESCAPE_REMOVES_NEWLINE2 = -13;
    public static final int ESCAPE_REMOVES_NEWLINE = -12;
    public static final int ESCAPE_NOT_DEFINED = -11;
    private static final int[] escapeCharactersValues = IonTokenConstsX.makeEscapeCharacterValuesArray();
    private static final String[] escapeCharacterImage = IonTokenConstsX.makeEscapeCharacterImageArray();
    private static final boolean[] invalidTerminatingCharsForInf = IonTokenConstsX.makeInvalidTerminatingCharsForInfArray();
    private static final boolean[] isValidExtendedSymbolCharacter = IonTokenConstsX.makeIsValidExtendedSymbolCharacterArray();
    private static final boolean[] isValidSymbolCharacter = IonTokenConstsX.makeIsValidSymbolCharacterArray();
    private static final boolean[] isValidStartSymbolCharacter = IonTokenConstsX.makeIsValidStartSymbolCharacterArray();
    static final int TN_MAX_NAME_LENGTH = "TIMESTAMP".length() + 1;
    static final int TN_LETTER_MAX_IDX = 19;
    static final int KW_BIT_BLOB = 1;
    static final int KW_BIT_BOOL = 2;
    static final int KW_BIT_CLOB = 4;
    static final int KW_BIT_DECIMAL = 8;
    static final int KW_BIT_FLOAT = 16;
    static final int KW_BIT_INT = 32;
    static final int KW_BIT_LIST = 48;
    static final int KW_BIT_NULL = 128;
    static final int KW_BIT_SEXP = 256;
    static final int KW_BIT_STRING = 512;
    static final int KW_BIT_STRUCT = 1024;
    static final int KW_BIT_SYMBOL = 2048;
    static final int KW_BIT_TIMESTAMP = 4096;
    static final int KW_ALL_BITS = 8191;
    static final int[] typeNameBits = new int[]{1, 2, 4, 8, 16, 32, 48, 128, 256, 512, 1024, 2048, 4096};
    static final String[] typeNameNames = new String[]{"blob", "bool", "clob", "decimal", "float", "int", "list", "null", "sexp", "string", "struct", "symbol", "timestamp"};
    static final int[] typeNameKeyWordIds = new int[]{11, 4, 12, 7, 6, 5, 13, 3, 14, 10, 15, 9, 8};
    static final int[] TypeNameBitIndex = IonTokenConstsX.makeTypeNameBitIndex();

    IonTokenConstsX() {
    }

    public static final String getTokenName(int n) {
        switch (n) {
            case -1: {
                return "TOKEN_ERROR";
            }
            case 0: {
                return "TOKEN_EOF";
            }
            case 1: {
                return "TOKEN_UNKNOWN_NUMERIC";
            }
            case 2: {
                return "TOKEN_INT";
            }
            case 3: {
                return "TOKEN_HEX";
            }
            case 4: {
                return "TOKEN_DECIMAL";
            }
            case 5: {
                return "TOKEN_FLOAT";
            }
            case 6: {
                return "TOKEN_FLOAT_INF";
            }
            case 7: {
                return "TOKEN_FLOAT_MINUS_INF";
            }
            case 8: {
                return "TOKEN_TIMESTAMP";
            }
            case 9: {
                return "TOKEN_SYMBOL_IDENTIFIER";
            }
            case 10: {
                return "TOKEN_SYMBOL_QUOTED";
            }
            case 11: {
                return "TOKEN_SYMBOL_OPERATOR";
            }
            case 12: {
                return "TOKEN_STRING_DOUBLE_QUOTE";
            }
            case 13: {
                return "TOKEN_STRING_TRIPLE_QUOTE";
            }
            case 14: {
                return "TOKEN_DOT";
            }
            case 15: {
                return "TOKEN_COMMA";
            }
            case 16: {
                return "TOKEN_COLON";
            }
            case 17: {
                return "TOKEN_DOUBLE_COLON";
            }
            case 18: {
                return "TOKEN_OPEN_PAREN";
            }
            case 19: {
                return "TOKEN_CLOSE_PAREN";
            }
            case 20: {
                return "TOKEN_OPEN_BRACE";
            }
            case 21: {
                return "TOKEN_CLOSE_BRACE";
            }
            case 22: {
                return "TOKEN_OPEN_SQUARE";
            }
            case 23: {
                return "TOKEN_CLOSE_SQUARE";
            }
            case 24: {
                return "TOKEN_OPEN_DOUBLE_BRACE";
            }
            case 25: {
                return "TOKEN_CLOSE_DOUBLE_BRACE";
            }
        }
        return "<invalid token " + n + ">";
    }

    public static final String describeToken(int n) {
        switch (n) {
            case 18: {
                return "(";
            }
            case 19: {
                return ")";
            }
            case 20: {
                return "{";
            }
            case 21: {
                return "}";
            }
            case 22: {
                return "[";
            }
            case 23: {
                return "]";
            }
            case 24: {
                return "{{";
            }
            case 25: {
                return "}}";
            }
        }
        return IonTokenConstsX.getTokenName(n);
    }

    public static final IonType ion_type_of_scalar(int n) {
        switch (n) {
            case 2: {
                return IonType.INT;
            }
            case 26: {
                return IonType.INT;
            }
            case 3: {
                return IonType.INT;
            }
            case 4: {
                return IonType.DECIMAL;
            }
            case 5: {
                return IonType.FLOAT;
            }
            case 8: {
                return IonType.TIMESTAMP;
            }
            case 9: {
                return IonType.SYMBOL;
            }
            case 10: {
                return IonType.SYMBOL;
            }
            case 11: {
                return IonType.SYMBOL;
            }
            case 12: {
                return IonType.STRING;
            }
            case 13: {
                return IonType.STRING;
            }
        }
        return null;
    }

    public static final boolean is8bitValue(int n) {
        return (n & 0xFFFFFF00) == 0;
    }

    public static final boolean is7bitValue(int n) {
        return (n & 0xFFFFFF80) == 0;
    }

    public static final boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    private static boolean[] makeBase64Array() {
        int n;
        boolean[] blArray = new boolean[256];
        for (n = 48; n <= 57; ++n) {
            blArray[n] = true;
        }
        for (n = 97; n <= 122; ++n) {
            blArray[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            blArray[n] = true;
        }
        blArray[43] = true;
        blArray[47] = true;
        return blArray;
    }

    private static final int[] makeHexValueArray() {
        int n;
        int[] nArray = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray[n] = -1;
        }
        for (n = 48; n <= 57; ++n) {
            nArray[n] = n - 48;
        }
        for (n = 97; n <= 102; ++n) {
            nArray[n] = n - 97 + 10;
        }
        for (n = 65; n <= 70; ++n) {
            nArray[n] = n - 65 + 10;
        }
        return nArray;
    }

    private static final boolean[] makeHexDigitTestArray(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = nArray[i] >= 0;
        }
        return blArray;
    }

    public static final boolean isBinaryDigit(int n) {
        return n == 48 || n == 49;
    }

    public static final boolean isHexDigit(int n) {
        return isHexDigit[n & 0xFF] && IonTokenConstsX.is8bitValue(n);
    }

    public static final int hexDigitValue(int n) {
        if (!IonTokenConstsX.isHexDigit(n)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("character '" + (char)n + "' is not a hex digit");
            throw new IonException(illegalArgumentException);
        }
        return hexValue[n];
    }

    public static final boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    public static final int decimalDigitValue(int n) {
        if (!IonTokenConstsX.isDigit(n)) {
            throw new IllegalArgumentException("character '" + (char)n + "' is not a hex digit");
        }
        return n - 48;
    }

    private static final int[] makeEscapeCharacterValuesArray() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = -11;
        }
        nArray[48] = 0;
        nArray[97] = 7;
        nArray[98] = 8;
        nArray[116] = 9;
        nArray[110] = 10;
        nArray[102] = 12;
        nArray[114] = 13;
        nArray[118] = 11;
        nArray[34] = 34;
        nArray[39] = 39;
        nArray[63] = 63;
        nArray[92] = 92;
        nArray[47] = 47;
        nArray[10] = -12;
        nArray[13] = -13;
        nArray[120] = -16;
        nArray[117] = -14;
        nArray[85] = -15;
        return nArray;
    }

    public static final String[] makeEscapeCharacterImageArray() {
        String[] stringArray = new String[256];
        for (int i = 0; i < 256; ++i) {
            stringArray[i] = null;
        }
        stringArray[48] = "\\0";
        stringArray[97] = "\\a";
        stringArray[98] = "\\b";
        stringArray[116] = "\\t";
        stringArray[110] = "\\n";
        stringArray[102] = "\\f";
        stringArray[114] = "\\r";
        stringArray[118] = "\\v";
        stringArray[34] = "\\\"";
        stringArray[39] = "\\'";
        stringArray[63] = "\\?";
        stringArray[92] = "\\\\";
        stringArray[47] = "\\/";
        return stringArray;
    }

    public static final String getEscapeCharacterImage(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("character is outside escapable range (0-255 inclusive)");
        }
        return escapeCharacterImage[n];
    }

    public static final boolean isValidEscapeStart(int n) {
        return escapeCharactersValues[n & 0xFF] != -11 && IonTokenConstsX.is8bitValue(n);
    }

    public static final int escapeReplacementCharacter(int n) {
        if (!IonTokenConstsX.isValidEscapeStart(n)) {
            throw new IllegalArgumentException("not a valid escape sequence character: " + n);
        }
        return escapeCharactersValues[n];
    }

    public static final boolean needsIonEscape(EscapeType escapeType, int n) {
        switch (escapeType) {
            case ESCAPE_DESTINATION_NONE: {
                return false;
            }
            case ESCAPE_DESTINATION_STRING: {
                return IonTokenConstsX.needsStringEscape(n);
            }
            case ESCAPE_DESTINATION_SYMBOL: {
                return IonTokenConstsX.needsSymbolEscape(n);
            }
            case ESCAPE_DESTINATION_CLOB: {
                return IonTokenConstsX.needsClobEscape(n);
            }
        }
        throw new IllegalArgumentException("escapeType " + (Object)((Object)escapeType) + " is unrecognized");
    }

    public static final boolean needsSymbolEscape(int n) {
        return n < 32 || n == 39 || n == 92;
    }

    public static final boolean needsStringEscape(int n) {
        return n < 32 || n == 34 || n == 92;
    }

    public static final boolean needsClobEscape(int n) {
        return n < 32 || n == 34 || n == 92 || n > 127;
    }

    public static String escapeSequence(int n) {
        if (n >= 0 || n <= 0x10FFFF) {
            if (n < 128) {
                return escapeCharacterImage[n];
            }
            if (n < 65535) {
                String string = Integer.toHexString(n);
                int n2 = string.length();
                if (n2 < 4) {
                    string = "0000".substring(n2);
                }
                return "\\u" + string;
            }
            if (n < 65535) {
                String string = Integer.toHexString(n);
                int n3 = string.length();
                if (n3 < 4) {
                    string = "00000000".substring(n3);
                }
                return "\\U" + string;
            }
        }
        throw new IllegalArgumentException("the value " + n + " isn't a valid character");
    }

    private static final boolean[] makeInvalidTerminatingCharsForInfArray() {
        int n;
        boolean[] blArray = new boolean[256];
        for (n = 97; n <= 122; ++n) {
            blArray[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            blArray[n] = true;
        }
        for (n = 48; n <= 57; ++n) {
            blArray[n] = true;
        }
        blArray[36] = true;
        blArray[95] = true;
        return blArray;
    }

    public static final boolean isValidTerminatingCharForInf(int n) {
        return !IonTokenConstsX.is8bitValue(n) || !invalidTerminatingCharsForInf[n & 0xFF];
    }

    private static final boolean[] makeIsValidExtendedSymbolCharacterArray() {
        boolean[] blArray = new boolean[256];
        blArray[33] = true;
        blArray[35] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[42] = true;
        blArray[43] = true;
        blArray[45] = true;
        blArray[46] = true;
        blArray[47] = true;
        blArray[59] = true;
        blArray[60] = true;
        blArray[61] = true;
        blArray[62] = true;
        blArray[63] = true;
        blArray[64] = true;
        blArray[94] = true;
        blArray[96] = true;
        blArray[124] = true;
        blArray[126] = true;
        return blArray;
    }

    public static final boolean isValidExtendedSymbolCharacter(int n) {
        return isValidExtendedSymbolCharacter[n & 0xFF] && IonTokenConstsX.is8bitValue(n);
    }

    private static final boolean[] makeIsValidSymbolCharacterArray() {
        int n;
        boolean[] blArray = new boolean[256];
        for (n = 97; n <= 122; ++n) {
            blArray[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            blArray[n] = true;
        }
        for (n = 48; n <= 57; ++n) {
            blArray[n] = true;
        }
        blArray[36] = true;
        blArray[95] = true;
        return blArray;
    }

    public static final boolean isValidSymbolCharacter(int n) {
        return isValidSymbolCharacter[n & 0xFF] && IonTokenConstsX.is8bitValue(n);
    }

    private static final boolean[] makeIsValidStartSymbolCharacterArray() {
        int n;
        boolean[] blArray = new boolean[256];
        for (n = 97; n <= 122; ++n) {
            blArray[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            blArray[n] = true;
        }
        blArray[36] = true;
        blArray[95] = true;
        return blArray;
    }

    public static final boolean isValidStartSymbolCharacter(int n) {
        return isValidStartSymbolCharacter[n & 0xFF] && IonTokenConstsX.is8bitValue(n);
    }

    public static int decodeSid(CharSequence charSequence) {
        assert (charSequence.charAt(0) == '$');
        int n = charSequence.length();
        assert (n > 1);
        String string = charSequence.subSequence(1, n).toString();
        return Integer.parseInt(string);
    }

    public static int keyword(CharSequence charSequence, int n, int n2) {
        char c = charSequence.charAt(n);
        int n3 = n2 - n;
        switch (c) {
            case '$': {
                if (n3 > 1) {
                    for (int i = n + 1; i < n2; ++i) {
                        if (IonTokenConstsX.isDigit(charSequence.charAt(i))) continue;
                        return -1;
                    }
                    return 17;
                }
                return -1;
            }
            case 'b': {
                if (n3 == 4) {
                    if (charSequence.charAt(n + 1) == 'o' && charSequence.charAt(n + 2) == 'o' && charSequence.charAt(n + 3) == 'l') {
                        return 4;
                    }
                    if (charSequence.charAt(n + 1) == 'l' && charSequence.charAt(n + 2) == 'o' && charSequence.charAt(n + 3) == 'b') {
                        return 11;
                    }
                }
                return -1;
            }
            case 'c': {
                if (n3 == 4 && charSequence.charAt(n + 1) == 'l' && charSequence.charAt(n + 2) == 'o' && charSequence.charAt(n + 3) == 'b') {
                    return 12;
                }
                return -1;
            }
            case 'd': {
                if (n3 == 7 && charSequence.charAt(n + 1) == 'e' && charSequence.charAt(n + 2) == 'c' && charSequence.charAt(n + 3) == 'i' && charSequence.charAt(n + 4) == 'm' && charSequence.charAt(n + 5) == 'a' && charSequence.charAt(n + 6) == 'l') {
                    return 7;
                }
                return -1;
            }
            case 'f': {
                if (n3 == 5) {
                    if (charSequence.charAt(n + 1) == 'a' && charSequence.charAt(n + 2) == 'l' && charSequence.charAt(n + 3) == 's' && charSequence.charAt(n + 4) == 'e') {
                        return 2;
                    }
                    if (charSequence.charAt(n + 1) == 'l' && charSequence.charAt(n + 2) == 'o' && charSequence.charAt(n + 3) == 'a' && charSequence.charAt(n + 4) == 't') {
                        return 6;
                    }
                }
                return -1;
            }
            case 'i': {
                if (n3 == 3 && charSequence.charAt(n + 1) == 'n' && charSequence.charAt(n + 2) == 't') {
                    return 5;
                }
                return -1;
            }
            case 'l': {
                if (n3 == 4 && charSequence.charAt(n + 1) == 'i' && charSequence.charAt(n + 2) == 's' && charSequence.charAt(n + 3) == 't') {
                    return 13;
                }
                return -1;
            }
            case 'n': {
                if (n3 == 4) {
                    if (charSequence.charAt(n + 1) == 'u' && charSequence.charAt(n + 2) == 'l' && charSequence.charAt(n + 3) == 'l') {
                        return 3;
                    }
                } else if (n3 == 3 && charSequence.charAt(n + 1) == 'a' && charSequence.charAt(n + 2) == 'n') {
                    return 16;
                }
                return -1;
            }
            case 's': {
                if (n3 == 4) {
                    if (charSequence.charAt(n + 1) == 'e' && charSequence.charAt(n + 2) == 'x' && charSequence.charAt(n + 3) == 'p') {
                        return 14;
                    }
                } else if (n3 == 6) {
                    if (charSequence.charAt(n + 1) == 't' && charSequence.charAt(n + 2) == 'r') {
                        if (charSequence.charAt(n + 3) == 'i' && charSequence.charAt(n + 4) == 'n' && charSequence.charAt(n + 5) == 'g') {
                            return 10;
                        }
                        if (charSequence.charAt(n + 3) == 'u' && charSequence.charAt(n + 4) == 'c' && charSequence.charAt(n + 5) == 't') {
                            return 15;
                        }
                        return -1;
                    }
                    if (charSequence.charAt(n + 1) == 'y' && charSequence.charAt(n + 2) == 'm' && charSequence.charAt(n + 3) == 'b' && charSequence.charAt(n + 4) == 'o' && charSequence.charAt(n + 5) == 'l') {
                        return 9;
                    }
                }
                return -1;
            }
            case 't': {
                if (n3 == 4) {
                    if (charSequence.charAt(n + 1) == 'r' && charSequence.charAt(n + 2) == 'u' && charSequence.charAt(n + 3) == 'e') {
                        return 1;
                    }
                } else if (n3 == 9 && charSequence.charAt(n + 1) == 'i' && charSequence.charAt(n + 2) == 'm' && charSequence.charAt(n + 3) == 'e' && charSequence.charAt(n + 4) == 's' && charSequence.charAt(n + 5) == 't' && charSequence.charAt(n + 6) == 'a' && charSequence.charAt(n + 7) == 'm' && charSequence.charAt(n + 8) == 'p') {
                    return 8;
                }
                return -1;
            }
        }
        return -1;
    }

    static final int[] makeTypeNameBitIndex() {
        int[] nArray = new int[TN_MAX_NAME_LENGTH * 19];
        for (int i = 0; i < typeNameNames.length; ++i) {
            String string = typeNameNames[i];
            int n = typeNameBits[i];
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                int n2 = IonTokenConstsX.typeNameLetterIdx(c);
                assert (n2 > 0);
                IonTokenConstsX.typename_set_bit(nArray, j, n2, n);
            }
        }
        return nArray;
    }

    private static final void typename_set_bit(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n * 19 + n2 - 1;
        nArray[n5] = nArray[n5] | n3;
    }

    public static final int typeNameLetterIdx(int n) {
        switch (n) {
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 99: {
                return 3;
            }
            case 100: {
                return 4;
            }
            case 101: {
                return 5;
            }
            case 102: {
                return 6;
            }
            case 103: {
                return 7;
            }
            case 105: {
                return 8;
            }
            case 108: {
                return 9;
            }
            case 109: {
                return 10;
            }
            case 110: {
                return 11;
            }
            case 111: {
                return 12;
            }
            case 112: {
                return 13;
            }
            case 114: {
                return 14;
            }
            case 115: {
                return 15;
            }
            case 116: {
                return 16;
            }
            case 117: {
                return 17;
            }
            case 120: {
                return 18;
            }
            case 121: {
                return 19;
            }
        }
        return -1;
    }

    public static final int typeNamePossibilityMask(int n, int n2) {
        int n3 = n * 19 + n2 - 1;
        int n4 = TypeNameBitIndex[n3];
        return n4;
    }

    public static final int typeNameKeyWordFromMask(int n, int n2) {
        int n3 = -1;
        if (n != 8191) {
            for (int i = 0; i < typeNameBits.length; ++i) {
                int n4 = typeNameBits[i];
                if (n4 != n) continue;
                if (typeNameNames[i].length() != n2) break;
                n3 = typeNameKeyWordIds[i];
                break;
            }
        }
        return n3;
    }

    public static final String getNullImage(IonType ionType) {
        String string = null;
        switch (ionType) {
            case NULL: {
                string = "null";
                break;
            }
            case BOOL: {
                string = "null.bool";
                break;
            }
            case INT: {
                string = "null.int";
                break;
            }
            case FLOAT: {
                string = "null.float";
                break;
            }
            case DECIMAL: {
                string = "null.decimal";
                break;
            }
            case TIMESTAMP: {
                string = "null.timestamp";
                break;
            }
            case SYMBOL: {
                string = "null.symbol";
                break;
            }
            case STRING: {
                string = "null.string";
                break;
            }
            case BLOB: {
                string = "null.blob";
                break;
            }
            case CLOB: {
                string = "null.clob";
                break;
            }
            case SEXP: {
                string = "null.sexp";
                break;
            }
            case LIST: {
                string = "null.list";
                break;
            }
            case STRUCT: {
                string = "null.struct";
                break;
            }
            default: {
                throw new IllegalStateException("unexpected type " + (Object)((Object)ionType));
            }
        }
        return string;
    }

    public static final IonType getNullType(CharSequence charSequence) {
        char c;
        IonType ionType = null;
        int n = 0;
        boolean bl = false;
        block26: while (!bl && n < charSequence.length()) {
            c = charSequence.charAt(n++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block26;
                }
                case 'n': {
                    bl = true;
                    continue block26;
                }
            }
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        if (n >= charSequence.length() || charSequence.charAt(n++) != 'u') {
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        if (n >= charSequence.length() || charSequence.charAt(n++) != 'l') {
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        if (n >= charSequence.length() || charSequence.charAt(n++) != 'l') {
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        boolean bl2 = false;
        block27: while (!bl2 && n < charSequence.length()) {
            c = charSequence.charAt(n++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block27;
                }
                case '.': {
                    bl2 = true;
                    continue block27;
                }
            }
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        if (bl2) {
            int n2 = IonTokenConstsX.keyword(charSequence, n, charSequence.length());
            switch (n2) {
                case 3: {
                    ionType = IonType.NULL;
                    break;
                }
                case 4: {
                    ionType = IonType.BOOL;
                    break;
                }
                case 5: {
                    ionType = IonType.INT;
                    break;
                }
                case 6: {
                    ionType = IonType.FLOAT;
                    break;
                }
                case 7: {
                    ionType = IonType.DECIMAL;
                    break;
                }
                case 8: {
                    ionType = IonType.TIMESTAMP;
                    break;
                }
                case 9: {
                    ionType = IonType.SYMBOL;
                    break;
                }
                case 10: {
                    ionType = IonType.STRING;
                    break;
                }
                case 12: {
                    ionType = IonType.CLOB;
                    break;
                }
                case 11: {
                    ionType = IonType.BLOB;
                    break;
                }
                case 15: {
                    ionType = IonType.STRUCT;
                    break;
                }
                case 13: {
                    ionType = IonType.LIST;
                    break;
                }
                case 14: {
                    ionType = IonType.SEXP;
                    break;
                }
                default: {
                    IonTokenConstsX.invalid_null_image(charSequence);
                }
            }
        }
        block28: while (n < charSequence.length()) {
            c = charSequence.charAt(n++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block28;
                }
            }
            IonTokenConstsX.invalid_null_image(charSequence);
        }
        return ionType;
    }

    private static void invalid_null_image(CharSequence charSequence) {
        throw new PrivateScalarConversions.CantConvertException("invalid image " + charSequence.toString());
    }

    public static enum EscapeType {
        ESCAPE_DESTINATION_NONE,
        ESCAPE_DESTINATION_STRING,
        ESCAPE_DESTINATION_SYMBOL,
        ESCAPE_DESTINATION_CLOB;

    }

    public static class CharacterSequence {
        public static final int CHAR_SEQ_EOF = -1;
        public static final int CHAR_SEQ_STRING_TERMINATOR = -2;
        public static final int CHAR_SEQ_STRING_NON_TERMINATOR = -3;
        public static final int CHAR_SEQ_NEWLINE_SEQUENCE_1 = -4;
        public static final int CHAR_SEQ_NEWLINE_SEQUENCE_2 = -5;
        public static final int CHAR_SEQ_NEWLINE_SEQUENCE_3 = -6;
        public static final int CHAR_SEQ_ESCAPED_NEWLINE_SEQUENCE_1 = -7;
        public static final int CHAR_SEQ_ESCAPED_NEWLINE_SEQUENCE_2 = -8;
        public static final int CHAR_SEQ_ESCAPED_NEWLINE_SEQUENCE_3 = -9;
    }
}

