/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.impl.IonReaderTextRawTokensX;
import software.amazon.ion.impl.IonTokenConstsX;
import software.amazon.ion.impl.PrivateScalarConversions;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.impl.UnifiedSavePointManagerX;

abstract class IonReaderTextRawX
implements IonReader {
    static final boolean _debug = false;
    private static final int DEFAULT_STACK_DEPTH = 10;
    protected static final int UNKNOWN_SIZE = -1;
    private static final int DEFAULT_ANNOTATION_COUNT = 5;
    static final int STATE_BEFORE_ANNOTATION_DATAGRAM = 0;
    static final int STATE_BEFORE_ANNOTATION_CONTAINED = 1;
    static final int STATE_BEFORE_ANNOTATION_SEXP = 2;
    static final int STATE_BEFORE_FIELD_NAME = 3;
    static final int STATE_BEFORE_VALUE_CONTENT = 4;
    static final int STATE_BEFORE_VALUE_CONTENT_SEXP = 5;
    static final int STATE_IN_LONG_STRING = 6;
    static final int STATE_IN_CLOB_DOUBLE_QUOTED_CONTENT = 7;
    static final int STATE_IN_CLOB_TRIPLE_QUOTED_CONTENT = 8;
    static final int STATE_IN_BLOB_CONTENT = 9;
    static final int STATE_AFTER_VALUE_CONTENTS = 10;
    static final int STATE_EOF = 11;
    static final int STATE_MAX = 11;
    static final int ACTION_NOT_DEFINED = 0;
    static final int ACTION_LOAD_FIELD_NAME = 1;
    static final int ACTION_LOAD_ANNOTATION = 2;
    static final int ACTION_START_STRUCT = 3;
    static final int ACTION_START_LIST = 4;
    static final int ACTION_START_SEXP = 5;
    static final int ACTION_START_LOB = 6;
    static final int ACTION_LOAD_SCALAR = 8;
    static final int ACTION_PLUS_INF = 9;
    static final int ACTION_MINUS_INF = 10;
    static final int ACTION_EAT_COMMA = 11;
    static final int ACTION_FINISH_CONTAINER = 12;
    static final int ACTION_FINISH_LOB = 13;
    static final int ACTION_FINISH_DATAGRAM = 14;
    static final int ACTION_EOF = 15;
    static final int ACTION_count = 16;
    static final int[][] TransitionActions = IonReaderTextRawX.makeTransitionActionArray();
    static final int[] TransitionActions2 = IonReaderTextRawX.makeTransition2ActionArray();
    IonReaderTextRawTokensX _scanner;
    boolean _eof;
    int _state;
    IonType[] _container_state_stack = new IonType[10];
    int _container_state_top;
    boolean _container_is_struct;
    boolean _container_prohibits_commas;
    boolean _has_next_called;
    IonType _value_type;
    int _value_keyword;
    IonType _null_type;
    String _field_name;
    int _field_name_sid = -1;
    int _annotation_count;
    SymbolToken[] _annotations;
    boolean _current_value_save_point_loaded;
    UnifiedSavePointManagerX.SavePoint _current_value_save_point;
    boolean _current_value_buffer_loaded;
    StringBuilder _current_value_buffer;
    PrivateScalarConversions.ValueVariant _v = new PrivateScalarConversions.ValueVariant();
    long _value_start_offset;
    long _value_start_line;
    long _value_start_column;
    IonType _nesting_parent = null;
    boolean _lob_value_set;
    int _lob_token;
    long _lob_value_position;
    LOB_STATE _lob_loaded;
    byte[] _lob_bytes;
    int _lob_actual_len;

    @Override
    public abstract BigInteger bigIntegerValue();

    private final String get_state_name(int n) {
        switch (n) {
            case 0: {
                return "STATE_BEFORE_ANNOTATION_DATAGRAM";
            }
            case 1: {
                return "STATE_BEFORE_ANNOTATION_CONTAINED";
            }
            case 2: {
                return "STATE_BEFORE_ANNOTATION_SEXP";
            }
            case 3: {
                return "STATE_BEFORE_FIELD_NAME";
            }
            case 4: {
                return "STATE_BEFORE_VALUE_CONTENT";
            }
            case 5: {
                return "STATE_BEFORE_VALUE_CONTENT_SEXP";
            }
            case 6: {
                return "STATE_IN_LONG_STRING";
            }
            case 7: {
                return "STATE_IN_CLOB_DOUBLE_QUOTED_CONTENT";
            }
            case 8: {
                return "STATE_IN_CLOB_TRIPLE_QUOTED_CONTENT";
            }
            case 9: {
                return "STATE_IN_BLOB_CONTENT";
            }
            case 10: {
                return "STATE_AFTER_VALUE_CONTENTS";
            }
            case 11: {
                return "STATE_EOF";
            }
        }
        return "<invalid state: " + Integer.toString(n) + ">";
    }

    private final String get_action_name(int n) {
        switch (n) {
            case 0: {
                return "ACTION_DO_NOTHING";
            }
            case 1: {
                return "ACTION_LOAD_FIELD_NAME";
            }
            case 2: {
                return "ACTION_LOAD_ANNOTATION";
            }
            case 3: {
                return "ACTION_START_STRUCT";
            }
            case 4: {
                return "ACTION_START_LIST";
            }
            case 5: {
                return "ACTION_START_SEXP";
            }
            case 6: {
                return "ACTION_START_LOB";
            }
            case 8: {
                return "ACTION_LOAD_SCALAR";
            }
            case 9: {
                return "ACTION_PLUS_INF";
            }
            case 10: {
                return "ACTION_MINUS_INF";
            }
            case 11: {
                return "ACTION_EAT_COMMA";
            }
            case 12: {
                return "ACTION_FINISH_CONTAINER";
            }
            case 13: {
                return "ACTION_FINISH_LOB";
            }
            case 14: {
                return "ACTION_FINISH_DATAGRAM";
            }
            case 15: {
                return "ACTION_EOF";
            }
        }
        return "<unrecognized action: " + Integer.toString(n) + ">";
    }

    static final int[][] makeTransitionActionArray() {
        int n;
        int[][] nArray = new int[12][27];
        nArray[0][0] = 14;
        nArray[0][1] = 8;
        nArray[0][2] = 8;
        nArray[0][26] = 8;
        nArray[0][3] = 8;
        nArray[0][4] = 8;
        nArray[0][5] = 8;
        nArray[0][6] = 9;
        nArray[0][7] = 10;
        nArray[0][8] = 8;
        nArray[0][12] = 8;
        nArray[0][13] = 8;
        nArray[0][9] = 2;
        nArray[0][10] = 2;
        nArray[0][18] = 5;
        nArray[0][20] = 3;
        nArray[0][22] = 4;
        nArray[0][24] = 6;
        for (n = 0; n < 27; ++n) {
            nArray[1][n] = nArray[0][n];
            nArray[2][n] = nArray[0][n];
            nArray[4][n] = nArray[0][n];
            nArray[5][n] = nArray[0][n];
        }
        nArray[1][0] = 0;
        nArray[1][19] = 12;
        nArray[1][21] = 12;
        nArray[1][23] = 12;
        nArray[2][0] = 0;
        nArray[2][11] = 8;
        nArray[2][14] = 8;
        nArray[2][19] = 12;
        nArray[2][21] = 12;
        nArray[2][23] = 12;
        nArray[4][0] = 0;
        nArray[4][9] = 8;
        nArray[4][10] = 8;
        nArray[5][0] = 0;
        nArray[5][9] = 8;
        nArray[5][10] = 8;
        nArray[5][11] = 8;
        nArray[3][0] = 0;
        nArray[3][9] = 1;
        nArray[3][10] = 1;
        nArray[3][12] = 1;
        nArray[3][13] = 1;
        nArray[3][19] = 12;
        nArray[3][21] = 12;
        nArray[3][23] = 12;
        nArray[10][15] = 11;
        nArray[10][19] = 12;
        nArray[10][21] = 12;
        nArray[10][23] = 12;
        nArray[7][21] = 13;
        nArray[8][21] = 13;
        nArray[9][21] = 13;
        for (n = 0; n < 27; ++n) {
            nArray[11][n] = 15;
        }
        return nArray;
    }

    static int[] makeTransition2ActionArray() {
        int n = 12;
        int n2 = 27;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i * 27 + j;
                nArray[n3] = TransitionActions[i][j];
            }
        }
        return nArray;
    }

    protected IonReaderTextRawX() {
    }

    @Override
    public <T> T asFacet(Class<T> clazz) {
        return null;
    }

    protected final void init_once() {
        this._current_value_buffer = new StringBuilder();
        this._annotations = new SymbolToken[5];
    }

    protected final void init(UnifiedInputStreamX unifiedInputStreamX, IonType ionType) {
        this.init(unifiedInputStreamX, ionType, 1L, 1L);
    }

    protected final void init(UnifiedInputStreamX unifiedInputStreamX, IonType ionType, long l, long l2) {
        assert (ionType != null);
        this._scanner = new IonReaderTextRawTokensX(unifiedInputStreamX, l, l2);
        this._value_start_line = l;
        this._value_start_column = l2;
        this._current_value_save_point = unifiedInputStreamX.savePointAllocate();
        this._lob_loaded = LOB_STATE.EMPTY;
        int n = this.get_state_at_container_start(ionType);
        this.set_state(n);
        this._eof = false;
        this.push_container_state(ionType);
    }

    protected final void re_init(UnifiedInputStreamX unifiedInputStreamX, IonType ionType, long l, long l2) {
        this._state = 0;
        this._container_state_top = 0;
        this._container_is_struct = false;
        this._container_prohibits_commas = false;
        this._has_next_called = false;
        this._value_type = null;
        this._value_keyword = 0;
        this._null_type = null;
        this._field_name = null;
        this._field_name_sid = -1;
        this._annotation_count = 0;
        this._current_value_save_point_loaded = false;
        this._current_value_buffer_loaded = false;
        this._value_start_offset = 0L;
        this._lob_value_set = false;
        this._lob_token = 0;
        this._lob_value_position = 0L;
        this._lob_bytes = null;
        this._lob_actual_len = 0;
        this.init(unifiedInputStreamX, ionType, l, l2);
        this._nesting_parent = ionType;
        if (IonType.STRUCT.equals((Object)this._nesting_parent)) {
            this._container_is_struct = true;
        }
    }

    @Override
    public void close() throws IOException {
        this._scanner.close();
    }

    private final void set_state(int n) {
        this._state = n;
    }

    private final int get_state_int() {
        return this._state;
    }

    private final String get_state_name() {
        String string = this.get_state_name(this.get_state_int());
        return string;
    }

    protected final void clear_current_value_buffer() {
        if (this._current_value_buffer_loaded) {
            this._current_value_buffer.setLength(0);
            this._current_value_buffer_loaded = false;
        }
        if (this._current_value_save_point_loaded) {
            this._current_value_save_point.clear();
            this._current_value_save_point_loaded = false;
        }
    }

    private final void current_value_is_null(IonType ionType) {
        this.clear_current_value_buffer();
        this._value_type = this._null_type;
        this._v.setValueToNull(ionType);
        this._v.setAuthoritativeType(1);
    }

    private final void current_value_is_bool(boolean bl) {
        this.clear_current_value_buffer();
        this._value_type = IonType.BOOL;
        this._v.setValue(bl);
        this._v.setAuthoritativeType(2);
    }

    private final void set_fieldname(SymbolToken symbolToken) {
        String string = symbolToken.getText();
        int n = symbolToken.getSid();
        if (string != null && string.length() < 1) {
            this.parse_error("empty strings are not valid field names");
        }
        this._field_name = string;
        this._field_name_sid = n;
    }

    private final void clear_fieldname() {
        this._field_name = null;
        this._field_name_sid = -1;
    }

    private final void append_annotation(SymbolToken symbolToken) {
        int n = this._annotations.length;
        if (this._annotation_count >= n) {
            int n2 = n * 2;
            SymbolToken[] symbolTokenArray = new SymbolToken[n2];
            System.arraycopy(this._annotations, 0, symbolTokenArray, 0, n);
            this._annotations = symbolTokenArray;
        }
        this._annotations[this._annotation_count++] = symbolToken;
    }

    private final void clear_annotation_list() {
        this._annotation_count = 0;
    }

    boolean hasNext() {
        boolean bl = this.has_next_raw_value();
        return bl;
    }

    protected final boolean has_next_raw_value() {
        if (!this._has_next_called && !this._eof) {
            try {
                this.finish_value(null);
                this.clear_value();
                this.parse_to_next_value();
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
            this._has_next_called = true;
        }
        return !this._eof;
    }

    @Override
    public IonType next() {
        if (!this.hasNext()) {
            return null;
        }
        if (this._value_type == null && this._scanner.isUnfinishedToken()) {
            try {
                this.token_contents_load(this._scanner.getToken());
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
        this._has_next_called = false;
        return this._value_type;
    }

    private final void finish_and_save_value() throws IOException {
        if (!this._current_value_save_point_loaded) {
            this._scanner.save_point_start(this._current_value_save_point);
            this.finish_value(this._current_value_save_point);
            this._current_value_save_point_loaded = true;
        }
    }

    private final void finish_value(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        if (this._scanner.isUnfinishedToken()) {
            if (savePoint != null && this._value_type != null) {
                switch (this._value_type) {
                    case STRUCT: 
                    case SEXP: 
                    case LIST: {
                        savePoint = null;
                        break;
                    }
                }
            }
            this._scanner.finish_token(savePoint);
            int n = this.get_state_after_value();
            this.set_state(n);
        }
        this._has_next_called = false;
    }

    private final void clear_value() {
        this._value_type = null;
        this._null_type = null;
        if (this._lob_value_set) {
            this._lob_value_set = false;
            this._lob_value_position = 0L;
        }
        if (!LOB_STATE.EMPTY.equals((Object)this._lob_loaded)) {
            this._lob_actual_len = -1;
            this._lob_bytes = null;
            this._lob_loaded = LOB_STATE.EMPTY;
        }
        this.clear_current_value_buffer();
        this.clear_annotation_list();
        this.clear_fieldname();
        this._v.clear();
        this._value_start_offset = -1L;
    }

    private final void set_container_flags(IonType ionType) {
        switch (ionType) {
            case LIST: {
                this._container_is_struct = false;
                this._container_prohibits_commas = false;
                break;
            }
            case SEXP: {
                this._container_is_struct = false;
                this._container_prohibits_commas = true;
                break;
            }
            case STRUCT: {
                this._container_is_struct = true;
                this._container_prohibits_commas = false;
                break;
            }
            case DATAGRAM: {
                this._container_is_struct = false;
                this._container_prohibits_commas = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("type must be a container, not a " + ionType.toString());
            }
        }
    }

    private int get_state_after_value() {
        int n;
        switch (this.getContainerType()) {
            case STRUCT: 
            case LIST: {
                n = 10;
                break;
            }
            case SEXP: {
                n = 2;
                break;
            }
            case DATAGRAM: {
                n = 0;
                break;
            }
            default: {
                String string = "invalid container type encountered during parsing " + (Object)((Object)this.getContainerType()) + this._scanner.input_position();
                throw new IonException(string);
            }
        }
        if (this._nesting_parent != null && this.getDepth() == 0) {
            n = 11;
        }
        return n;
    }

    private final int get_state_after_annotation() {
        int n;
        block0 : switch (this.get_state_int()) {
            case 10: {
                IonType ionType = this.top_state();
                switch (ionType) {
                    case STRUCT: 
                    case LIST: 
                    case DATAGRAM: {
                        n = 4;
                        break block0;
                    }
                    case SEXP: {
                        n = 5;
                        break block0;
                    }
                }
                String string = "invalid container type encountered during parsing " + (Object)((Object)ionType) + this._scanner.input_position();
                throw new IonException(string);
            }
            case 0: 
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            default: {
                String string = "invalid state encountered during parsing before the value " + this.get_state_name() + this._scanner.input_position();
                throw new IonException(string);
            }
        }
        return n;
    }

    private final int get_state_after_container() {
        IonType ionType = this.top_state();
        int n = this.get_state_after_container(ionType);
        return n;
    }

    private final int get_state_after_container(int n) {
        IonType ionType = this.top_state();
        switch (ionType) {
            case STRUCT: {
                this.check_container_close(ionType, 21, n);
                break;
            }
            case LIST: {
                this.check_container_close(ionType, 23, n);
                break;
            }
            case SEXP: {
                this.check_container_close(ionType, 19, n);
                break;
            }
            default: {
                String string = "invalid container type encountered during parsing " + (Object)((Object)ionType) + this._scanner.input_position();
                throw new IonException(string);
            }
        }
        int n2 = this.get_state_after_container(ionType);
        return n2;
    }

    private final int get_state_after_container(IonType ionType) {
        int n;
        if (ionType == null) {
            n = 0;
        } else {
            switch (ionType) {
                case STRUCT: 
                case LIST: {
                    n = 10;
                    break;
                }
                case SEXP: {
                    n = 2;
                    break;
                }
                case DATAGRAM: {
                    n = 0;
                    break;
                }
                default: {
                    String string = "invalid container type encountered during parsing " + (Object)((Object)ionType) + this._scanner.input_position();
                    throw new IonException(string);
                }
            }
            if (this._nesting_parent != null && this.getDepth() == 0) {
                n = 11;
            }
        }
        return n;
    }

    private final void check_container_close(IonType ionType, int n, int n2) {
        if (n2 != n) {
            String string = ionType.toString().toLowerCase() + " closed by " + IonTokenConstsX.describeToken(n2) + this._scanner.input_position();
            throw new IonException(string);
        }
    }

    private final int get_state_at_container_start(IonType ionType) {
        int n;
        if (ionType == null) {
            n = 0;
        } else {
            switch (ionType) {
                case STRUCT: {
                    n = 3;
                    break;
                }
                case LIST: {
                    n = 1;
                    break;
                }
                case SEXP: {
                    n = 2;
                    break;
                }
                case DATAGRAM: {
                    n = 0;
                    break;
                }
                default: {
                    String string = "invalid container type encountered during parsing " + (Object)((Object)ionType) + this._scanner.input_position();
                    throw new IonException(string);
                }
            }
        }
        return n;
    }

    private final SymbolToken parseSymbolToken(String string, StringBuilder stringBuilder, int n) throws IOException {
        int n2;
        String string2;
        if (n == 9) {
            int n3 = IonTokenConstsX.keyword(stringBuilder, 0, stringBuilder.length());
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 16: {
                    String string3 = "Cannot use unquoted keyword " + stringBuilder.toString() + " as " + string;
                    this.parse_error(string3);
                }
                case 17: {
                    string2 = null;
                    n2 = IonTokenConstsX.decodeSid(stringBuilder);
                    break;
                }
                default: {
                    string2 = stringBuilder.toString();
                    n2 = -1;
                    break;
                }
            }
        } else {
            string2 = stringBuilder.toString();
            n2 = -1;
        }
        return new SymbolTokenImpl(string2, n2);
    }

    protected final void parse_to_next_value() throws IOException {
        boolean bl = false;
        this._value_start_offset = this._scanner.getStartingOffset();
        this._value_start_line = this._scanner.getLineNumber();
        this._value_start_column = this._scanner.getLineOffset();
        int n = this._scanner.nextToken();
        block52: while (true) {
            int n2 = this.get_state_int() * 27 + n;
            int n3 = TransitionActions2[n2];
            switch (n3) {
                case 0: {
                    boolean bl2 = false;
                    if (this._nesting_parent != null) {
                        switch (this._nesting_parent) {
                            case LIST: {
                                if (n != 23) break;
                                bl2 = true;
                                break;
                            }
                            case SEXP: {
                                if (n != 19) break;
                                bl2 = true;
                                break;
                            }
                            case STRUCT: {
                                if (n != 21) break;
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (!bl2) {
                        String string = "invalid syntax [state:" + this.get_state_name() + " on token:" + IonTokenConstsX.getTokenName(n) + "]";
                        this.parse_error(string);
                    }
                    this.set_state(11);
                    this._eof = true;
                    return;
                }
                case 15: {
                    this.set_state(11);
                    this._eof = true;
                    return;
                }
                case 1: {
                    if (!this.is_in_struct_internal()) {
                        throw new IllegalStateException("field names have to be in structs");
                    }
                    this.finish_and_save_value();
                    StringBuilder stringBuilder = this.token_contents_load(n);
                    SymbolToken symbolToken = this.parseSymbolToken("a field name", stringBuilder, n);
                    this.set_fieldname(symbolToken);
                    this.clear_current_value_buffer();
                    n = this._scanner.nextToken();
                    if (n != 16) {
                        String string = "field name must be followed by a colon, not a " + IonTokenConstsX.getTokenName(n);
                        this.parse_error(string);
                    }
                    this._scanner.tokenIsFinished();
                    this.set_state(1);
                    n = this._scanner.nextToken();
                    continue block52;
                }
                case 2: {
                    int n4;
                    StringBuilder stringBuilder = this.token_contents_load(n);
                    if (stringBuilder.length() < 1) {
                        this.parse_error("empty symbols are not valid");
                    }
                    bl = this._scanner.skip_whitespace();
                    if (!this._scanner.skipDoubleColon()) {
                        n4 = this.get_state_after_annotation();
                        this.set_state(n4);
                        continue block52;
                    }
                    SymbolToken symbolToken = this.parseSymbolToken("an annotation", stringBuilder, n);
                    this.append_annotation(symbolToken);
                    this.clear_current_value_buffer();
                    n = this._scanner.nextToken();
                    switch (n) {
                        case 9: 
                        case 10: {
                            continue block52;
                        }
                    }
                    n4 = this.get_state_after_annotation();
                    this.set_state(n4);
                    continue block52;
                }
                case 3: {
                    this._value_type = IonType.STRUCT;
                    int n4 = 3;
                    this.set_state(n4);
                    return;
                }
                case 4: {
                    this._value_type = IonType.LIST;
                    int n4 = 1;
                    this.set_state(n4);
                    return;
                }
                case 5: {
                    this._value_type = IonType.SEXP;
                    int n4 = 2;
                    this.set_state(n4);
                    return;
                }
                case 6: {
                    switch (this._scanner.peekLobStartPunctuation()) {
                        case 12: {
                            this.set_state(7);
                            this._lob_token = 12;
                            this._value_type = IonType.CLOB;
                            break;
                        }
                        case 13: {
                            this.set_state(8);
                            this._lob_token = 13;
                            this._value_type = IonType.CLOB;
                            break;
                        }
                        default: {
                            this.set_state(9);
                            this._lob_token = 24;
                            this._value_type = IonType.BLOB;
                        }
                    }
                    return;
                }
                case 8: {
                    StringBuilder stringBuilder;
                    if (n == 9) {
                        stringBuilder = this.token_contents_load(n);
                        int n5 = IonTokenConstsX.keyword(stringBuilder, 0, stringBuilder.length());
                        switch (n5) {
                            case 3: {
                                int n6 = bl ? 0 : this._scanner.peekNullTypeSymbol();
                                switch (n6) {
                                    case 3: {
                                        this._null_type = IonType.NULL;
                                        break;
                                    }
                                    case 4: {
                                        this._null_type = IonType.BOOL;
                                        break;
                                    }
                                    case 5: {
                                        this._null_type = IonType.INT;
                                        break;
                                    }
                                    case 6: {
                                        this._null_type = IonType.FLOAT;
                                        break;
                                    }
                                    case 7: {
                                        this._null_type = IonType.DECIMAL;
                                        break;
                                    }
                                    case 8: {
                                        this._null_type = IonType.TIMESTAMP;
                                        break;
                                    }
                                    case 9: {
                                        this._null_type = IonType.SYMBOL;
                                        break;
                                    }
                                    case 10: {
                                        this._null_type = IonType.STRING;
                                        break;
                                    }
                                    case 11: {
                                        this._null_type = IonType.BLOB;
                                        break;
                                    }
                                    case 12: {
                                        this._null_type = IonType.CLOB;
                                        break;
                                    }
                                    case 13: {
                                        this._null_type = IonType.LIST;
                                        break;
                                    }
                                    case 14: {
                                        this._null_type = IonType.SEXP;
                                        break;
                                    }
                                    case 15: {
                                        this._null_type = IonType.STRUCT;
                                        break;
                                    }
                                    case 0: {
                                        this._null_type = IonType.NULL;
                                        break;
                                    }
                                    default: {
                                        this.parse_error("invalid keyword id (" + n6 + ") encountered while parsing a null");
                                    }
                                }
                                this.current_value_is_null(this._null_type);
                                break;
                            }
                            case 1: {
                                this._value_type = IonType.BOOL;
                                this.current_value_is_bool(true);
                                break;
                            }
                            case 2: {
                                this._value_type = IonType.BOOL;
                                this.current_value_is_bool(false);
                                break;
                            }
                            case 16: {
                                this._value_type = IonType.FLOAT;
                                this.clear_current_value_buffer();
                                this._v.setValue(Double.NaN);
                                this._v.setAuthoritativeType(7);
                                break;
                            }
                            case 17: {
                                int n7 = IonTokenConstsX.decodeSid(stringBuilder);
                                this._v.setValue(n7);
                                this._v.setAuthoritativeType(3);
                            }
                            default: {
                                this._value_type = IonType.SYMBOL;
                                break;
                            }
                        }
                    } else if (n == 14) {
                        this._value_type = IonType.SYMBOL;
                        this.clear_current_value_buffer();
                        this._v.setValue(".");
                        this._v.setAuthoritativeType(8);
                    } else {
                        this._value_type = IonTokenConstsX.ion_type_of_scalar(n);
                    }
                    int n8 = this.get_state_after_value();
                    this.set_state(n8);
                    return;
                }
                case 9: {
                    this._value_type = IonType.FLOAT;
                    this.clear_current_value_buffer();
                    this._v.setValue(Double.POSITIVE_INFINITY);
                    this._v.setAuthoritativeType(7);
                    int n9 = this.get_state_after_value();
                    this.set_state(n9);
                    return;
                }
                case 10: {
                    this._value_type = IonType.FLOAT;
                    this.clear_current_value_buffer();
                    this._v.setValue(Double.NEGATIVE_INFINITY);
                    this._v.setAuthoritativeType(7);
                    int n10 = this.get_state_after_value();
                    this.set_state(n10);
                    return;
                }
                case 11: {
                    if (this._container_prohibits_commas) {
                        this.parse_error("commas aren't used to separate values in " + this.getContainerType().toString());
                    }
                    int n11 = 1;
                    if (this._container_is_struct) {
                        n11 = 3;
                    }
                    this.set_state(n11);
                    this._scanner.tokenIsFinished();
                    this._value_start_offset = this._scanner.getStartingOffset();
                    n = this._scanner.nextToken();
                    continue block52;
                }
                case 12: {
                    int n12 = this.get_state_after_container(n);
                    this.set_state(n12);
                    this._eof = true;
                    return;
                }
                case 13: {
                    int n13 = this.get_state_after_value();
                    this.set_state(n13);
                    return;
                }
                case 14: {
                    if (this.getDepth() != 0) {
                        this.parse_error("state failure end of datagram encounterd with a non-container stack");
                    }
                    this.set_state(11);
                    this._eof = true;
                    return;
                }
            }
            this.parse_error("unexpected token encountered: " + IonTokenConstsX.getTokenName(n));
        }
    }

    protected final StringBuilder token_contents_load(int n) throws IOException {
        StringBuilder stringBuilder = this._current_value_buffer;
        if (this._current_value_buffer_loaded) {
            return stringBuilder;
        }
        if (this._current_value_save_point_loaded) {
            assert (!this._scanner.isUnfinishedToken() && !this._current_value_save_point.isClear());
            this._scanner.save_point_activate(this._current_value_save_point);
            switch (n) {
                default: {
                    this._scanner.load_raw_characters(stringBuilder);
                    break;
                }
                case 9: {
                    this._scanner.load_symbol_identifier(stringBuilder);
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 11: {
                    this._scanner.load_symbol_operator(stringBuilder);
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 10: {
                    boolean bl = IonType.CLOB == this._value_type;
                    this._scanner.load_single_quoted_string(stringBuilder, bl);
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 12: {
                    boolean bl = IonType.CLOB == this._value_type;
                    this._scanner.load_double_quoted_string(stringBuilder, bl);
                    this._value_type = IonType.STRING;
                    break;
                }
                case 13: {
                    boolean bl = IonType.CLOB == this._value_type;
                    this._scanner.load_triple_quoted_string(stringBuilder, bl);
                    this._value_type = IonType.STRING;
                }
            }
            this._scanner.save_point_deactivate(this._current_value_save_point);
            this._current_value_buffer_loaded = true;
        } else {
            this._scanner.save_point_start(this._current_value_save_point);
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 26: {
                    this._value_type = this._scanner.load_number(stringBuilder);
                    break;
                }
                case 9: {
                    this._scanner.load_symbol_identifier(stringBuilder);
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 11: {
                    this._scanner.load_symbol_operator(stringBuilder);
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 10: {
                    boolean bl = IonType.CLOB == this._value_type;
                    int n2 = this._scanner.load_single_quoted_string(stringBuilder, bl);
                    if (n2 == -1) {
                        this._scanner.unexpected_eof();
                    }
                    this._value_type = IonType.SYMBOL;
                    break;
                }
                case 12: {
                    boolean bl = IonType.CLOB == this._value_type;
                    int n3 = this._scanner.load_double_quoted_string(stringBuilder, bl);
                    if (n3 == -1) {
                        this._scanner.unexpected_eof();
                    }
                    this._value_type = IonType.STRING;
                    break;
                }
                case 13: {
                    boolean bl = IonType.CLOB == this._value_type;
                    int n4 = this._scanner.load_triple_quoted_string(stringBuilder, bl);
                    if (n4 == -1) {
                        this._scanner.unexpected_eof();
                    }
                    this._value_type = IonType.STRING;
                    break;
                }
                default: {
                    String string = "unexpected token " + IonTokenConstsX.getTokenName(n) + " encountered";
                    throw new IonException(string);
                }
            }
            this._current_value_save_point.markEnd();
            this._current_value_save_point_loaded = true;
            this._current_value_buffer_loaded = true;
            this.tokenValueIsFinished();
        }
        return stringBuilder;
    }

    protected void tokenValueIsFinished() {
        this._scanner.tokenIsFinished();
        if (IonType.BLOB.equals((Object)this._value_type) || IonType.CLOB.equals((Object)this._value_type)) {
            int n = this.get_state_after_value();
            this.set_state(n);
        }
    }

    private final void push_container_state(IonType ionType) {
        int n = this._container_state_stack.length;
        if (this._container_state_top >= n) {
            int n2 = n * 2;
            IonType[] ionTypeArray = new IonType[n2];
            System.arraycopy(this._container_state_stack, 0, ionTypeArray, 0, n);
            this._container_state_stack = ionTypeArray;
        }
        this.set_container_flags(ionType);
        this._container_state_stack[this._container_state_top++] = ionType;
    }

    private final void pop_container_state() {
        --this._container_state_top;
        this.set_container_flags(this.top_state());
        this._eof = false;
        this._has_next_called = false;
        int n = this.get_state_after_container();
        this.set_state(n);
    }

    private final IonType top_state() {
        int n = this._container_state_top - 1;
        IonType ionType = this._container_state_stack[n];
        return ionType;
    }

    @Override
    public IonType getType() {
        return this._value_type;
    }

    @Override
    public boolean isInStruct() {
        boolean bl = false;
        IonType ionType = this.getContainerType();
        if (IonType.STRUCT.equals((Object)ionType)) {
            if (this.getDepth() > 0) {
                bl = true;
            } else assert (IonType.STRUCT.equals((Object)this._nesting_parent));
        }
        return bl;
    }

    private boolean is_in_struct_internal() {
        boolean bl = false;
        IonType ionType = this.getContainerType();
        if (IonType.STRUCT.equals((Object)ionType)) {
            bl = true;
        }
        return bl;
    }

    public IonType getContainerType() {
        if (this._container_state_top == 0) {
            return IonType.DATAGRAM;
        }
        return this._container_state_stack[this._container_state_top - 1];
    }

    @Override
    public int getDepth() {
        int n = this._container_state_top;
        if (n > 0) {
            int n2 = n--;
            IonType ionType = this._container_state_stack[0];
            if (this._nesting_parent == null) {
                if (IonType.DATAGRAM.equals((Object)ionType)) {
                    // empty if block
                }
            } else if (this._nesting_parent.equals((Object)ionType)) {
                --n;
            }
            if (n == n2) {
                System.err.println("so here's a case where we didn't subtract 1");
            }
        }
        return n;
    }

    @Override
    public String getFieldName() {
        if (this.getDepth() == 0 && this.is_in_struct_internal()) {
            return null;
        }
        String string = this._field_name;
        if (string == null && this._field_name_sid > 0) {
            throw new UnknownSymbolException(this._field_name_sid);
        }
        return string;
    }

    final String getRawFieldName() {
        if (this.getDepth() == 0 && this.is_in_struct_internal()) {
            return null;
        }
        return this._field_name;
    }

    int getFieldId() {
        if (this.getDepth() == 0 && this.is_in_struct_internal()) {
            return -1;
        }
        return this._field_name_sid;
    }

    @Override
    public SymbolToken getFieldNameSymbol() {
        if (this.getDepth() == 0 && this.is_in_struct_internal()) {
            return null;
        }
        String string = this._field_name;
        int n = this.getFieldId();
        if (string == null && n == -1) {
            return null;
        }
        return new SymbolTokenImpl(string, n);
    }

    @Override
    public Iterator<String> iterateTypeAnnotations() {
        return PrivateUtils.stringIterator(this.getTypeAnnotations());
    }

    @Override
    public String[] getTypeAnnotations() {
        return PrivateUtils.toStrings(this._annotations, this._annotation_count);
    }

    @Override
    public void stepIn() {
        if (this._value_type == null || this._eof) {
            throw new IllegalStateException();
        }
        switch (this._value_type) {
            case STRUCT: 
            case SEXP: 
            case LIST: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n = this.get_state_at_container_start(this._value_type);
        this.set_state(n);
        this.push_container_state(this._value_type);
        this._scanner.tokenIsFinished();
        try {
            this.finish_value(null);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        if (this._v.isNull()) {
            this._eof = true;
            this._has_next_called = true;
        }
        this._value_type = null;
    }

    @Override
    public void stepOut() {
        if (this.getDepth() < 1) {
            throw new IllegalStateException("Cannot stepOut any further, already at top level.");
        }
        try {
            this.finish_value(null);
            switch (this.getContainerType()) {
                case STRUCT: {
                    if (!this._eof) {
                        this._scanner.skip_over_struct();
                    }
                    break;
                }
                case LIST: {
                    if (!this._eof) {
                        this._scanner.skip_over_list();
                    }
                    break;
                }
                case SEXP: {
                    if (!this._eof) {
                        this._scanner.skip_over_sexp();
                    }
                    break;
                }
                case DATAGRAM: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        this.pop_container_state();
        this._scanner.tokenIsFinished();
        try {
            this.finish_value(null);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        this.clear_value();
    }

    @Override
    public SymbolTable getSymbolTable() {
        return null;
    }

    protected final void parse_error(String string) {
        String string2 = "Syntax error" + this._scanner.input_position() + ": " + string;
        throw new IonReaderTextParsingException(string2);
    }

    protected final void parse_error(Exception exception) {
        String string = "Syntax error at " + this._scanner.input_position() + ": " + exception.getLocalizedMessage();
        throw new IonReaderTextParsingException(string, exception);
    }

    public static class IonReaderTextParsingException
    extends IonException {
        private static final long serialVersionUID = 1L;

        IonReaderTextParsingException(String string) {
            super(string);
        }

        IonReaderTextParsingException(Exception exception) {
            super(exception);
        }

        IonReaderTextParsingException(String string, Exception exception) {
            super(string, exception);
        }
    }

    static enum LOB_STATE {
        EMPTY,
        READ,
        FINISHED;

    }
}

