/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.math.MathContext;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.IonUTF8;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.PrivateScalarConversions;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.impl.UnifiedSavePointManagerX;

abstract class IonReaderBinaryRawX
implements IonReader {
    static final int DEFAULT_CONTAINER_STACK_SIZE = 12;
    static final int DEFAULT_ANNOTATION_SIZE = 10;
    static final int NO_LIMIT = Integer.MIN_VALUE;
    State _state;
    UnifiedInputStreamX _input;
    int _local_remaining;
    boolean _eof;
    boolean _has_next_needed;
    PrivateScalarConversions.ValueVariant _v;
    IonType _value_type;
    boolean _value_is_null;
    boolean _value_is_true;
    int _value_field_id;
    int _value_tid;
    int _value_len;
    int _value_lob_remaining;
    boolean _value_lob_is_ready;
    long _position_start;
    long _position_len;
    UnifiedSavePointManagerX.SavePoint _annotations;
    int[] _annotation_ids;
    int _annotation_count;
    boolean _is_in_struct;
    boolean _struct_is_ordered;
    int _parent_tid;
    int _container_top;
    long[] _container_stack;
    private static final int POS_OFFSET = 0;
    private static final int TYPE_LIMIT_OFFSET = 1;
    private static final long TYPE_MASK = -1L;
    private static final int LIMIT_SHIFT = 32;
    private static final int POS_STACK_STEP = 2;
    private static final int BINARY_VERSION_MARKER_TID = PrivateIonConstants.getTypeCode(PrivateIonConstants.BINARY_VERSION_MARKER_1_0[0] & 0xFF);
    private static final int BINARY_VERSION_MARKER_LEN = PrivateIonConstants.getLowNibble(PrivateIonConstants.BINARY_VERSION_MARKER_1_0[0] & 0xFF);

    protected IonReaderBinaryRawX() {
    }

    @Override
    public <T> T asFacet(Class<T> clazz) {
        return null;
    }

    protected final void init_raw(UnifiedInputStreamX unifiedInputStreamX) {
        this._input = unifiedInputStreamX;
        this._container_stack = new long[12];
        this._annotations = unifiedInputStreamX.savePointAllocate();
        this._v = new PrivateScalarConversions.ValueVariant();
        this._annotation_ids = new int[10];
        this.re_init_raw();
        this._position_start = -1L;
    }

    final void re_init_raw() {
        this._local_remaining = Integer.MIN_VALUE;
        this._parent_tid = 16;
        this._value_field_id = -1;
        this._state = State.S_BEFORE_TID;
        this._has_next_needed = true;
        this._eof = false;
        this._value_type = null;
        this._value_is_null = false;
        this._value_is_true = false;
        this._value_len = 0;
        this._value_lob_remaining = 0;
        this._value_lob_is_ready = false;
        this._annotation_count = 0;
        this._is_in_struct = false;
        this._struct_is_ordered = false;
        this._parent_tid = 0;
        this._container_top = 0;
    }

    @Override
    public void close() throws IOException {
        this._input.close();
    }

    private final void push(int n, long l, int n2) {
        int n3 = this._container_stack.length;
        if (this._container_top + 2 >= n3) {
            int n4 = n3 * 2;
            long[] lArray = new long[n4];
            System.arraycopy(this._container_stack, 0, lArray, 0, n3);
            this._container_stack = lArray;
        }
        this._container_stack[this._container_top + 0] = l;
        long l2 = n2;
        l2 <<= 32;
        this._container_stack[this._container_top + 1] = l2 |= (long)n & 0xFFFFFFFFFFFFFFFFL;
        this._container_top += 2;
    }

    private final long get_top_position() {
        assert (this._container_top > 0);
        long l = this._container_stack[this._container_top - 2 + 0];
        return l;
    }

    private final int get_top_type() {
        assert (this._container_top > 0);
        long l = this._container_stack[this._container_top - 2 + 1];
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (n < 0 || n > 16) {
            this.throwErrorAt("invalid type id in parent stack");
        }
        return n;
    }

    private final int get_top_local_remaining() {
        assert (this._container_top > 0);
        long l = this._container_stack[this._container_top - 2 + 1];
        int n = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return n;
    }

    private final void pop() {
        assert (this._container_top > 0);
        this._container_top -= 2;
    }

    boolean hasNext() {
        if (!this._eof && this._has_next_needed) {
            try {
                this.has_next_helper_raw();
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        }
        return !this._eof;
    }

    @Override
    public IonType next() {
        if (this._eof) {
            return null;
        }
        if (this._has_next_needed) {
            try {
                this.has_next_helper_raw();
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        }
        this._has_next_needed = true;
        assert (this._value_type != null || this._eof);
        return this._value_type;
    }

    private final void has_next_helper_raw() throws IOException {
        this.clear_value();
        block7: while (this._value_tid == -1 && !this._eof) {
            switch (this._state) {
                case S_BEFORE_FIELD: {
                    assert (this._value_field_id == -1);
                    this._value_field_id = this.read_field_id();
                    if (this._value_field_id == -1) {
                        this._eof = true;
                        continue block7;
                    }
                }
                case S_BEFORE_TID: {
                    this._state = State.S_BEFORE_VALUE;
                    this._value_tid = this.read_type_id();
                    if (this._value_tid == -1) {
                        this._state = State.S_EOF;
                        this._eof = true;
                        continue block7;
                    }
                    if (this._value_tid == 14) {
                        assert (this._value_tid == (BINARY_VERSION_MARKER_TID & 0xFF));
                        if (this._value_len == BINARY_VERSION_MARKER_LEN) {
                            this.load_version_marker();
                            this._value_type = IonType.SYMBOL;
                            continue block7;
                        }
                        long l = this._position_start;
                        long l2 = this._position_len;
                        this._value_type = this.load_annotation_start_with_value_type();
                        long l3 = l + l2;
                        long l4 = this._position_start + this._position_len;
                        if (l3 != l4) {
                            throw this.newErrorAt(String.format("Wrapper length mismatch: wrapper %s wrapped value %s", l3, l4));
                        }
                        this._position_start = l;
                        this._position_len = l2;
                        continue block7;
                    }
                    this._value_type = this.get_iontype_from_tid(this._value_tid);
                    continue block7;
                }
                case S_BEFORE_VALUE: {
                    this.skip(this._value_len);
                }
                case S_AFTER_VALUE: {
                    if (this.isInStruct()) {
                        this._state = State.S_BEFORE_FIELD;
                        continue block7;
                    }
                    this._state = State.S_BEFORE_TID;
                    continue block7;
                }
                case S_EOF: {
                    continue block7;
                }
            }
            this.error("internal error: raw binary reader in invalid state!");
        }
        this._has_next_needed = false;
    }

    private final void load_version_marker() throws IOException {
        for (int i = 1; i < PrivateIonConstants.BINARY_VERSION_MARKER_1_0.length; ++i) {
            int n = this.read();
            if (n == (PrivateIonConstants.BINARY_VERSION_MARKER_1_0[i] & 0xFF)) continue;
            this.throwErrorAt("invalid binary image");
        }
        this._value_tid = 7;
        this._value_len = 0;
        this._v.setValue(2);
        this._v.setAuthoritativeType(3);
        this._value_is_null = false;
        this._value_lob_is_ready = false;
        this._annotations.clear();
        this._value_field_id = -1;
        this._state = State.S_AFTER_VALUE;
    }

    private final IonType load_annotation_start_with_value_type() throws IOException {
        int n = this.readVarUInt();
        this._annotations.start(this.getPosition(), 0L);
        this.skip(n);
        this._annotations.markEnd();
        this._value_tid = this.read_type_id();
        if (this._value_tid == -1) {
            this.throwErrorAt("unexpected EOF encountered where a type descriptor byte was expected");
        }
        IonType ionType = this.get_iontype_from_tid(this._value_tid);
        assert (ionType != null);
        return ionType;
    }

    protected final int load_annotations() {
        switch (this._state) {
            case S_BEFORE_VALUE: 
            case S_AFTER_VALUE: {
                if (!this._annotations.isDefined()) break;
                int n = this._local_remaining;
                this._input._save_points.savePointPushActive(this._annotations, this.getPosition(), 0L);
                this._local_remaining = Integer.MIN_VALUE;
                this._annotation_count = 0;
                try {
                    int n2;
                    while ((n2 = this.readVarUIntOrEOF()) != -1) {
                        this.load_annotation_append(n2);
                        if (!this.isEOF()) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.error(iOException);
                }
                this._input._save_points.savePointPopActive(this._annotations);
                this._local_remaining = n;
                this._annotations.clear();
                break;
            }
            default: {
                throw new IllegalStateException("annotations require the value to be ready");
            }
        }
        return this._annotation_count;
    }

    private final void load_annotation_append(int n) {
        int n2 = this._annotation_ids.length;
        if (this._annotation_count >= n2) {
            int n3 = n2 * 2;
            int[] nArray = new int[n3];
            System.arraycopy(this._annotation_ids, 0, nArray, 0, n2);
            this._annotation_ids = nArray;
        }
        this._annotation_ids[this._annotation_count++] = n;
    }

    private final void clear_value() {
        this._value_type = null;
        this._value_tid = -1;
        this._value_is_null = false;
        this._value_lob_is_ready = false;
        this._annotations.clear();
        this._v.clear();
        this._annotation_count = 0;
        this._value_field_id = -1;
    }

    private final int read_field_id() throws IOException {
        int n = this.readVarUIntOrEOF();
        return n;
    }

    private final int read_type_id() throws IOException {
        long l = this._input.getPosition();
        long l2 = l + 1L;
        int n = this.read();
        if (n < 0) {
            return -1;
        }
        int n2 = PrivateIonConstants.getTypeCode(n);
        int n3 = PrivateIonConstants.getLowNibble(n);
        if (n3 == 14) {
            n3 = this.readVarUInt();
            l2 = this._input.getPosition();
        } else if (n2 == 0) {
            if (n3 != 15) {
                this.throwErrorAt("invalid null type descriptor");
            }
            this._value_is_null = true;
            n3 = 0;
            this._state = State.S_AFTER_VALUE;
        } else if (n3 == 15) {
            this._value_is_null = true;
            n3 = 0;
            this._state = State.S_AFTER_VALUE;
        } else if (n2 == 1) {
            switch (n3) {
                case 0: {
                    this._value_is_true = false;
                    break;
                }
                case 1: {
                    this._value_is_true = true;
                    break;
                }
                default: {
                    this.throwErrorAt("invalid length nibble in boolean value: " + n3);
                }
            }
            n3 = 0;
            this._state = State.S_AFTER_VALUE;
        } else if (n2 == 13 && (this._struct_is_ordered = n3 == 1)) {
            n3 = this.readVarUInt();
            l2 = this._input.getPosition();
        }
        this._value_tid = n2;
        this._value_len = n3;
        this._position_len = (long)n3 + (l2 - l);
        this._position_start = l;
        return n2;
    }

    private final IonType get_iontype_from_tid(int n) {
        IonType ionType = null;
        switch (n) {
            case 0: {
                ionType = IonType.NULL;
                break;
            }
            case 1: {
                ionType = IonType.BOOL;
                break;
            }
            case 2: 
            case 3: {
                ionType = IonType.INT;
                break;
            }
            case 4: {
                ionType = IonType.FLOAT;
                break;
            }
            case 5: {
                ionType = IonType.DECIMAL;
                break;
            }
            case 6: {
                ionType = IonType.TIMESTAMP;
                break;
            }
            case 7: {
                ionType = IonType.SYMBOL;
                break;
            }
            case 8: {
                ionType = IonType.STRING;
                break;
            }
            case 9: {
                ionType = IonType.CLOB;
                break;
            }
            case 10: {
                ionType = IonType.BLOB;
                break;
            }
            case 11: {
                ionType = IonType.LIST;
                break;
            }
            case 12: {
                ionType = IonType.SEXP;
                break;
            }
            case 13: {
                ionType = IonType.STRUCT;
                break;
            }
            case 14: {
                ionType = null;
                break;
            }
            default: {
                throw this.newErrorAt("unrecognized value type encountered: " + n);
            }
        }
        return ionType;
    }

    @Override
    public void stepIn() {
        if (this._value_type == null || this._eof) {
            throw new IllegalStateException();
        }
        switch (this._value_type) {
            case STRUCT: 
            case LIST: 
            case SEXP: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this._value_is_null ? this._state != State.S_AFTER_VALUE && !$assertionsDisabled && this._state != State.S_AFTER_VALUE : this._state != State.S_BEFORE_VALUE && !$assertionsDisabled && this._state != State.S_BEFORE_VALUE) {
            throw new AssertionError();
        }
        long l = this.getPosition();
        long l2 = l + (long)this._value_len;
        int n = this._local_remaining;
        if (n != Integer.MIN_VALUE && (n -= this._value_len) < 0) {
            n = 0;
        }
        this.push(this._parent_tid, l2, n);
        this._is_in_struct = this._value_tid == 13;
        this._local_remaining = this._value_len;
        this._state = this._is_in_struct ? State.S_BEFORE_FIELD : State.S_BEFORE_TID;
        this._parent_tid = this._value_tid;
        this.clear_value();
        this._has_next_needed = true;
    }

    @Override
    public void stepOut() {
        if (this.getDepth() < 1) {
            throw new IllegalStateException("Cannot stepOut any further, already at top level.");
        }
        long l = this.get_top_position();
        int n = this.get_top_local_remaining();
        int n2 = this.get_top_type();
        this.pop();
        this._eof = false;
        this._parent_tid = n2;
        if (this._parent_tid == 13) {
            this._is_in_struct = true;
            this._state = State.S_BEFORE_FIELD;
        } else {
            this._is_in_struct = false;
            this._state = State.S_BEFORE_TID;
        }
        this._has_next_needed = true;
        this.clear_value();
        long l2 = this.getPosition();
        if (l > l2) {
            try {
                long l3;
                int n3 = 0x7FFFFFFE;
                for (l3 = l - l2; l3 > (long)n3; l3 -= (long)n3) {
                    this.skip(n3);
                }
                if (l3 > 0L) {
                    assert (l3 < Integer.MAX_VALUE);
                    this.skip((int)l3);
                }
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        } else if (l < l2) {
            String string = "invalid position during stepOut, current position " + l2 + " next value at " + l;
            this.error(string);
        }
        assert (l == this.getPosition());
        this._local_remaining = n;
    }

    @Override
    public int byteSize() {
        switch (this._value_type) {
            case BLOB: 
            case CLOB: {
                break;
            }
            default: {
                throw new IllegalStateException("only valid for LOB values");
            }
        }
        if (!this._value_lob_is_ready) {
            int n = this._value_is_null ? 0 : this._value_len;
            this._value_lob_remaining = n;
            this._value_lob_is_ready = true;
        }
        return this._value_lob_remaining;
    }

    @Override
    public byte[] newBytes() {
        byte[] byArray;
        int n = this.byteSize();
        if (this._value_is_null) {
            byArray = null;
        } else {
            byArray = new byte[n];
            this.getBytes(byArray, 0, n);
        }
        return byArray;
    }

    @Override
    public int getBytes(byte[] byArray, int n, int n2) {
        int n3 = this.byteSize();
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = this.readBytes(byArray, n, n3);
        return n4;
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = this.byteSize();
        if (this._value_lob_remaining > n2) {
            n2 = this._value_lob_remaining;
        }
        if (n2 < 1) {
            return 0;
        }
        try {
            n3 = this.read(byArray, n, n4);
            this._value_lob_remaining -= n3;
        }
        catch (IOException iOException) {
            n3 = -1;
            this.error(iOException);
        }
        if (this._value_lob_remaining == 0) {
            this._state = State.S_AFTER_VALUE;
        } else {
            this._value_len = this._value_lob_remaining;
        }
        return n3;
    }

    @Override
    public int getDepth() {
        return this._container_top / 2;
    }

    @Override
    public IonType getType() {
        return this._value_type;
    }

    @Override
    public boolean isInStruct() {
        return this._is_in_struct;
    }

    @Override
    public boolean isNullValue() {
        return this._value_is_null;
    }

    private final int read() throws IOException {
        if (this._local_remaining != Integer.MIN_VALUE) {
            if (this._local_remaining < 1) {
                return -1;
            }
            --this._local_remaining;
        }
        return this._input.read();
    }

    private final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException();
        }
        if (this._local_remaining == Integer.MIN_VALUE) {
            n3 = this._input.read(byArray, n, n2);
        } else {
            if (n2 > this._local_remaining) {
                if (this._local_remaining < 1) {
                    this.throwUnexpectedEOFException();
                }
                n2 = this._local_remaining;
            }
            n3 = this._input.read(byArray, n, n2);
            this._local_remaining -= n3;
        }
        return n3;
    }

    public void readAll(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = this.read(byArray, n, n3);
            if (n4 <= 0) {
                this.throwUnexpectedEOFException();
            }
            n3 -= n4;
            n += n4;
        }
    }

    private final boolean isEOF() {
        if (this._local_remaining > 0) {
            return false;
        }
        if (this._local_remaining == Integer.MIN_VALUE) {
            return this._input.isEOF();
        }
        return true;
    }

    private final long getPosition() {
        long l = this._input.getPosition();
        return l;
    }

    private final void skip(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this._local_remaining == Integer.MIN_VALUE) {
            this._input.skip(n);
        } else {
            if (n > this._local_remaining) {
                if (this._local_remaining < 1) {
                    this.throwUnexpectedEOFException();
                }
                n = this._local_remaining;
            }
            this._input.skip(n);
            this._local_remaining -= n;
        }
    }

    protected final long readULong(int n) throws IOException {
        long l = 0L;
        switch (n) {
            default: {
                throw new IonException("value too large for Java long");
            }
            case 8: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 7: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 6: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 5: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 4: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 3: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 2: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 1: {
                int n2 = this.read();
                if (n2 < 0) {
                    this.throwUnexpectedEOFException();
                }
                l = l << 8 | (long)n2;
            }
            case 0: 
        }
        return l;
    }

    protected final BigInteger readBigInteger(int n, boolean bl) throws IOException {
        BigInteger bigInteger;
        if (n > 0) {
            byte[] byArray = new byte[n];
            this.readAll(byArray, 0, n);
            int n2 = bl ? -1 : 1;
            bigInteger = new BigInteger(n2, byArray);
        } else {
            bigInteger = BigInteger.ZERO;
        }
        return bigInteger;
    }

    protected final int readVarInt() throws IOException {
        int n = 0;
        boolean bl = false;
        while (true) {
            int n2;
            if ((n2 = this.read()) < 0) {
                this.throwUnexpectedEOFException();
            }
            if ((n2 & 0x40) != 0) {
                bl = true;
            }
            n = n2 & 0x3F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            this.throwIntOverflowExeption();
        }
        if (bl) {
            n = -n;
        }
        return n;
    }

    protected final long readVarLong() throws IOException {
        long l = 0L;
        boolean bl = false;
        int n = this.read();
        if (n < 0) {
            this.throwUnexpectedEOFException();
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        l = n & 0x3F;
        if ((n & 0x80) == 0) {
            n = this.read();
            if (n < 0) {
                this.throwUnexpectedEOFException();
            }
            l = l << 7 | (long)(n & 0x7F);
            if ((n & 0x80) == 0) {
                do {
                    if ((n = this.read()) < 0) {
                        this.throwUnexpectedEOFException();
                    }
                    if ((l & 0xFE00000000000000L) != 0L) {
                        this.throwIntOverflowExeption();
                    }
                    l = l << 7 | (long)(n & 0x7F);
                } while ((n & 0x80) == 0);
            }
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    protected final Integer readVarInteger() throws IOException {
        int n = 0;
        boolean bl = false;
        while (true) {
            int n2;
            if ((n2 = this.read()) < 0) {
                this.throwUnexpectedEOFException();
            }
            if ((n2 & 0x40) != 0) {
                bl = true;
            }
            n = n2 & 0x3F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            this.throwIntOverflowExeption();
        }
        Integer n3 = null;
        if (bl) {
            if (n != 0) {
                n3 = new Integer(-n);
            }
        } else {
            n3 = new Integer(n);
        }
        return n3;
    }

    protected final int readVarUIntOrEOF() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.read()) < 0) {
                return -1;
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            this.throwIntOverflowExeption();
        }
        return n;
    }

    protected final int readVarUInt() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.read()) < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            n2 = this.read();
            if (n2 < 0) {
                this.throwUnexpectedEOFException();
            }
            n = n << 7 | n2 & 0x7F;
            if ((n2 & 0x80) != 0) break;
            this.throwIntOverflowExeption();
        }
        return n;
    }

    protected final double readFloat(int n) throws IOException {
        if (n == 0) {
            return 0.0;
        }
        if (n != 4 && n != 8) {
            throw new IOException("Length of float read must be 0, 4, or 8");
        }
        long l = this.readULong(n);
        return n == 4 ? (double)Float.intBitsToFloat((int)(l & 0xFFFFFFFFL)) : Double.longBitsToDouble(l);
    }

    protected final long readVarULong() throws IOException {
        int n;
        long l = 0L;
        do {
            if ((n = this.read()) < 0) {
                this.throwUnexpectedEOFException();
            }
            if ((l & 0xFE00000000000000L) != 0L) {
                this.throwIntOverflowExeption();
            }
            l = l << 7 | (long)(n & 0x7F);
        } while ((n & 0x80) == 0);
        return l;
    }

    protected final Decimal readDecimal(int n) throws IOException {
        Decimal decimal;
        MathContext mathContext = MathContext.UNLIMITED;
        if (n == 0) {
            decimal = Decimal.valueOf(0, mathContext);
        } else {
            BigInteger bigInteger;
            int n2;
            int n3 = this._local_remaining - n;
            this._local_remaining = n;
            int n4 = this.readVarInt();
            if (this._local_remaining > 0) {
                byte[] byArray = new byte[this._local_remaining];
                this.readAll(byArray, 0, this._local_remaining);
                n2 = 1;
                if (byArray[0] < 0) {
                    byArray[0] = (byte)(byArray[0] & 0x7F);
                    n2 = -1;
                }
                bigInteger = new BigInteger(n2, byArray);
            } else {
                n2 = 0;
                bigInteger = BigInteger.ZERO;
            }
            int n5 = -n4;
            if (bigInteger.signum() == 0 && n2 == -1) {
                assert (bigInteger.equals(BigInteger.ZERO));
                decimal = Decimal.negativeZero(n5, mathContext);
            } else {
                decimal = Decimal.valueOf(bigInteger, n5, mathContext);
            }
            this._local_remaining = n3;
        }
        return decimal;
    }

    protected final Timestamp readTimestamp(int n) throws IOException {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Decimal decimal = null;
        int n8 = this._local_remaining - n;
        this._local_remaining = n;
        Integer n9 = this.readVarInteger();
        n2 = this.readVarUInt();
        Timestamp.Precision precision = Timestamp.Precision.YEAR;
        if (this._local_remaining > 0) {
            n3 = this.readVarUInt();
            precision = Timestamp.Precision.MONTH;
            if (this._local_remaining > 0) {
                n4 = this.readVarUInt();
                precision = Timestamp.Precision.DAY;
                if (this._local_remaining > 0) {
                    n5 = this.readVarUInt();
                    n6 = this.readVarUInt();
                    precision = Timestamp.Precision.MINUTE;
                    if (this._local_remaining > 0) {
                        n7 = this.readVarUInt();
                        precision = Timestamp.Precision.SECOND;
                        if (this._local_remaining > 0) {
                            decimal = this.readDecimal(this._local_remaining);
                        }
                    }
                }
            }
        }
        this._local_remaining = n8;
        try {
            Timestamp timestamp = Timestamp.createFromUtcFields(precision, n2, n3, n4, n5, n6, n7, decimal, n9);
            return timestamp;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.newErrorAt("Invalid timestamp encoding: " + illegalArgumentException.getMessage());
        }
    }

    protected final String readString(int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = this._local_remaining - n;
        this._local_remaining = n;
        while (!this.isEOF()) {
            int n4 = this.readUnicodeScalar();
            if (n4 < 0) {
                this.throwUnexpectedEOFException();
            }
            if (n4 < 65536) {
                cArray[n2++] = (char)n4;
                continue;
            }
            cArray[n2++] = (char)PrivateIonConstants.makeHighSurrogate(n4);
            cArray[n2++] = (char)PrivateIonConstants.makeLowSurrogate(n4);
        }
        this._local_remaining = n3;
        return new String(cArray, 0, n2);
    }

    private final int readUnicodeScalar() throws IOException {
        int n = -1;
        int n2 = this.read();
        if (IonUTF8.isOneByteUTF8(n2)) {
            return n2;
        }
        switch (IonUTF8.getUTF8LengthFromFirstByte(n2)) {
            case 2: {
                assert ((n2 & 0xE0) == 192);
                int n3 = this.read();
                if (!IonUTF8.isContinueByteUTF8(n3)) {
                    this.throwUTF8Exception();
                }
                n = IonUTF8.twoByteScalar(n2, n3);
                break;
            }
            case 3: {
                int n4;
                assert ((n2 & 0xF0) == 224);
                int n5 = this.read();
                if (!IonUTF8.isContinueByteUTF8(n5)) {
                    this.throwUTF8Exception();
                }
                if (!IonUTF8.isContinueByteUTF8(n4 = this.read())) {
                    this.throwUTF8Exception();
                }
                n = IonUTF8.threeByteScalar(n2, n5, n4);
                break;
            }
            case 4: {
                int n6;
                int n7;
                assert ((n2 & 0xF8) == 240);
                int n8 = this.read();
                if (!IonUTF8.isContinueByteUTF8(n8)) {
                    this.throwUTF8Exception();
                }
                if (!IonUTF8.isContinueByteUTF8(n7 = this.read())) {
                    this.throwUTF8Exception();
                }
                if (!IonUTF8.isContinueByteUTF8(n6 = this.read())) {
                    this.throwUTF8Exception();
                }
                if ((n = IonUTF8.fourByteScalar(n2, n8, n7, n6)) <= 0x10FFFF) break;
                throw new IonException("illegal utf value encountered in input utf-8 stream");
            }
            default: {
                this.throwUTF8Exception();
            }
        }
        return n;
    }

    private final void throwUTF8Exception() throws IOException {
        this.throwErrorAt("Invalid UTF-8 character encounter in a string at position ");
    }

    private final void throwUnexpectedEOFException() throws IOException {
        this.throwErrorAt("unexpected EOF in value");
    }

    private final void throwIntOverflowExeption() throws IOException {
        this.throwErrorAt("int in stream is too long for a Java int 32 use readLong()");
    }

    protected IonException newErrorAt(String string) {
        String string2 = string + " at position " + this.getPosition();
        return new IonException(string2);
    }

    protected void throwErrorAt(String string) {
        throw this.newErrorAt(string);
    }

    protected void error(String string) {
        throw new IonException(string);
    }

    protected void error(Exception exception) {
        throw new IonException(exception);
    }

    protected static enum State {
        S_INVALID,
        S_BEFORE_FIELD,
        S_BEFORE_TID,
        S_BEFORE_VALUE,
        S_AFTER_VALUE,
        S_EOF;

    }
}

