/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.apps;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonWriter;
import software.amazon.ion.apps.BaseApp;

public class PrintApp
extends BaseApp {
    private File myOutputDir;
    private String myOutputFile;

    public static void main(String[] stringArray) {
        PrintApp printApp = new PrintApp();
        printApp.doMain(stringArray);
    }

    @Override
    protected int processOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            if ("--catalog".equals(string2)) {
                string = stringArray[++i];
                this.loadCatalog(string);
                continue;
            }
            if ("--output-dir".equals(string2)) {
                string = stringArray[++i];
                this.myOutputDir = new File(string);
                if (this.myOutputDir.isDirectory() && this.myOutputDir.canWrite()) continue;
                throw new RuntimeException("Not a writeable directory: " + string);
            }
            if ("--output".equals(string2)) {
                this.myOutputFile = string = stringArray[++i];
                this.myOutputDir = new File(string).getParentFile();
                if (this.myOutputDir.isDirectory() && this.myOutputDir.canWrite()) continue;
                throw new RuntimeException("Not a writeable directory: " + string);
            }
            return i;
        }
        return stringArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(File file, IonReader ionReader) throws IOException, IonException {
        if (this.myOutputDir == null) {
            this.process(ionReader, System.out);
        } else {
            String string = file.getName();
            File file2 = new File(this.myOutputDir, string);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                this.process(ionReader, fileOutputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(IonReader ionReader) throws IOException, IonException {
        if (this.myOutputDir == null) {
            this.process(ionReader, System.out);
        } else {
            File file = new File(this.myOutputFile);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                this.process(ionReader, fileOutputStream);
            }
        }
    }

    protected void process(IonReader ionReader, OutputStream outputStream2) throws IOException, IonException {
        IonSystem ionSystem = this.mySystem;
        IonWriter ionWriter = ionSystem.newTextWriter(outputStream2);
        ionWriter.writeValues(ionReader);
        outputStream2.write(10);
        outputStream2.flush();
    }
}

