/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleNamespaceContext
implements NamespaceContext {
    private final Map<String, String> prefixToNamespaceUri = new HashMap<String, String>();
    private final Map<String, Set<String>> namespaceUriToPrefixes = new HashMap<String, Set<String>>();
    private String defaultNamespaceUri = "";

    @Override
    public String getNamespaceURI(String string) {
        Assert.notNull((Object)string, "No prefix given");
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("".equals(string)) {
            return this.defaultNamespaceUri;
        }
        if (this.prefixToNamespaceUri.containsKey(string)) {
            return this.prefixToNamespaceUri.get(string);
        }
        return "";
    }

    @Override
    @Nullable
    public String getPrefix(String string) {
        Set<String> set = this.getPrefixesSet(string);
        return !set.isEmpty() ? set.iterator().next() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return this.getPrefixesSet(string).iterator();
    }

    private Set<String> getPrefixesSet(String string) {
        Assert.notNull((Object)string, "No namespaceUri given");
        if (this.defaultNamespaceUri.equals(string)) {
            return Collections.singleton("");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return Collections.singleton("xml");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return Collections.singleton("xmlns");
        }
        Set<String> set = this.namespaceUriToPrefixes.get(string);
        return set != null ? Collections.unmodifiableSet(set) : Collections.emptySet();
    }

    public void setBindings(Map<String, String> map) {
        map.forEach(this::bindNamespaceUri);
    }

    public void bindDefaultNamespaceUri(String string) {
        this.bindNamespaceUri("", string);
    }

    public void bindNamespaceUri(String string2, String string3) {
        Assert.notNull((Object)string2, "No prefix given");
        Assert.notNull((Object)string3, "No namespaceUri given");
        if ("".equals(string2)) {
            this.defaultNamespaceUri = string3;
        } else {
            this.prefixToNamespaceUri.put(string2, string3);
            Set set = this.namespaceUriToPrefixes.computeIfAbsent(string3, string -> new LinkedHashSet());
            set.add(string2);
        }
    }

    public void removeBinding(@Nullable String string) {
        Set<String> set;
        String string2;
        if ("".equals(string)) {
            this.defaultNamespaceUri = "";
        } else if (string != null && (string2 = this.prefixToNamespaceUri.remove(string)) != null && (set = this.namespaceUriToPrefixes.get(string2)) != null) {
            set.remove(string);
            if (set.isEmpty()) {
                this.namespaceUriToPrefixes.remove(string2);
            }
        }
    }

    public void clear() {
        this.prefixToNamespaceUri.clear();
        this.namespaceUriToPrefixes.clear();
    }

    public Iterator<String> getBoundPrefixes() {
        return this.prefixToNamespaceUri.keySet().iterator();
    }
}

