/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.lang.Nullable;

abstract class AbstractXMLStreamReader
implements XMLStreamReader {
    AbstractXMLStreamReader() {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("Parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int n = this.next();
        StringBuilder stringBuilder = new StringBuilder();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuilder.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("Unexpected end of document when reading element text content", this.getLocation());
                }
                if (n == 1) {
                    throw new XMLStreamException("Element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + n, this.getLocation());
            }
            n = this.next();
        }
        return stringBuilder.toString();
    }

    @Override
    public String getAttributeLocalName(int n) {
        return this.getAttributeName(n).getLocalPart();
    }

    @Override
    public String getAttributeNamespace(int n) {
        return this.getAttributeName(n).getNamespaceURI();
    }

    @Override
    public String getAttributePrefix(int n) {
        return this.getAttributeName(n).getPrefix();
    }

    @Override
    public String getNamespaceURI() {
        int n = this.getEventType();
        if (n == 1 || n == 2) {
            return this.getName().getNamespaceURI();
        }
        throw new IllegalStateException("Parser must be on START_ELEMENT or END_ELEMENT state");
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.getNamespaceContext().getNamespaceURI(string);
    }

    @Override
    public boolean hasText() {
        int n = this.getEventType();
        return n == 6 || n == 4 || n == 5 || n == 12 || n == 9;
    }

    @Override
    public String getPrefix() {
        int n = this.getEventType();
        if (n == 1 || n == 2) {
            return this.getName().getPrefix();
        }
        throw new IllegalStateException("Parser must be on START_ELEMENT or END_ELEMENT state");
    }

    @Override
    public boolean hasName() {
        int n = this.getEventType();
        return n == 1 || n == 2;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.getEventType() == 6;
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return n;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        int n2 = this.getEventType();
        if (n2 != n) {
            throw new XMLStreamException("Expected [" + n + "] but read [" + n2 + "]");
        }
    }

    @Override
    @Nullable
    public String getAttributeValue(@Nullable String string, String string2) {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            QName qName = this.getAttributeName(i);
            if (!qName.getLocalPart().equals(string2) || string != null && !qName.getNamespaceURI().equals(string)) continue;
            return this.getAttributeValue(i);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.getEventType() != 8;
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) {
        char[] cArray2 = this.getTextCharacters();
        n3 = Math.min(n3, cArray2.length);
        System.arraycopy(cArray2, n, cArray, n2, n3);
        return n3;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }
}

