/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;
import org.springframework.util.concurrent.SuccessCallback;

public class SettableListenableFuture<T>
implements ListenableFuture<T> {
    private static final Callable<Object> DUMMY_CALLABLE = () -> {
        throw new IllegalStateException("Should never be called");
    };
    private final SettableTask<T> settableTask = new SettableTask();

    public boolean set(@Nullable T t2) {
        return this.settableTask.setResultValue(t2);
    }

    public boolean setException(Throwable throwable) {
        Assert.notNull((Object)throwable, "Exception must not be null");
        return this.settableTask.setExceptionResult(throwable);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> listenableFutureCallback) {
        this.settableTask.addCallback(listenableFutureCallback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.settableTask.addCallback(successCallback, failureCallback);
    }

    @Override
    public CompletableFuture<T> completable() {
        return this.settableTask.completable();
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = this.settableTask.cancel(bl);
        if (bl2 && bl) {
            this.interruptTask();
        }
        return bl2;
    }

    @Override
    public boolean isCancelled() {
        return this.settableTask.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.settableTask.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.settableTask.get();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.settableTask.get(l, timeUnit);
    }

    protected void interruptTask() {
    }

    private static class SettableTask<T>
    extends ListenableFutureTask<T> {
        @Nullable
        private volatile Thread completingThread;

        public SettableTask() {
            super(DUMMY_CALLABLE);
        }

        public boolean setResultValue(@Nullable T t2) {
            this.set(t2);
            return this.checkCompletingThread();
        }

        public boolean setExceptionResult(Throwable throwable) {
            this.setException(throwable);
            return this.checkCompletingThread();
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                this.completingThread = Thread.currentThread();
            }
            super.done();
        }

        private boolean checkCompletingThread() {
            boolean bl;
            boolean bl2 = bl = this.completingThread == Thread.currentThread();
            if (bl) {
                this.completingThread = null;
            }
            return bl;
        }
    }
}

