/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.util.Comparator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.comparator.ComparableComparator;

public class NullSafeComparator<T>
implements Comparator<T> {
    public static final NullSafeComparator NULLS_LOW = new NullSafeComparator(true);
    public static final NullSafeComparator NULLS_HIGH = new NullSafeComparator(false);
    private final Comparator<T> nonNullComparator;
    private final boolean nullsLow;

    private NullSafeComparator(boolean bl) {
        this.nonNullComparator = ComparableComparator.INSTANCE;
        this.nullsLow = bl;
    }

    public NullSafeComparator(Comparator<T> comparator, boolean bl) {
        Assert.notNull(comparator, "Non-null Comparator is required");
        this.nonNullComparator = comparator;
        this.nullsLow = bl;
    }

    @Override
    public int compare(@Nullable T t2, @Nullable T t3) {
        if (t2 == t3) {
            return 0;
        }
        if (t2 == null) {
            return this.nullsLow ? -1 : 1;
        }
        if (t3 == null) {
            return this.nullsLow ? 1 : -1;
        }
        return this.nonNullComparator.compare(t2, t3);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NullSafeComparator)) {
            return false;
        }
        NullSafeComparator nullSafeComparator = (NullSafeComparator)object;
        return this.nonNullComparator.equals(nullSafeComparator.nonNullComparator) && this.nullsLow == nullSafeComparator.nullsLow;
    }

    public int hashCode() {
        return this.nonNullComparator.hashCode() * (this.nullsLow ? -1 : 1);
    }

    public String toString() {
        return "NullSafeComparator: non-null comparator [" + this.nonNullComparator + "]; " + (this.nullsLow ? "nulls low" : "nulls high");
    }
}

