/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.util.Comparator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InstanceComparator<T>
implements Comparator<T> {
    private final Class<?>[] instanceOrder;

    public InstanceComparator(Class<?> ... classArray) {
        Assert.notNull(classArray, "'instanceOrder' array must not be null");
        this.instanceOrder = classArray;
    }

    @Override
    public int compare(T t2, T t3) {
        int n = this.getOrder(t2);
        int n2 = this.getOrder(t3);
        return Integer.compare(n, n2);
    }

    private int getOrder(@Nullable T t2) {
        if (t2 != null) {
            for (int i = 0; i < this.instanceOrder.length; ++i) {
                if (!this.instanceOrder[i].isInstance(t2)) continue;
                return i;
            }
        }
        return this.instanceOrder.length;
    }
}

