/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

public class SocketUtils {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.nanoTime());

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int n) {
        return SocketUtils.findAvailableTcpPort(n, 65535);
    }

    public static int findAvailableTcpPort(int n, int n2) {
        return SocketType.TCP.findAvailablePort(n, n2);
    }

    public static SortedSet<Integer> findAvailableTcpPorts(int n) {
        return SocketUtils.findAvailableTcpPorts(n, 1024, 65535);
    }

    public static SortedSet<Integer> findAvailableTcpPorts(int n, int n2, int n3) {
        return SocketType.TCP.findAvailablePorts(n, n2, n3);
    }

    public static int findAvailableUdpPort() {
        return SocketUtils.findAvailableUdpPort(1024);
    }

    public static int findAvailableUdpPort(int n) {
        return SocketUtils.findAvailableUdpPort(n, 65535);
    }

    public static int findAvailableUdpPort(int n, int n2) {
        return SocketType.UDP.findAvailablePort(n, n2);
    }

    public static SortedSet<Integer> findAvailableUdpPorts(int n) {
        return SocketUtils.findAvailableUdpPorts(n, 1024, 65535);
    }

    public static SortedSet<Integer> findAvailableUdpPorts(int n, int n2, int n3) {
        return SocketType.UDP.findAvailablePorts(n, n2, n3);
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int n) {
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(n, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        ,
        UDP{

            @Override
            protected boolean isPortAvailable(int n) {
                try {
                    DatagramSocket datagramSocket = new DatagramSocket(n, InetAddress.getByName("localhost"));
                    datagramSocket.close();
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        private int findRandomPort(int n, int n2) {
            int n3 = n2 - n;
            return n + random.nextInt(n3 + 1);
        }

        int findAvailablePort(int n, int n2) {
            int n3;
            Assert.isTrue(n > 0, "'minPort' must be greater than 0");
            Assert.isTrue(n2 >= n, "'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue(n2 <= 65535, "'maxPort' must be less than or equal to 65535");
            int n4 = n2 - n;
            int n5 = 0;
            do {
                if (n5 > n4) {
                    throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), n, n2, n5));
                }
                n3 = this.findRandomPort(n, n2);
                ++n5;
            } while (!this.isPortAvailable(n3));
            return n3;
        }

        SortedSet<Integer> findAvailablePorts(int n, int n2, int n3) {
            Assert.isTrue(n2 > 0, "'minPort' must be greater than 0");
            Assert.isTrue(n3 > n2, "'maxPort' must be greater than 'minPort'");
            Assert.isTrue(n3 <= 65535, "'maxPort' must be less than or equal to 65535");
            Assert.isTrue(n > 0, "'numRequested' must be greater than 0");
            Assert.isTrue(n3 - n2 >= n, "'numRequested' must not be greater than 'maxPort' - 'minPort'");
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            int n4 = 0;
            while (++n4 <= n + 100 && treeSet.size() < n) {
                treeSet.add(this.findAvailablePort(n2, n3));
            }
            if (treeSet.size() != n) {
                throw new IllegalStateException(String.format("Could not find %d available %s ports in the range [%d, %d]", n, this.name(), n2, n3));
            }
            return treeSet;
        }
    }
}

