/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.springframework.lang.Nullable;

public abstract class SerializationUtils {
    @Nullable
    public static byte[] serialize(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + object.getClass(), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Object deserialize(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to deserialize object", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Failed to deserialize object type", classNotFoundException);
        }
    }
}

