/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static boolean isUrl(@Nullable String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL getURL(String string) throws FileNotFoundException {
        Assert.notNull((Object)string, "Resource location must not be null");
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            URL uRL;
            String string2 = string.substring(CLASSPATH_URL_PREFIX.length());
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string2) : ClassLoader.getSystemResource(string2);
            if (uRL == null) {
                String string3 = "class path resource [" + string2 + "]";
                throw new FileNotFoundException(string3 + " cannot be resolved to URL because it does not exist");
            }
            return uRL;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                throw new FileNotFoundException("Resource location [" + string + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static File getFile(String string) throws FileNotFoundException {
        Assert.notNull((Object)string, "Resource location must not be null");
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            URL uRL;
            String string2 = string.substring(CLASSPATH_URL_PREFIX.length());
            String string3 = "class path resource [" + string2 + "]";
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string2) : ClassLoader.getSystemResource(string2);
            if (uRL == null) {
                throw new FileNotFoundException(string3 + " cannot be resolved to absolute file path because it does not exist");
            }
            return ResourceUtils.getFile(uRL, string3);
        }
        try {
            return ResourceUtils.getFile(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string);
        }
    }

    public static File getFile(URL uRL) throws FileNotFoundException {
        return ResourceUtils.getFile(uRL, "URL");
    }

    public static File getFile(URL uRL, String string) throws FileNotFoundException {
        Assert.notNull((Object)uRL, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(uRL.getProtocol())) {
            throw new FileNotFoundException(string + " cannot be resolved to absolute file path because it does not reside in the file system: " + uRL);
        }
        try {
            return new File(ResourceUtils.toURI(uRL).getSchemeSpecificPart());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getFile());
        }
    }

    public static File getFile(URI uRI) throws FileNotFoundException {
        return ResourceUtils.getFile(uRI, "URI");
    }

    public static File getFile(URI uRI, String string) throws FileNotFoundException {
        Assert.notNull((Object)uRI, "Resource URI must not be null");
        if (!URL_PROTOCOL_FILE.equals(uRI.getScheme())) {
            throw new FileNotFoundException(string + " cannot be resolved to absolute file path because it does not reside in the file system: " + uRI);
        }
        return new File(uRI.getSchemeSpecificPart());
    }

    public static boolean isFileURL(URL uRL) {
        String string = uRL.getProtocol();
        return URL_PROTOCOL_FILE.equals(string) || URL_PROTOCOL_VFSFILE.equals(string) || URL_PROTOCOL_VFS.equals(string);
    }

    public static boolean isJarURL(URL uRL) {
        String string = uRL.getProtocol();
        return URL_PROTOCOL_JAR.equals(string) || URL_PROTOCOL_WAR.equals(string) || URL_PROTOCOL_ZIP.equals(string) || URL_PROTOCOL_VFSZIP.equals(string) || URL_PROTOCOL_WSJAR.equals(string);
    }

    public static boolean isJarFileURL(URL uRL) {
        return URL_PROTOCOL_FILE.equals(uRL.getProtocol()) && uRL.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
    }

    public static URL extractJarFileURL(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        int n = string.indexOf(JAR_URL_SEPARATOR);
        if (n != -1) {
            String string2 = string.substring(0, n);
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                return new URL(FILE_URL_PREFIX + string2);
            }
        }
        return uRL;
    }

    public static URL extractArchiveURL(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        int n = string.indexOf(WAR_URL_SEPARATOR);
        if (n != -1) {
            String string2 = string.substring(0, n);
            if (URL_PROTOCOL_WAR.equals(uRL.getProtocol())) {
                return new URL(string2);
            }
            int n2 = string2.indexOf(WAR_URL_PREFIX);
            if (n2 != -1) {
                return new URL(string2.substring(n2 + WAR_URL_PREFIX.length()));
            }
        }
        return ResourceUtils.extractJarFileURL(uRL);
    }

    public static URI toURI(URL uRL) throws URISyntaxException {
        return ResourceUtils.toURI(uRL.toString());
    }

    public static URI toURI(String string) throws URISyntaxException {
        return new URI(StringUtils.replace(string, " ", "%20"));
    }

    public static void useCachesIfNecessary(URLConnection uRLConnection) {
        uRLConnection.setUseCaches(uRLConnection.getClass().getSimpleName().startsWith("JNLP"));
    }
}

