/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean isCheckedException(Throwable throwable) {
        return !(throwable instanceof RuntimeException) && !(throwable instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable throwable, Class<?> ... classArray) {
        if (!ObjectUtils.isCheckedException(throwable)) {
            return true;
        }
        if (classArray != null) {
            for (Class<?> clazz : classArray) {
                if (!clazz.isInstance(throwable)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(@Nullable Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(@Nullable Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Optional) {
            return !((Optional)object).isPresent();
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }

    @Nullable
    public static Object unwrapOptional(@Nullable Object object) {
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            if (!optional.isPresent()) {
                return null;
            }
            Object t2 = optional.get();
            Assert.isTrue(!(t2 instanceof Optional), "Multi-level Optional usage not supported");
            return t2;
        }
        return object;
    }

    public static boolean containsElement(@Nullable Object[] objectArray, Object object) {
        if (objectArray == null) {
            return false;
        }
        for (Object object2 : objectArray) {
            if (!ObjectUtils.nullSafeEquals(object2, object)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumArray, String string) {
        return ObjectUtils.containsConstant(enumArray, string, false);
    }

    public static boolean containsConstant(Enum<?>[] enumArray, String string, boolean bl) {
        for (Enum<?> enum_ : enumArray) {
            if (!(bl ? enum_.toString().equals(string) : enum_.toString().equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] EArray, String string) {
        for (E e : EArray) {
            if (!((Enum)e).toString().equalsIgnoreCase(string)) continue;
            return e;
        }
        throw new IllegalArgumentException("Constant [" + string + "] does not exist in enum type " + EArray.getClass().getComponentType().getName());
    }

    public static <A, O extends A> A[] addObjectToArray(@Nullable A[] AArray, @Nullable O o) {
        Class clazz = Object.class;
        if (AArray != null) {
            clazz = AArray.getClass().getComponentType();
        } else if (o != null) {
            clazz = o.getClass();
        }
        int n = AArray != null ? AArray.length + 1 : 1;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        if (AArray != null) {
            System.arraycopy(AArray, 0, objectArray, 0, AArray.length);
        }
        objectArray[objectArray.length - 1] = o;
        return objectArray;
    }

    public static Object[] toObjectArray(@Nullable Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + object);
        }
        int n = Array.getLength(object);
        if (n == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> clazz = Array.get(object, 0).getClass();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public static boolean nullSafeEquals(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return ObjectUtils.arrayEquals(object, object2);
        }
        return false;
    }

    private static boolean arrayEquals(Object object, Object object2) {
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return false;
    }

    public static int nullSafeHashCode(@Nullable Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])object);
            }
            if (object instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])object);
            }
            if (object instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])object);
            }
            if (object instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])object);
            }
            if (object instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])object);
            }
            if (object instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])object);
            }
            if (object instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])object);
            }
            if (object instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])object);
            }
            if (object instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])object);
            }
        }
        return object.hashCode();
    }

    public static int nullSafeHashCode(@Nullable Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 7;
        for (Object object : objectArray) {
            n = 31 * n + ObjectUtils.nullSafeHashCode(object);
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 7;
        for (boolean bl : blArray) {
            n = 31 * n + Boolean.hashCode(bl);
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 7;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 7;
        for (char c : cArray) {
            n = 31 * n + c;
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 7;
        for (double d : dArray) {
            n = 31 * n + Double.hashCode(d);
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 7;
        for (float f : fArray) {
            n = 31 * n + Float.hashCode(f);
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 7;
        for (int n2 : nArray) {
            n = 31 * n + n2;
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 7;
        for (long l : lArray) {
            n = 31 * n + Long.hashCode(l);
        }
        return n;
    }

    public static int nullSafeHashCode(@Nullable short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 7;
        for (short s2 : sArray) {
            n = 31 * n + s2;
        }
        return n;
    }

    @Deprecated
    public static int hashCode(boolean bl) {
        return Boolean.hashCode(bl);
    }

    @Deprecated
    public static int hashCode(double d) {
        return Double.hashCode(d);
    }

    @Deprecated
    public static int hashCode(float f) {
        return Float.hashCode(f);
    }

    @Deprecated
    public static int hashCode(long l) {
        return Long.hashCode(l);
    }

    public static String identityToString(@Nullable Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        return object.getClass().getName() + "@" + ObjectUtils.getIdentityHexString(object);
    }

    public static String getIdentityHexString(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static String getDisplayString(@Nullable Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        return ObjectUtils.nullSafeToString(object);
    }

    public static String nullSafeClassName(@Nullable Object object) {
        return object != null ? object.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(@Nullable Object object) {
        if (object == null) {
            return NULL_STRING;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])object);
        }
        if (object instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])object);
        }
        if (object instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])object);
        }
        if (object instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])object);
        }
        if (object instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])object);
        }
        if (object instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])object);
        }
        if (object instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])object);
        }
        if (object instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])object);
        }
        String string = object.toString();
        return string != null ? string : EMPTY_STRING;
    }

    public static String nullSafeToString(@Nullable Object[] objectArray) {
        if (objectArray == null) {
            return NULL_STRING;
        }
        int n = objectArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (Object object : objectArray) {
            stringJoiner.add(String.valueOf(object));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable boolean[] blArray) {
        if (blArray == null) {
            return NULL_STRING;
        }
        int n = blArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (boolean bl : blArray) {
            stringJoiner.add(String.valueOf(bl));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable byte[] byArray) {
        if (byArray == null) {
            return NULL_STRING;
        }
        int n = byArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (byte by : byArray) {
            stringJoiner.add(String.valueOf(by));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable char[] cArray) {
        if (cArray == null) {
            return NULL_STRING;
        }
        int n = cArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (char c : cArray) {
            stringJoiner.add('\'' + String.valueOf(c) + '\'');
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable double[] dArray) {
        if (dArray == null) {
            return NULL_STRING;
        }
        int n = dArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (double d : dArray) {
            stringJoiner.add(String.valueOf(d));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable float[] fArray) {
        if (fArray == null) {
            return NULL_STRING;
        }
        int n = fArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (float f : fArray) {
            stringJoiner.add(String.valueOf(f));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable int[] nArray) {
        if (nArray == null) {
            return NULL_STRING;
        }
        int n = nArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (int n2 : nArray) {
            stringJoiner.add(String.valueOf(n2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable long[] lArray) {
        if (lArray == null) {
            return NULL_STRING;
        }
        int n = lArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (long l : lArray) {
            stringJoiner.add(String.valueOf(l));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(@Nullable short[] sArray) {
        if (sArray == null) {
            return NULL_STRING;
        }
        int n = sArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringJoiner stringJoiner = new StringJoiner(ARRAY_ELEMENT_SEPARATOR, ARRAY_START, ARRAY_END);
        for (short s2 : sArray) {
            stringJoiner.add(String.valueOf(s2));
        }
        return stringJoiner.toString();
    }
}

