/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public abstract class MimeTypeUtils {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    public static final Comparator<MimeType> SPECIFICITY_COMPARATOR = new MimeType.SpecificityComparator<MimeType>();
    public static final MimeType ALL;
    public static final String ALL_VALUE = "*/*";
    public static final MimeType APPLICATION_JSON;
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final MimeType APPLICATION_OCTET_STREAM;
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final MimeType APPLICATION_XML;
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final MimeType IMAGE_GIF;
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final MimeType IMAGE_JPEG;
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final MimeType IMAGE_PNG;
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final MimeType TEXT_HTML;
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final MimeType TEXT_PLAIN;
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final MimeType TEXT_XML;
    public static final String TEXT_XML_VALUE = "text/xml";
    private static final ConcurrentLruCache<String, MimeType> cachedMimeTypes;
    @Nullable
    private static volatile Random random;

    public static MimeType parseMimeType(String string) {
        if (!StringUtils.hasLength(string)) {
            throw new InvalidMimeTypeException(string, "'mimeType' must not be empty");
        }
        if (string.startsWith("multipart")) {
            return MimeTypeUtils.parseMimeTypeInternal(string);
        }
        return cachedMimeTypes.get(string);
    }

    private static MimeType parseMimeTypeInternal(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(59);
        String string2 = (n3 >= 0 ? string.substring(0, n3) : string).trim();
        if (string2.isEmpty()) {
            throw new InvalidMimeTypeException(string, "'mimeType' must not be empty");
        }
        if ("*".equals(string2)) {
            string2 = ALL_VALUE;
        }
        if ((n2 = string2.indexOf(47)) == -1) {
            throw new InvalidMimeTypeException(string, "does not contain '/'");
        }
        if (n2 == string2.length() - 1) {
            throw new InvalidMimeTypeException(string, "does not contain subtype after '/'");
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        if ("*".equals(string3) && !"*".equals(string4)) {
            throw new InvalidMimeTypeException(string, "wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> linkedHashMap = null;
        do {
            int n4;
            String string5;
            boolean bl = false;
            for (n = n3 + 1; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == ';') {
                    if (bl) continue;
                    break;
                }
                if (c != '\"') continue;
                bl = !bl;
            }
            if ((string5 = string.substring(n3 + 1, n).trim()).length() <= 0) continue;
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<String, String>(4);
            }
            if ((n4 = string5.indexOf(61)) < 0) continue;
            String string6 = string5.substring(0, n4).trim();
            String string7 = string5.substring(n4 + 1).trim();
            linkedHashMap.put(string6, string7);
        } while ((n3 = n) < string.length());
        try {
            return new MimeType(string3, string4, linkedHashMap);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new InvalidMimeTypeException(string, "unsupported charset '" + unsupportedCharsetException.getCharsetName() + "'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidMimeTypeException(string, illegalArgumentException.getMessage());
        }
    }

    public static List<MimeType> parseMimeTypes(String string) {
        if (!StringUtils.hasLength(string)) {
            return Collections.emptyList();
        }
        return MimeTypeUtils.tokenize(string).stream().filter(StringUtils::hasText).map(MimeTypeUtils::parseMimeType).collect(Collectors.toList());
    }

    public static List<String> tokenize(String string) {
        if (!StringUtils.hasLength(string)) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    bl = !bl;
                    continue block5;
                }
                case ',': {
                    if (bl) continue block5;
                    arrayList.add(string.substring(n, i));
                    n = i + 1;
                    continue block5;
                }
                case '\\': {
                    ++i;
                }
            }
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    public static String toString(Collection<? extends MimeType> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends MimeType> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            MimeType mimeType = iterator2.next();
            mimeType.appendTo(stringBuilder);
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static void sortBySpecificity(List<MimeType> list) {
        Assert.notNull(list, "'mimeTypes' must not be null");
        if (list.size() > 1) {
            list.sort(SPECIFICITY_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Random initRandom() {
        Random random = MimeTypeUtils.random;
        if (random != null) return random;
        Class<MimeTypeUtils> clazz = MimeTypeUtils.class;
        synchronized (MimeTypeUtils.class) {
            random = MimeTypeUtils.random;
            if (random != null) return random;
            MimeTypeUtils.random = random = new SecureRandom();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return random;
        }
    }

    public static byte[] generateMultipartBoundary() {
        Random random = MimeTypeUtils.initRandom();
        byte[] byArray = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = BOUNDARY_CHARS[random.nextInt(BOUNDARY_CHARS.length)];
        }
        return byArray;
    }

    public static String generateMultipartBoundaryString() {
        return new String(MimeTypeUtils.generateMultipartBoundary(), StandardCharsets.US_ASCII);
    }

    static {
        cachedMimeTypes = new ConcurrentLruCache<String, MimeType>(64, MimeTypeUtils::parseMimeTypeInternal);
        ALL = new MimeType("*", "*");
        APPLICATION_JSON = new MimeType("application", "json");
        APPLICATION_OCTET_STREAM = new MimeType("application", "octet-stream");
        APPLICATION_XML = new MimeType("application", "xml");
        IMAGE_GIF = new MimeType("image", "gif");
        IMAGE_JPEG = new MimeType("image", "jpeg");
        IMAGE_PNG = new MimeType("image", "png");
        TEXT_HTML = new MimeType("text", "html");
        TEXT_PLAIN = new MimeType("text", "plain");
        TEXT_XML = new MimeType("text", "xml");
    }

    private static class ConcurrentLruCache<K, V> {
        private final int maxSize;
        private final ConcurrentLinkedDeque<K> queue = new ConcurrentLinkedDeque();
        private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
        private final ReadWriteLock lock;
        private final Function<K, V> generator;
        private volatile int size;

        public ConcurrentLruCache(int n, Function<K, V> function) {
            Assert.isTrue(n > 0, "LRU max size should be positive");
            Assert.notNull(function, "Generator function should not be null");
            this.maxSize = n;
            this.generator = function;
            this.lock = new ReentrantReadWriteLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K k) {
            V v = this.cache.get(k);
            if (v != null) {
                if (this.size < this.maxSize) {
                    return v;
                }
                this.lock.readLock().lock();
                try {
                    if (this.queue.removeLastOccurrence(k)) {
                        this.queue.offer(k);
                    }
                    V v2 = v;
                    return v2;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            this.lock.writeLock().lock();
            try {
                Object object;
                v = this.cache.get(k);
                if (v != null) {
                    if (this.queue.removeLastOccurrence(k)) {
                        this.queue.offer(k);
                    }
                    V v3 = v;
                    return v3;
                }
                V v4 = this.generator.apply(k);
                int n = this.size;
                if (n == this.maxSize && (object = this.queue.poll()) != null) {
                    this.cache.remove(object);
                    --n;
                }
                this.queue.offer(k);
                this.cache.put(k, v4);
                this.size = n + 1;
                object = v4;
                return (V)object;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

