/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final ReferenceType DEFAULT_REFERENCE_TYPE = ReferenceType.SOFT;
    private static final int MAXIMUM_CONCURRENCY_LEVEL = 65536;
    private static final int MAXIMUM_SEGMENT_SIZE = 0x40000000;
    private final Segment[] segments;
    private final float loadFactor;
    private final ReferenceType referenceType;
    private final int shift;
    @Nullable
    private volatile Set<Map.Entry<K, V>> entrySet;

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n) {
        this(n, 0.75f, 16, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n, float f) {
        this(n, f, 16, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n, int n2) {
        this(n, 0.75f, n2, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n, ReferenceType referenceType) {
        this(n, 0.75f, 16, referenceType);
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2) {
        this(n, f, n2, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2, ReferenceType referenceType) {
        Assert.isTrue(n >= 0, "Initial capacity must not be negative");
        Assert.isTrue(f > 0.0f, "Load factor must be positive");
        Assert.isTrue(n2 > 0, "Concurrency level must be positive");
        Assert.notNull((Object)referenceType, "Reference type must not be null");
        this.loadFactor = f;
        this.shift = ConcurrentReferenceHashMap.calculateShift(n2, 65536);
        int n3 = 1 << this.shift;
        this.referenceType = referenceType;
        int n4 = (int)(((long)(n + n3) - 1L) / (long)n3);
        int n5 = 1 << ConcurrentReferenceHashMap.calculateShift(n4, 0x40000000);
        Segment[] segmentArray = (Segment[])Array.newInstance(Segment.class, n3);
        int n6 = (int)((float)n5 * this.getLoadFactor());
        for (int i = 0; i < segmentArray.length; ++i) {
            segmentArray[i] = new Segment(n5, n6);
        }
        this.segments = segmentArray;
    }

    protected final float getLoadFactor() {
        return this.loadFactor;
    }

    protected final int getSegmentsSize() {
        return this.segments.length;
    }

    protected final Segment getSegment(int n) {
        return this.segments[n];
    }

    protected ReferenceManager createReferenceManager() {
        return new ReferenceManager();
    }

    protected int getHash(@Nullable Object object) {
        int n = object != null ? object.hashCode() : 0;
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        n ^= n >>> 16;
        return n;
    }

    @Override
    @Nullable
    public V get(@Nullable Object object) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    @Nullable
    public V getOrDefault(@Nullable Object object, @Nullable V v) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null ? entry.getValue() : v;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null && ObjectUtils.nullSafeEquals(entry.getKey(), object);
    }

    @Nullable
    protected final Reference<K, V> getReference(@Nullable Object object, Restructure restructure) {
        int n = this.getHash(object);
        return this.getSegmentForHash(n).getReference(object, n, restructure);
    }

    @Override
    @Nullable
    public V put(@Nullable K k, @Nullable V v) {
        return this.put(k, v, true);
    }

    @Override
    @Nullable
    public V putIfAbsent(@Nullable K k, @Nullable V v) {
        return this.put(k, v, false);
    }

    @Nullable
    private V put(@Nullable K k, final @Nullable V v, final boolean bl) {
        return (V)this.doTask(k, new Task<V>(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.RESIZE}){

            @Override
            @Nullable
            protected V execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry, @Nullable Entries<V> entries) {
                if (entry != null) {
                    Object v2 = entry.getValue();
                    if (bl) {
                        entry.setValue(v);
                    }
                    return v2;
                }
                Assert.state(entries != null, "No entries segment");
                entries.add(v);
                return null;
            }
        });
    }

    @Override
    @Nullable
    public V remove(@Nullable Object object) {
        return (V)this.doTask(object, new Task<V>(new TaskOption[]{TaskOption.RESTRUCTURE_AFTER, TaskOption.SKIP_IF_EMPTY}){

            @Override
            @Nullable
            protected V execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry) {
                if (entry != null) {
                    if (reference != null) {
                        reference.release();
                    }
                    return entry.value;
                }
                return null;
            }
        });
    }

    @Override
    public boolean remove(@Nullable Object object, final @Nullable Object object2) {
        Boolean bl = this.doTask(object, new Task<Boolean>(new TaskOption[]{TaskOption.RESTRUCTURE_AFTER, TaskOption.SKIP_IF_EMPTY}){

            @Override
            protected Boolean execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry) {
                if (entry != null && ObjectUtils.nullSafeEquals(entry.getValue(), object2)) {
                    if (reference != null) {
                        reference.release();
                    }
                    return true;
                }
                return false;
            }
        });
        return Boolean.TRUE.equals(bl);
    }

    @Override
    public boolean replace(@Nullable K k, final @Nullable V v, final @Nullable V v2) {
        Boolean bl = this.doTask(k, new Task<Boolean>(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.SKIP_IF_EMPTY}){

            @Override
            protected Boolean execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry) {
                if (entry != null && ObjectUtils.nullSafeEquals(entry.getValue(), v)) {
                    entry.setValue(v2);
                    return true;
                }
                return false;
            }
        });
        return Boolean.TRUE.equals(bl);
    }

    @Override
    @Nullable
    public V replace(@Nullable K k, final @Nullable V v) {
        return (V)this.doTask(k, new Task<V>(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.SKIP_IF_EMPTY}){

            @Override
            @Nullable
            protected V execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry) {
                if (entry != null) {
                    Object v2 = entry.getValue();
                    entry.setValue(v);
                    return v2;
                }
                return null;
            }
        });
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    public void purgeUnreferencedEntries() {
        for (Segment segment : this.segments) {
            segment.restructureIfNecessary(false);
        }
    }

    @Override
    public int size() {
        int n = 0;
        for (Segment segment : this.segments) {
            n += segment.getCount();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        for (Segment segment : this.segments) {
            if (segment.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Nullable
    private <T> T doTask(@Nullable Object object, Task<T> task) {
        int n = this.getHash(object);
        return this.getSegmentForHash(n).doTask(n, object, task);
    }

    private Segment getSegmentForHash(int n) {
        return this.segments[n >>> 32 - this.shift & this.segments.length - 1];
    }

    protected static int calculateShift(int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        while (n4 < n && n4 < n2) {
            n4 <<= 1;
            ++n3;
        }
        return n3;
    }

    private static final class WeakEntryReference<K, V>
    extends WeakReference<Entry<K, V>>
    implements Reference<K, V> {
        private final int hash;
        @Nullable
        private final Reference<K, V> nextReference;

        public WeakEntryReference(Entry<K, V> entry, int n, @Nullable Reference<K, V> reference, ReferenceQueue<Entry<K, V>> referenceQueue) {
            super(entry, referenceQueue);
            this.hash = n;
            this.nextReference = reference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        @Nullable
        public Reference<K, V> getNext() {
            return this.nextReference;
        }

        @Override
        public void release() {
            this.enqueue();
            this.clear();
        }
    }

    private static final class SoftEntryReference<K, V>
    extends SoftReference<Entry<K, V>>
    implements Reference<K, V> {
        private final int hash;
        @Nullable
        private final Reference<K, V> nextReference;

        public SoftEntryReference(Entry<K, V> entry, int n, @Nullable Reference<K, V> reference, ReferenceQueue<Entry<K, V>> referenceQueue) {
            super(entry, referenceQueue);
            this.hash = n;
            this.nextReference = reference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        @Nullable
        public Reference<K, V> getNext() {
            return this.nextReference;
        }

        @Override
        public void release() {
            this.enqueue();
            this.clear();
        }
    }

    protected class ReferenceManager {
        private final ReferenceQueue<Entry<K, V>> queue = new ReferenceQueue();

        protected ReferenceManager() {
        }

        public Reference<K, V> createReference(Entry<K, V> entry, int n, @Nullable Reference<K, V> reference) {
            if (ConcurrentReferenceHashMap.this.referenceType == ReferenceType.WEAK) {
                return new WeakEntryReference(entry, n, reference, this.queue);
            }
            return new SoftEntryReference(entry, n, reference, this.queue);
        }

        @Nullable
        public Reference<K, V> pollForPurge() {
            return (Reference)((Object)this.queue.poll());
        }
    }

    protected static enum Restructure {
        WHEN_NECESSARY,
        NEVER;

    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int segmentIndex;
        private int referenceIndex;
        @Nullable
        private Reference<K, V>[] references;
        @Nullable
        private Reference<K, V> reference;
        @Nullable
        private Entry<K, V> next;
        @Nullable
        private Entry<K, V> last;

        public EntryIterator() {
            this.moveToNextSegment();
        }

        @Override
        public boolean hasNext() {
            this.getNextIfNecessary();
            return this.next != null;
        }

        @Override
        public Entry<K, V> next() {
            this.getNextIfNecessary();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = null;
            return this.last;
        }

        private void getNextIfNecessary() {
            while (this.next == null) {
                this.moveToNextReference();
                if (this.reference == null) {
                    return;
                }
                this.next = this.reference.get();
            }
        }

        private void moveToNextReference() {
            if (this.reference != null) {
                this.reference = this.reference.getNext();
            }
            while (this.reference == null && this.references != null) {
                if (this.referenceIndex >= this.references.length) {
                    this.moveToNextSegment();
                    this.referenceIndex = 0;
                    continue;
                }
                this.reference = this.references[this.referenceIndex];
                ++this.referenceIndex;
            }
        }

        private void moveToNextSegment() {
            this.reference = null;
            this.references = null;
            if (this.segmentIndex < ConcurrentReferenceHashMap.this.segments.length) {
                this.references = ConcurrentReferenceHashMap.this.segments[this.segmentIndex].references;
                ++this.segmentIndex;
            }
        }

        @Override
        public void remove() {
            Assert.state(this.last != null, "No element to remove");
            ConcurrentReferenceHashMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Entry entry;
                Map.Entry entry2 = (Map.Entry)object;
                Reference reference = ConcurrentReferenceHashMap.this.getReference(entry2.getKey(), Restructure.NEVER);
                Entry entry3 = entry = reference != null ? reference.get() : null;
                if (entry != null) {
                    return ObjectUtils.nullSafeEquals(entry2.getValue(), entry.getValue());
                }
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return ConcurrentReferenceHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    private static interface Entries<V> {
        public void add(@Nullable V var1);
    }

    private static enum TaskOption {
        RESTRUCTURE_BEFORE,
        RESTRUCTURE_AFTER,
        SKIP_IF_EMPTY,
        RESIZE;

    }

    private abstract class Task<T> {
        private final EnumSet<TaskOption> options;

        public Task(TaskOption ... taskOptionArray) {
            this.options = taskOptionArray.length == 0 ? EnumSet.noneOf(TaskOption.class) : EnumSet.of(taskOptionArray[0], taskOptionArray);
        }

        public boolean hasOption(TaskOption taskOption) {
            return this.options.contains((Object)taskOption);
        }

        @Nullable
        protected T execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry, @Nullable Entries<V> entries) {
            return this.execute(reference, entry);
        }

        @Nullable
        protected T execute(@Nullable Reference<K, V> reference, @Nullable Entry<K, V> entry) {
            return null;
        }
    }

    protected static final class Entry<K, V>
    implements Map.Entry<K, V> {
        @Nullable
        private final K key;
        @Nullable
        private volatile V value;

        public Entry(@Nullable K k, @Nullable V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        @Nullable
        public K getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public V setValue(@Nullable V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ObjectUtils.nullSafeEquals(this.getKey(), entry.getKey()) && ObjectUtils.nullSafeEquals(this.getValue(), entry.getValue());
        }

        @Override
        public final int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.key) ^ ObjectUtils.nullSafeHashCode(this.value);
        }
    }

    protected static interface Reference<K, V> {
        @Nullable
        public Entry<K, V> get();

        public int getHash();

        @Nullable
        public Reference<K, V> getNext();

        public void release();
    }

    protected final class Segment
    extends ReentrantLock {
        private final ReferenceManager referenceManager;
        private final int initialSize;
        private volatile Reference<K, V>[] references;
        private final AtomicInteger count = new AtomicInteger();
        private int resizeThreshold;

        public Segment(int n, int n2) {
            this.referenceManager = ConcurrentReferenceHashMap.this.createReferenceManager();
            this.initialSize = n;
            this.references = this.createReferenceArray(n);
            this.resizeThreshold = n2;
        }

        @Nullable
        public Reference<K, V> getReference(@Nullable Object object, int n, Restructure restructure) {
            if (restructure == Restructure.WHEN_NECESSARY) {
                this.restructureIfNecessary(false);
            }
            if (this.count.get() == 0) {
                return null;
            }
            Reference<K, V>[] referenceArray = this.references;
            int n2 = this.getIndex(n, referenceArray);
            Reference reference = referenceArray[n2];
            return this.findInChain(reference, object, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public <T> T doTask(int n, @Nullable Object object, Task<T> task) {
            boolean bl = task.hasOption(TaskOption.RESIZE);
            if (task.hasOption(TaskOption.RESTRUCTURE_BEFORE)) {
                this.restructureIfNecessary(bl);
            }
            if (task.hasOption(TaskOption.SKIP_IF_EMPTY) && this.count.get() == 0) {
                return task.execute(null, null, null);
            }
            this.lock();
            try {
                int n2 = this.getIndex(n, this.references);
                Reference reference = this.references[n2];
                Reference reference2 = this.findInChain(reference, object, n);
                Entry entry = reference2 != null ? reference2.get() : null;
                Entries<Object> entries = object2 -> {
                    Entry<Object, Object> entry = new Entry<Object, Object>(object, object2);
                    Reference reference2 = this.referenceManager.createReference(entry, n, reference);
                    this.references[n2] = reference2;
                    this.count.incrementAndGet();
                };
                T t2 = task.execute(reference2, entry, entries);
                return t2;
            }
            finally {
                this.unlock();
                if (task.hasOption(TaskOption.RESTRUCTURE_AFTER)) {
                    this.restructureIfNecessary(bl);
                }
            }
        }

        public void clear() {
            if (this.count.get() == 0) {
                return;
            }
            this.lock();
            try {
                this.references = this.createReferenceArray(this.initialSize);
                this.resizeThreshold = (int)((float)this.references.length * ConcurrentReferenceHashMap.this.getLoadFactor());
                this.count.set(0);
            }
            finally {
                this.unlock();
            }
        }

        protected final void restructureIfNecessary(boolean bl) {
            int n = this.count.get();
            boolean bl2 = bl && n > 0 && n >= this.resizeThreshold;
            Reference reference = this.referenceManager.pollForPurge();
            if (reference != null || bl2) {
                this.restructure(bl, reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restructure(boolean bl, @Nullable Reference<K, V> reference) {
            this.lock();
            try {
                int n = this.count.get();
                Set set = Collections.emptySet();
                if (reference != null) {
                    set = new HashSet();
                    while (reference != null) {
                        set.add(reference);
                        reference = this.referenceManager.pollForPurge();
                    }
                }
                boolean bl2 = (n -= set.size()) > 0 && n >= this.resizeThreshold;
                boolean bl3 = false;
                int n2 = this.references.length;
                if (bl && bl2 && n2 < 0x40000000) {
                    n2 <<= 1;
                    bl3 = true;
                }
                Reference<K, V>[] referenceArray = bl3 ? this.createReferenceArray(n2) : this.references;
                for (int i = 0; i < this.references.length; ++i) {
                    reference = this.references[i];
                    if (!bl3) {
                        referenceArray[i] = null;
                    }
                    while (reference != null) {
                        Entry entry;
                        if (!set.contains(reference) && (entry = reference.get()) != null) {
                            int n3 = this.getIndex(reference.getHash(), referenceArray);
                            referenceArray[n3] = this.referenceManager.createReference(entry, reference.getHash(), referenceArray[n3]);
                        }
                        reference = reference.getNext();
                    }
                }
                if (bl3) {
                    this.references = referenceArray;
                    this.resizeThreshold = (int)((float)this.references.length * ConcurrentReferenceHashMap.this.getLoadFactor());
                }
                this.count.set(Math.max(n, 0));
            }
            finally {
                this.unlock();
            }
        }

        @Nullable
        private Reference<K, V> findInChain(Reference<K, V> reference, @Nullable Object object, int n) {
            for (Reference reference2 = reference; reference2 != null; reference2 = reference2.getNext()) {
                Object k;
                Entry entry;
                if (reference2.getHash() != n || (entry = reference2.get()) == null || !ObjectUtils.nullSafeEquals(k = entry.getKey(), object)) continue;
                return reference2;
            }
            return null;
        }

        private Reference<K, V>[] createReferenceArray(int n) {
            return new Reference[n];
        }

        private int getIndex(int n, Reference<K, V>[] referenceArray) {
            return n & referenceArray.length - 1;
        }

        public final int getSize() {
            return this.references.length;
        }

        public final int getCount() {
            return this.count.get();
        }
    }

    public static enum ReferenceType {
        SOFT,
        WEAK;

    }
}

