/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.sun;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;
import org.springframework.objenesis.instantiator.util.ClassDefinitionUtils;
import org.springframework.objenesis.instantiator.util.ClassUtils;

@Instantiator(value=Typology.STANDARD)
public class MagicInstantiator<T>
implements ObjectInstantiator<T> {
    private static final String MAGIC_ACCESSOR = MagicInstantiator.getMagicClass();
    private static final int INDEX_CLASS_THIS = 1;
    private static final int INDEX_CLASS_SUPERCLASS = 2;
    private static final int INDEX_UTF8_CONSTRUCTOR_NAME = 3;
    private static final int INDEX_UTF8_CONSTRUCTOR_DESC = 4;
    private static final int INDEX_UTF8_CODE_ATTRIBUTE = 5;
    private static final int INDEX_UTF8_INSTANTIATOR_CLASS = 7;
    private static final int INDEX_UTF8_SUPERCLASS = 8;
    private static final int INDEX_CLASS_INTERFACE = 9;
    private static final int INDEX_UTF8_INTERFACE = 10;
    private static final int INDEX_UTF8_NEWINSTANCE_NAME = 11;
    private static final int INDEX_UTF8_NEWINSTANCE_DESC = 12;
    private static final int INDEX_METHODREF_OBJECT_CONSTRUCTOR = 13;
    private static final int INDEX_CLASS_OBJECT = 14;
    private static final int INDEX_UTF8_OBJECT = 15;
    private static final int INDEX_NAMEANDTYPE_DEFAULT_CONSTRUCTOR = 16;
    private static final int INDEX_CLASS_TYPE = 17;
    private static final int INDEX_UTF8_TYPE = 18;
    private static final int CONSTANT_POOL_COUNT = 19;
    private static final byte[] CONSTRUCTOR_CODE = new byte[]{42, -73, 0, 13, -79};
    private static final int CONSTRUCTOR_CODE_ATTRIBUTE_LENGTH = 12 + CONSTRUCTOR_CODE.length;
    private static final byte[] NEWINSTANCE_CODE = new byte[]{-69, 0, 17, 89, -73, 0, 13, -80};
    private static final int NEWINSTANCE_CODE_ATTRIBUTE_LENGTH = 12 + NEWINSTANCE_CODE.length;
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "()V";
    private final ObjectInstantiator<T> instantiator;

    public MagicInstantiator(Class<T> clazz) {
        this.instantiator = this.newInstantiatorOf(clazz);
    }

    public ObjectInstantiator<T> getInstantiator() {
        return this.instantiator;
    }

    private ObjectInstantiator<T> newInstantiatorOf(Class<T> clazz) {
        String string = clazz.getSimpleName();
        String string2 = this.getClass().getName() + "$$$" + string;
        Class clazz2 = ClassUtils.getExistingClass(this.getClass().getClassLoader(), string2);
        if (clazz2 == null) {
            byte[] byArray = this.writeExtendingClass(clazz, string2);
            try {
                clazz2 = ClassDefinitionUtils.defineClass(string2, byArray, clazz, this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                throw new ObjenesisException(exception);
            }
        }
        return (ObjectInstantiator)ClassUtils.newInstance(clazz2);
    }

    private byte[] writeExtendingClass(Class<?> clazz, String string) {
        String string2 = ClassUtils.classNameToInternalClassName(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.write(ClassDefinitionUtils.MAGIC);
            dataOutputStream.write(ClassDefinitionUtils.VERSION);
            dataOutputStream.writeShort(19);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(7);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(8);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_NAME);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_DESC);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("Code");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("L" + string2 + ";");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(MAGIC_ACCESSOR);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(10);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(ObjectInstantiator.class.getName().replace('.', '/'));
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("newInstance");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("()Ljava/lang/Object;");
            dataOutputStream.writeByte(10);
            dataOutputStream.writeShort(14);
            dataOutputStream.writeShort(16);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(15);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("java/lang/Object");
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(18);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(ClassUtils.classNameToInternalClassName(clazz.getName()));
            dataOutputStream.writeShort(49);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(9);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(5);
            dataOutputStream.writeInt(CONSTRUCTOR_CODE_ATTRIBUTE_LENGTH);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(CONSTRUCTOR_CODE.length);
            dataOutputStream.write(CONSTRUCTOR_CODE);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(11);
            dataOutputStream.writeShort(12);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(5);
            dataOutputStream.writeInt(NEWINSTANCE_CODE_ATTRIBUTE_LENGTH);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(NEWINSTANCE_CODE.length);
            dataOutputStream.write(NEWINSTANCE_CODE);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw new ObjenesisException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public T newInstance() {
        return this.instantiator.newInstance();
    }

    private static String getMagicClass() {
        try {
            Class.forName("sun.reflect.MagicAccessorImpl", false, MagicInstantiator.class.getClassLoader());
            return "sun/reflect/MagicAccessorImpl";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "jdk/internal/reflect/MagicAccessorImpl";
        }
    }
}

