/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;
import org.springframework.objenesis.instantiator.util.ClassDefinitionUtils;
import org.springframework.objenesis.instantiator.util.ClassUtils;

@Instantiator(value=Typology.STANDARD)
public class ProxyingInstantiator<T>
implements ObjectInstantiator<T> {
    private static final int INDEX_CLASS_THIS = 1;
    private static final int INDEX_CLASS_SUPERCLASS = 2;
    private static final int INDEX_UTF8_CONSTRUCTOR_NAME = 3;
    private static final int INDEX_UTF8_CONSTRUCTOR_DESC = 4;
    private static final int INDEX_UTF8_CODE_ATTRIBUTE = 5;
    private static final int INDEX_UTF8_CLASS = 7;
    private static final int INDEX_UTF8_SUPERCLASS = 8;
    private static final int CONSTANT_POOL_COUNT = 9;
    private static final byte[] CODE = new byte[]{42, -79};
    private static final int CODE_ATTRIBUTE_LENGTH = 12 + CODE.length;
    private static final String PREFIX = "org.springframework.objenesis.subclasses.";
    private static final String SUFFIX = "$$$Objenesis";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "()V";
    private final Class<? extends T> newType;

    private static String nameForSubclass(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = string + SUFFIX;
        if (string.startsWith("java.")) {
            string2 = PREFIX + string2;
        }
        return string2;
    }

    public ProxyingInstantiator(Class<T> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string = ProxyingInstantiator.nameForSubclass(clazz);
        byte[] byArray = ProxyingInstantiator.writeExtendingClass(clazz, string);
        try {
            this.newType = ClassDefinitionUtils.defineClass(string, byArray, clazz, classLoader);
        }
        catch (Exception exception) {
            throw new ObjenesisException(exception);
        }
    }

    @Override
    public T newInstance() {
        return ClassUtils.newInstance(this.newType);
    }

    private static byte[] writeExtendingClass(Class<?> clazz, String string) {
        String string2 = ClassUtils.classNameToInternalClassName(clazz.getName());
        String string3 = ClassUtils.classNameToInternalClassName(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.write(ClassDefinitionUtils.MAGIC);
            dataOutputStream.write(ClassDefinitionUtils.VERSION);
            dataOutputStream.writeShort(9);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(7);
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(8);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_NAME);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(CONSTRUCTOR_DESC);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("Code");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("L" + string3 + ";");
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeShort(33);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(3);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(5);
            dataOutputStream.writeInt(CODE_ATTRIBUTE_LENGTH);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(CODE.length);
            dataOutputStream.write(CODE);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw new ObjenesisException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

