/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class AnnotationTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class<? extends Annotation> annotationType;
    private final boolean considerMetaAnnotations;

    public AnnotationTypeFilter(Class<? extends Annotation> clazz) {
        this(clazz, true, false);
    }

    public AnnotationTypeFilter(Class<? extends Annotation> clazz, boolean bl) {
        this(clazz, bl, false);
    }

    public AnnotationTypeFilter(Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        super(clazz.isAnnotationPresent(Inherited.class), bl2);
        this.annotationType = clazz;
        this.considerMetaAnnotations = bl;
    }

    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    protected boolean matchSelf(MetadataReader metadataReader) {
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        return annotationMetadata.hasAnnotation(this.annotationType.getName()) || this.considerMetaAnnotations && annotationMetadata.hasMetaAnnotation(this.annotationType.getName());
    }

    @Override
    @Nullable
    protected Boolean matchSuperClass(String string) {
        return this.hasAnnotation(string);
    }

    @Override
    @Nullable
    protected Boolean matchInterface(String string) {
        return this.hasAnnotation(string);
    }

    @Nullable
    protected Boolean hasAnnotation(String string) {
        if (Object.class.getName().equals(string)) {
            return false;
        }
        if (string.startsWith("java")) {
            if (!this.annotationType.getName().startsWith("java")) {
                return false;
            }
            try {
                Class<?> clazz = ClassUtils.forName(string, this.getClass().getClassLoader());
                return (this.considerMetaAnnotations ? AnnotationUtils.getAnnotation(clazz, this.annotationType) : clazz.getAnnotation(this.annotationType)) != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

