/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;

final class SimpleMethodMetadata
implements MethodMetadata {
    private final String methodName;
    private final int access;
    private final String declaringClassName;
    private final String returnTypeName;
    private final MergedAnnotations annotations;

    public SimpleMethodMetadata(String string, int n, String string2, String string3, MergedAnnotations mergedAnnotations) {
        this.methodName = string;
        this.access = n;
        this.declaringClassName = string2;
        this.returnTypeName = string3;
        this.annotations = mergedAnnotations;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    @Override
    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !this.isPrivate();
    }

    public boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }
}

