/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class MergedAnnotationReadingVisitor<A extends Annotation>
extends AnnotationVisitor {
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Object source;
    private final Class<A> annotationType;
    private final Consumer<MergedAnnotation<A>> consumer;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>(4);

    public MergedAnnotationReadingVisitor(@Nullable ClassLoader classLoader, @Nullable Object object, Class<A> clazz, Consumer<MergedAnnotation<A>> consumer) {
        super(0x1080000);
        this.classLoader = classLoader;
        this.source = object;
        this.annotationType = clazz;
        this.consumer = consumer;
    }

    @Override
    public void visit(String string, Object object) {
        if (object instanceof Type) {
            object = ((Type)object).getClassName();
        }
        this.attributes.put(string, object);
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.visitEnum(string2, string3, (E enum_) -> this.attributes.put(string, enum_));
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        return this.visitAnnotation(string2, (MergedAnnotation<T> mergedAnnotation) -> this.attributes.put(string, mergedAnnotation));
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        return new ArrayVisitor(objectArray -> this.attributes.put(string, objectArray));
    }

    @Override
    public void visitEnd() {
        MergedAnnotation<A> mergedAnnotation = MergedAnnotation.of(this.classLoader, this.source, this.annotationType, this.attributes);
        this.consumer.accept(mergedAnnotation);
    }

    public <E extends Enum<E>> void visitEnum(String string, String string2, Consumer<E> consumer) {
        String string3 = Type.getType(string).getClassName();
        Class<?> clazz = ClassUtils.resolveClassName(string3, this.classLoader);
        consumer.accept(Enum.valueOf(clazz, string2));
    }

    @Nullable
    private <T extends Annotation> AnnotationVisitor visitAnnotation(String string, Consumer<MergedAnnotation<T>> consumer) {
        String string2 = Type.getType(string).getClassName();
        if (AnnotationFilter.PLAIN.matches(string2)) {
            return null;
        }
        Class<?> clazz = ClassUtils.resolveClassName(string2, this.classLoader);
        return new MergedAnnotationReadingVisitor(this.classLoader, this.source, clazz, consumer);
    }

    @Nullable
    static <A extends Annotation> AnnotationVisitor get(@Nullable ClassLoader classLoader, @Nullable Supplier<Object> supplier, String string, boolean bl, Consumer<MergedAnnotation<A>> consumer) {
        if (!bl) {
            return null;
        }
        String string2 = Type.getType(string).getClassName();
        if (AnnotationFilter.PLAIN.matches(string2)) {
            return null;
        }
        Object object = supplier != null ? supplier.get() : null;
        try {
            Class<?> clazz = ClassUtils.forName(string2, classLoader);
            return new MergedAnnotationReadingVisitor(classLoader, object, clazz, consumer);
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            return null;
        }
    }

    private class ArrayVisitor
    extends AnnotationVisitor {
        private final List<Object> elements;
        private final Consumer<Object[]> consumer;

        ArrayVisitor(Consumer<Object[]> consumer) {
            super(0x1080000);
            this.elements = new ArrayList<Object>();
            this.consumer = consumer;
        }

        @Override
        public void visit(String string, Object object) {
            if (object instanceof Type) {
                object = ((Type)object).getClassName();
            }
            this.elements.add(object);
        }

        @Override
        public void visitEnum(String string, String string2, String string3) {
            MergedAnnotationReadingVisitor.this.visitEnum(string2, string3, this.elements::add);
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return MergedAnnotationReadingVisitor.this.visitAnnotation(string2, this.elements::add);
        }

        @Override
        public void visitEnd() {
            Class<?> clazz = this.getComponentType();
            Object[] objectArray = (Object[])Array.newInstance(clazz, this.elements.size());
            this.consumer.accept(this.elements.toArray(objectArray));
        }

        private Class<?> getComponentType() {
            if (this.elements.isEmpty()) {
                return Object.class;
            }
            Object object = this.elements.get(0);
            if (object instanceof Enum) {
                return ((Enum)object).getDeclaringClass();
            }
            return object.getClass();
        }
    }
}

