/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.reflect.Field;
import java.security.AccessControlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.classreading.RecursiveAnnotationArrayVisitor;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Deprecated
abstract class AbstractRecursiveAnnotationVisitor
extends AnnotationVisitor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AnnotationAttributes attributes;
    @Nullable
    protected final ClassLoader classLoader;

    public AbstractRecursiveAnnotationVisitor(@Nullable ClassLoader classLoader, AnnotationAttributes annotationAttributes) {
        super(0x1080000);
        this.classLoader = classLoader;
        this.attributes = annotationAttributes;
    }

    @Override
    public void visit(String string, Object object) {
        this.attributes.put(string, object);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        String string3 = Type.getType(string2).getClassName();
        AnnotationAttributes annotationAttributes = new AnnotationAttributes(string3, this.classLoader);
        this.attributes.put(string, annotationAttributes);
        return new RecursiveAnnotationAttributesVisitor(string3, annotationAttributes, this.classLoader);
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        return new RecursiveAnnotationArrayVisitor(string, this.attributes, this.classLoader);
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        Object object = this.getEnumValue(string2, string3);
        this.visit(string, object);
    }

    protected Object getEnumValue(String string, String string2) {
        Object object = string2;
        try {
            Class<?> clazz = ClassUtils.forName(Type.getType(string).getClassName(), this.classLoader);
            Field field = ReflectionUtils.findField(clazz, string2);
            if (field != null) {
                ReflectionUtils.makeAccessible(field);
                object = field.get(null);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            this.logger.debug("Failed to classload enum type while reading annotation metadata", throwable);
        }
        catch (IllegalAccessException | AccessControlException exception) {
            this.logger.debug("Could not access enum value while reading annotation metadata", exception);
        }
        return object;
    }
}

