/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.util.Map;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public interface AnnotatedTypeMetadata {
    public MergedAnnotations getAnnotations();

    default public boolean isAnnotated(String string) {
        return this.getAnnotations().isPresent(string);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String string) {
        return this.getAnnotationAttributes(string, false);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String string, boolean bl) {
        MergedAnnotation mergedAnnotation = this.getAnnotations().get(string, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        if (!mergedAnnotation.isPresent()) {
            return null;
        }
        return mergedAnnotation.asAnnotationAttributes(MergedAnnotation.Adapt.values(bl, true));
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String string) {
        return this.getAllAnnotationAttributes(string, false);
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String string, boolean bl) {
        MergedAnnotation.Adapt[] adaptArray = MergedAnnotation.Adapt.values(bl, true);
        return this.getAnnotations().stream(string).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toMultiValueMap(multiValueMap -> multiValueMap.isEmpty() ? null : multiValueMap, adaptArray));
    }
}

