/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public abstract class PropertiesLoaderSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    protected Properties[] localProperties;
    protected boolean localOverride = false;
    @Nullable
    private Resource[] locations;
    private boolean ignoreResourceNotFound = false;
    @Nullable
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public void setProperties(Properties properties) {
        this.localProperties = new Properties[]{properties};
    }

    public void setPropertiesArray(Properties ... propertiesArray) {
        this.localProperties = propertiesArray;
    }

    public void setLocation(Resource resource) {
        this.locations = new Resource[]{resource};
    }

    public void setLocations(Resource ... resourceArray) {
        this.locations = resourceArray;
    }

    public void setLocalOverride(boolean bl) {
        this.localOverride = bl;
    }

    public void setIgnoreResourceNotFound(boolean bl) {
        this.ignoreResourceNotFound = bl;
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
    }

    public void setPropertiesPersister(@Nullable PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = new Properties();
        if (this.localOverride) {
            this.loadProperties(properties);
        }
        if (this.localProperties != null) {
            for (Properties properties2 : this.localProperties) {
                CollectionUtils.mergePropertiesIntoMap(properties2, properties);
            }
        }
        if (!this.localOverride) {
            this.loadProperties(properties);
        }
        return properties;
    }

    protected void loadProperties(Properties properties) throws IOException {
        if (this.locations != null) {
            for (Resource resource : this.locations) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Loading properties file from " + resource);
                }
                try {
                    PropertiesLoaderUtils.fillProperties(properties, new EncodedResource(resource, this.fileEncoding), this.propertiesPersister);
                }
                catch (FileNotFoundException | SocketException | UnknownHostException iOException) {
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Properties resource not found: " + iOException.getMessage());
                        continue;
                    }
                    throw iOException;
                }
            }
        }
    }
}

