/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;

public class LimitedDataBufferList
extends ArrayList<DataBuffer> {
    private final int maxByteCount;
    private int byteCount;

    public LimitedDataBufferList(int n) {
        this.maxByteCount = n;
    }

    @Override
    public boolean add(DataBuffer dataBuffer) {
        this.updateCount(dataBuffer.readableByteCount());
        return super.add(dataBuffer);
    }

    @Override
    public void add(int n, DataBuffer dataBuffer) {
        super.add(n, dataBuffer);
        this.updateCount(dataBuffer.readableByteCount());
    }

    @Override
    public boolean addAll(Collection<? extends DataBuffer> collection) {
        boolean bl = super.addAll(collection);
        collection.forEach((? super T dataBuffer) -> this.updateCount(dataBuffer.readableByteCount()));
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends DataBuffer> collection) {
        boolean bl = super.addAll(n, collection);
        collection.forEach((? super T dataBuffer) -> this.updateCount(dataBuffer.readableByteCount()));
        return bl;
    }

    private void updateCount(int n) {
        if (this.maxByteCount < 0) {
            return;
        }
        if (n > Integer.MAX_VALUE - this.byteCount) {
            this.raiseLimitException();
        } else {
            this.byteCount += n;
            if (this.byteCount > this.maxByteCount) {
                this.raiseLimitException();
            }
        }
    }

    private void raiseLimitException() {
        throw new DataBufferLimitException("Exceeded limit on max bytes to buffer : " + this.maxByteCount);
    }

    @Override
    public DataBuffer remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeRange(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super DataBuffer> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataBuffer set(int n, DataBuffer dataBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.byteCount = 0;
        super.clear();
    }

    public void releaseAndClear() {
        this.forEach((? super E dataBuffer) -> {
            try {
                DataBufferUtils.release(dataBuffer);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.clear();
    }
}

