/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.springframework.core.io.AbstractResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ByteArrayResource
extends AbstractResource {
    private final byte[] byteArray;
    private final String description;

    public ByteArrayResource(byte[] byArray) {
        this(byArray, "resource loaded from byte array");
    }

    public ByteArrayResource(byte[] byArray, @Nullable String string) {
        Assert.notNull((Object)byArray, "Byte array must not be null");
        this.byteArray = byArray;
        this.description = string != null ? string : "";
    }

    public final byte[] getByteArray() {
        return this.byteArray;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long contentLength() {
        return this.byteArray.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    @Override
    public String getDescription() {
        return "Byte array resource [" + this.description + "]";
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)object).byteArray, this.byteArray);
    }

    @Override
    public int hashCode() {
        return byte[].class.hashCode() * 29 * this.byteArray.length;
    }
}

