/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.ResourceUtils;

public abstract class AbstractResource
implements Resource {
    @Override
    public boolean exists() {
        Log log;
        block6: {
            if (this.isFile()) {
                try {
                    return this.getFile().exists();
                }
                catch (IOException iOException) {
                    log = LogFactory.getLog(this.getClass());
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Could not retrieve File for existence check of " + this.getDescription(), iOException);
                }
            }
        }
        try {
            this.getInputStream().close();
            return true;
        }
        catch (Throwable throwable) {
            log = LogFactory.getLog(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug("Could not retrieve InputStream for existence check of " + this.getDescription(), throwable);
            }
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        return this.exists();
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL uRL = this.getURL();
        try {
            return ResourceUtils.toURI(uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new NestedIOException("Invalid URI [" + uRL + "]", uRISyntaxException);
        }
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream inputStream2 = this.getInputStream();
        try {
            int n;
            long l = 0L;
            byte[] byArray = new byte[256];
            while ((n = inputStream2.read(byArray)) != -1) {
                l += (long)n;
            }
            long l2 = l;
            return l2;
        }
        finally {
            block8: {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    Log log = LogFactory.getLog(this.getClass());
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Could not close content-length InputStream for " + this.getDescription(), iOException);
                }
            }
        }
    }

    @Override
    public long lastModified() throws IOException {
        File file = this.getFileForLastModifiedCheck();
        long l = file.lastModified();
        if (l == 0L && !file.exists()) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return l;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String string) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    @Nullable
    public String getFilename() {
        return null;
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof Resource && ((Resource)object).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    public String toString() {
        return this.getDescription();
    }
}

