/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractPropertyResolver
implements ConfigurablePropertyResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private volatile ConfigurableConversionService conversionService;
    @Nullable
    private PropertyPlaceholderHelper nonStrictHelper;
    @Nullable
    private PropertyPlaceholderHelper strictHelper;
    private boolean ignoreUnresolvableNestedPlaceholders = false;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    @Nullable
    private String valueSeparator = ":";
    private final Set<String> requiredProperties = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableConversionService getConversionService() {
        ConfigurableConversionService configurableConversionService = this.conversionService;
        if (configurableConversionService == null) {
            AbstractPropertyResolver abstractPropertyResolver = this;
            synchronized (abstractPropertyResolver) {
                configurableConversionService = this.conversionService;
                if (configurableConversionService == null) {
                    this.conversionService = configurableConversionService = new DefaultConversionService();
                }
            }
        }
        return configurableConversionService;
    }

    @Override
    public void setConversionService(ConfigurableConversionService configurableConversionService) {
        Assert.notNull((Object)configurableConversionService, "ConversionService must not be null");
        this.conversionService = configurableConversionService;
    }

    @Override
    public void setPlaceholderPrefix(String string) {
        Assert.notNull((Object)string, "'placeholderPrefix' must not be null");
        this.placeholderPrefix = string;
    }

    @Override
    public void setPlaceholderSuffix(String string) {
        Assert.notNull((Object)string, "'placeholderSuffix' must not be null");
        this.placeholderSuffix = string;
    }

    @Override
    public void setValueSeparator(@Nullable String string) {
        this.valueSeparator = string;
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean bl) {
        this.ignoreUnresolvableNestedPlaceholders = bl;
    }

    @Override
    public void setRequiredProperties(String ... stringArray) {
        Collections.addAll(this.requiredProperties, stringArray);
    }

    @Override
    public void validateRequiredProperties() {
        MissingRequiredPropertiesException missingRequiredPropertiesException = new MissingRequiredPropertiesException();
        for (String string : this.requiredProperties) {
            if (this.getProperty(string) != null) continue;
            missingRequiredPropertiesException.addMissingRequiredProperty(string);
        }
        if (!missingRequiredPropertiesException.getMissingRequiredProperties().isEmpty()) {
            throw missingRequiredPropertiesException;
        }
    }

    @Override
    public boolean containsProperty(String string) {
        return this.getProperty(string) != null;
    }

    @Override
    @Nullable
    public String getProperty(String string) {
        return this.getProperty(string, String.class);
    }

    @Override
    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 != null ? string3 : string2;
    }

    @Override
    public <T> T getProperty(String string, Class<T> clazz, T t2) {
        T t3 = this.getProperty(string, clazz);
        return t3 != null ? t3 : t2;
    }

    @Override
    public String getRequiredProperty(String string) throws IllegalStateException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new IllegalStateException("Required key '" + string + "' not found");
        }
        return string2;
    }

    @Override
    public <T> T getRequiredProperty(String string, Class<T> clazz) throws IllegalStateException {
        T t2 = this.getProperty(string, clazz);
        if (t2 == null) {
            throw new IllegalStateException("Required key '" + string + "' not found");
        }
        return t2;
    }

    @Override
    public String resolvePlaceholders(String string) {
        if (this.nonStrictHelper == null) {
            this.nonStrictHelper = this.createPlaceholderHelper(true);
        }
        return this.doResolvePlaceholders(string, this.nonStrictHelper);
    }

    @Override
    public String resolveRequiredPlaceholders(String string) throws IllegalArgumentException {
        if (this.strictHelper == null) {
            this.strictHelper = this.createPlaceholderHelper(false);
        }
        return this.doResolvePlaceholders(string, this.strictHelper);
    }

    protected String resolveNestedPlaceholders(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return this.ignoreUnresolvableNestedPlaceholders ? this.resolvePlaceholders(string) : this.resolveRequiredPlaceholders(string);
    }

    private PropertyPlaceholderHelper createPlaceholderHelper(boolean bl) {
        return new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, bl);
    }

    private String doResolvePlaceholders(String string, PropertyPlaceholderHelper propertyPlaceholderHelper) {
        return propertyPlaceholderHelper.replacePlaceholders(string, this::getPropertyAsRawString);
    }

    @Nullable
    protected <T> T convertValueIfNecessary(Object object, @Nullable Class<T> clazz) {
        if (clazz == null) {
            return (T)object;
        }
        ConversionService conversionService = this.conversionService;
        if (conversionService == null) {
            if (ClassUtils.isAssignableValue(clazz, object)) {
                return (T)object;
            }
            conversionService = DefaultConversionService.getSharedInstance();
        }
        return conversionService.convert(object, clazz);
    }

    @Nullable
    protected abstract String getPropertyAsRawString(String var1);
}

