/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class ObjectToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ObjectToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor, typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Collection<Object> collection = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, 1);
        if (typeDescriptor3 == null || typeDescriptor3.isCollection()) {
            collection.add(object);
        } else {
            Object object2 = this.conversionService.convert(object, typeDescriptor, typeDescriptor3);
            collection.add(object2);
        }
        return collection;
    }
}

