/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class CollectionToStringConverter
implements ConditionalGenericConverter {
    private static final String DELIMITER = ",";
    private final ConversionService conversionService;

    public CollectionToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2, this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(DELIMITER);
        for (Object e : collection) {
            Object object2 = this.conversionService.convert(e, typeDescriptor.elementTypeDescriptor(e), typeDescriptor2);
            stringJoiner.add(String.valueOf(object2));
        }
        return stringJoiner.toString();
    }
}

