/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public interface Decoder<T> {
    public boolean canDecode(ResolvableType var1, @Nullable MimeType var2);

    public Flux<T> decode(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    public Mono<T> decodeToMono(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    @Nullable
    default public T decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) throws DecodingException {
        MonoProcessor monoProcessor = MonoProcessor.create();
        this.decodeToMono((Publisher<DataBuffer>)Mono.just((Object)dataBuffer), resolvableType, mimeType, map).subscribeWith((Subscriber)monoProcessor);
        Assert.state(monoProcessor.isTerminated(), "DataBuffer decoding should have completed.");
        Throwable throwable = monoProcessor.getError();
        if (throwable != null) {
            throw throwable instanceof CodecException ? (CodecException)throwable : new DecodingException("Failed to decode: " + throwable.getMessage(), throwable);
        }
        return (T)monoProcessor.peek();
    }

    public List<MimeType> getDecodableMimeTypes();
}

