/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class DataBufferDecoder
extends AbstractDataBufferDecoder<DataBuffer> {
    public DataBufferDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return DataBuffer.class.isAssignableFrom(resolvableType.toClass()) && super.canDecode(resolvableType, mimeType);
    }

    @Override
    public Flux<DataBuffer> decode(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(publisher);
    }

    @Override
    public DataBuffer decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(map) + "Read " + dataBuffer.readableByteCount() + " bytes");
        }
        return dataBuffer;
    }
}

