/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public final class CharSequenceEncoder
extends AbstractEncoder<CharSequence> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ConcurrentMap<Charset, Float> charsetToMaxBytesPerChar = new ConcurrentHashMap<Charset, Float>(3);

    private CharSequenceEncoder(MimeType ... mimeTypeArray) {
        super(mimeTypeArray);
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        Class<?> clazz = resolvableType.toClass();
        return super.canEncode(resolvableType, mimeType) && CharSequence.class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends CharSequence> publisher, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(publisher).map(charSequence -> this.encodeValue((CharSequence)charSequence, dataBufferFactory, resolvableType, mimeType, map));
    }

    @Override
    public DataBuffer encodeValue(CharSequence charSequence, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        if (!Hints.isLoggingSuppressed(map)) {
            LogFormatUtils.traceDebug(this.logger, bl -> {
                String string = LogFormatUtils.formatValue(charSequence, bl == false);
                return Hints.getLogPrefix(map) + "Writing " + string;
            });
        }
        boolean bl2 = true;
        Charset charset = this.getCharset(mimeType);
        int n = this.calculateCapacity(charSequence, charset);
        DataBuffer dataBuffer = dataBufferFactory.allocateBuffer(n);
        try {
            dataBuffer.write(charSequence, charset);
            bl2 = false;
        }
        catch (CoderMalfunctionError coderMalfunctionError) {
            throw new EncodingException("String encoding error: " + coderMalfunctionError.getMessage(), coderMalfunctionError);
        }
        finally {
            if (bl2) {
                DataBufferUtils.release(dataBuffer);
            }
        }
        return dataBuffer;
    }

    int calculateCapacity(CharSequence charSequence, Charset charset2) {
        float f = this.charsetToMaxBytesPerChar.computeIfAbsent(charset2, charset -> Float.valueOf(charset.newEncoder().maxBytesPerChar())).floatValue();
        float f2 = (float)charSequence.length() * f;
        return (int)Math.ceil(f2);
    }

    private Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return DEFAULT_CHARSET;
    }

    public static CharSequenceEncoder textPlainOnly() {
        return new CharSequenceEncoder(new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    public static CharSequenceEncoder allMimeTypes() {
        return new CharSequenceEncoder(new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }
}

