/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class OrderUtils {
    private static final Object NOT_ANNOTATED = new Object();
    private static final String JAVAX_PRIORITY_ANNOTATION = "javax.annotation.Priority";
    private static final Map<AnnotatedElement, Object> orderCache = new ConcurrentReferenceHashMap<AnnotatedElement, Object>(64);

    public static int getOrder(Class<?> clazz, int n) {
        Integer n2 = OrderUtils.getOrder(clazz);
        return n2 != null ? n2 : n;
    }

    @Nullable
    public static Integer getOrder(Class<?> clazz, @Nullable Integer n) {
        Integer n2 = OrderUtils.getOrder(clazz);
        return n2 != null ? n2 : n;
    }

    @Nullable
    public static Integer getOrder(Class<?> clazz) {
        return OrderUtils.getOrderFromAnnotations(clazz, MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
    }

    @Nullable
    static Integer getOrderFromAnnotations(AnnotatedElement annotatedElement, MergedAnnotations mergedAnnotations) {
        if (!(annotatedElement instanceof Class)) {
            return OrderUtils.findOrder(mergedAnnotations);
        }
        Object object = orderCache.get(annotatedElement);
        if (object != null) {
            return object instanceof Integer ? (Integer)object : null;
        }
        Integer n = OrderUtils.findOrder(mergedAnnotations);
        orderCache.put(annotatedElement, n != null ? n : NOT_ANNOTATED);
        return n;
    }

    @Nullable
    private static Integer findOrder(MergedAnnotations mergedAnnotations) {
        MergedAnnotation<Order> mergedAnnotation = mergedAnnotations.get(Order.class);
        if (mergedAnnotation.isPresent()) {
            return mergedAnnotation.getInt("value");
        }
        MergedAnnotation mergedAnnotation2 = mergedAnnotations.get(JAVAX_PRIORITY_ANNOTATION);
        if (mergedAnnotation2.isPresent()) {
            return mergedAnnotation2.getInt("value");
        }
        return null;
    }

    @Nullable
    public static Integer getPriority(Class<?> clazz) {
        return MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JAVAX_PRIORITY_ANNOTATION).getValue("value", Integer.class).orElse(null);
    }
}

