/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationSelector;

public abstract class MergedAnnotationSelectors {
    private static final MergedAnnotationSelector<?> NEAREST = new Nearest();
    private static final MergedAnnotationSelector<?> FIRST_DIRECTLY_DECLARED = new FirstDirectlyDeclared();

    private MergedAnnotationSelectors() {
    }

    public static <A extends Annotation> MergedAnnotationSelector<A> nearest() {
        return NEAREST;
    }

    public static <A extends Annotation> MergedAnnotationSelector<A> firstDirectlyDeclared() {
        return FIRST_DIRECTLY_DECLARED;
    }

    private static class FirstDirectlyDeclared
    implements MergedAnnotationSelector<Annotation> {
        private FirstDirectlyDeclared() {
        }

        @Override
        public boolean isBestCandidate(MergedAnnotation<Annotation> mergedAnnotation) {
            return mergedAnnotation.getDistance() == 0;
        }

        @Override
        public MergedAnnotation<Annotation> select(MergedAnnotation<Annotation> mergedAnnotation, MergedAnnotation<Annotation> mergedAnnotation2) {
            if (mergedAnnotation.getDistance() > 0 && mergedAnnotation2.getDistance() == 0) {
                return mergedAnnotation2;
            }
            return mergedAnnotation;
        }
    }

    private static class Nearest
    implements MergedAnnotationSelector<Annotation> {
        private Nearest() {
        }

        @Override
        public boolean isBestCandidate(MergedAnnotation<Annotation> mergedAnnotation) {
            return mergedAnnotation.getDistance() == 0;
        }

        @Override
        public MergedAnnotation<Annotation> select(MergedAnnotation<Annotation> mergedAnnotation, MergedAnnotation<Annotation> mergedAnnotation2) {
            if (mergedAnnotation2.getDistance() < mergedAnnotation.getDistance()) {
                return mergedAnnotation2;
            }
            return mergedAnnotation;
        }
    }
}

