/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class MergedAnnotationCollectors {
    private static final Collector.Characteristics[] NO_CHARACTERISTICS = new Collector.Characteristics[0];
    private static final Collector.Characteristics[] IDENTITY_FINISH_CHARACTERISTICS = new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH};

    private MergedAnnotationCollectors() {
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, Set<A>> toAnnotationSet() {
        return Collector.of(LinkedHashSet::new, (set, mergedAnnotation) -> set.add(mergedAnnotation.synthesize()), MergedAnnotationCollectors::combiner, new Collector.Characteristics[0]);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, Annotation[]> toAnnotationArray() {
        return MergedAnnotationCollectors.toAnnotationArray(Annotation[]::new);
    }

    public static <R extends Annotation, A extends R> Collector<MergedAnnotation<A>, ?, R[]> toAnnotationArray(IntFunction<R[]> intFunction) {
        return Collector.of(ArrayList::new, (arrayList, mergedAnnotation) -> arrayList.add(mergedAnnotation.synthesize()), MergedAnnotationCollectors::combiner, arrayList -> (Annotation[])arrayList.toArray((Object[])intFunction.apply(arrayList.size())), new Collector.Characteristics[0]);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, MultiValueMap<String, Object>> toMultiValueMap(MergedAnnotation.Adapt ... adaptArray) {
        return MergedAnnotationCollectors.toMultiValueMap(Function.identity(), adaptArray);
    }

    public static <A extends Annotation> Collector<MergedAnnotation<A>, ?, MultiValueMap<String, Object>> toMultiValueMap(Function<MultiValueMap<String, Object>, MultiValueMap<String, Object>> function, MergedAnnotation.Adapt ... adaptArray) {
        Collector.Characteristics[] characteristicsArray = MergedAnnotationCollectors.isSameInstance(function, Function.identity()) ? IDENTITY_FINISH_CHARACTERISTICS : NO_CHARACTERISTICS;
        return Collector.of(LinkedMultiValueMap::new, (multiValueMap, mergedAnnotation) -> mergedAnnotation.asMap(adaptArray).forEach(multiValueMap::add), MergedAnnotationCollectors::combiner, function, characteristicsArray);
    }

    private static boolean isSameInstance(Object object, Object object2) {
        return object == object2;
    }

    private static <E, C extends Collection<E>> C combiner(C c, C c2) {
        c.addAll(c2);
        return c;
    }

    private static <K, V> MultiValueMap<K, V> combiner(MultiValueMap<K, V> multiValueMap, MultiValueMap<K, V> multiValueMap2) {
        multiValueMap.addAll(multiValueMap2);
        return multiValueMap;
    }
}

