/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MissingMergedAnnotation;
import org.springframework.core.annotation.TypeMappedAnnotation;
import org.springframework.lang.Nullable;

public interface MergedAnnotation<A extends Annotation> {
    public static final String VALUE = "value";

    public Class<A> getType();

    public boolean isPresent();

    public boolean isDirectlyPresent();

    public boolean isMetaPresent();

    public int getDistance();

    public int getAggregateIndex();

    @Nullable
    public Object getSource();

    @Nullable
    public MergedAnnotation<?> getMetaSource();

    public MergedAnnotation<?> getRoot();

    public List<Class<? extends Annotation>> getMetaTypes();

    public boolean hasNonDefaultValue(String var1);

    public boolean hasDefaultValue(String var1) throws NoSuchElementException;

    public byte getByte(String var1) throws NoSuchElementException;

    public byte[] getByteArray(String var1) throws NoSuchElementException;

    public boolean getBoolean(String var1) throws NoSuchElementException;

    public boolean[] getBooleanArray(String var1) throws NoSuchElementException;

    public char getChar(String var1) throws NoSuchElementException;

    public char[] getCharArray(String var1) throws NoSuchElementException;

    public short getShort(String var1) throws NoSuchElementException;

    public short[] getShortArray(String var1) throws NoSuchElementException;

    public int getInt(String var1) throws NoSuchElementException;

    public int[] getIntArray(String var1) throws NoSuchElementException;

    public long getLong(String var1) throws NoSuchElementException;

    public long[] getLongArray(String var1) throws NoSuchElementException;

    public double getDouble(String var1) throws NoSuchElementException;

    public double[] getDoubleArray(String var1) throws NoSuchElementException;

    public float getFloat(String var1) throws NoSuchElementException;

    public float[] getFloatArray(String var1) throws NoSuchElementException;

    public String getString(String var1) throws NoSuchElementException;

    public String[] getStringArray(String var1) throws NoSuchElementException;

    public Class<?> getClass(String var1) throws NoSuchElementException;

    public Class<?>[] getClassArray(String var1) throws NoSuchElementException;

    public <E extends Enum<E>> E getEnum(String var1, Class<E> var2) throws NoSuchElementException;

    public <E extends Enum<E>> E[] getEnumArray(String var1, Class<E> var2) throws NoSuchElementException;

    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String var1, Class<T> var2) throws NoSuchElementException;

    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String var1, Class<T> var2) throws NoSuchElementException;

    public Optional<Object> getValue(String var1);

    public <T> Optional<T> getValue(String var1, Class<T> var2);

    public Optional<Object> getDefaultValue(String var1);

    public <T> Optional<T> getDefaultValue(String var1, Class<T> var2);

    public MergedAnnotation<A> filterDefaultValues();

    public MergedAnnotation<A> filterAttributes(Predicate<String> var1);

    public MergedAnnotation<A> withNonMergedAttributes();

    public AnnotationAttributes asAnnotationAttributes(Adapt ... var1);

    public Map<String, Object> asMap(Adapt ... var1);

    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> var1, Adapt ... var2);

    public A synthesize() throws NoSuchElementException;

    public Optional<A> synthesize(Predicate<? super MergedAnnotation<A>> var1) throws NoSuchElementException;

    public static <A extends Annotation> MergedAnnotation<A> missing() {
        return MissingMergedAnnotation.getInstance();
    }

    public static <A extends Annotation> MergedAnnotation<A> from(A a) {
        return MergedAnnotation.from(null, a);
    }

    public static <A extends Annotation> MergedAnnotation<A> from(@Nullable Object object, A a) {
        return TypeMappedAnnotation.from(object, a);
    }

    public static <A extends Annotation> MergedAnnotation<A> of(Class<A> clazz) {
        return MergedAnnotation.of(null, clazz, null);
    }

    public static <A extends Annotation> MergedAnnotation<A> of(Class<A> clazz, @Nullable Map<String, ?> map) {
        return MergedAnnotation.of(null, clazz, map);
    }

    public static <A extends Annotation> MergedAnnotation<A> of(@Nullable AnnotatedElement annotatedElement, Class<A> clazz, @Nullable Map<String, ?> map) {
        return MergedAnnotation.of(null, annotatedElement, clazz, map);
    }

    public static <A extends Annotation> MergedAnnotation<A> of(@Nullable ClassLoader classLoader, @Nullable Object object, Class<A> clazz, @Nullable Map<String, ?> map) {
        return TypeMappedAnnotation.of(classLoader, object, clazz, map);
    }

    public static enum Adapt {
        CLASS_TO_STRING,
        ANNOTATION_TO_MAP;


        protected final boolean isIn(Adapt ... adaptArray) {
            for (Adapt adapt : adaptArray) {
                if (adapt != this) continue;
                return true;
            }
            return false;
        }

        public static Adapt[] values(boolean bl, boolean bl2) {
            EnumSet<Adapt> enumSet = EnumSet.noneOf(Adapt.class);
            Adapt.addIfTrue(enumSet, CLASS_TO_STRING, bl);
            Adapt.addIfTrue(enumSet, ANNOTATION_TO_MAP, bl2);
            return enumSet.toArray(new Adapt[0]);
        }

        private static <T> void addIfTrue(Set<T> set, T t2, boolean bl) {
            if (bl) {
                set.add(t2);
            }
        }
    }
}

