/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;

enum IntrospectionFailureLogger {
    DEBUG{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isDebugEnabled();
        }

        @Override
        public void log(String string) {
            IntrospectionFailureLogger.getLogger().debug(string);
        }
    }
    ,
    INFO{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isInfoEnabled();
        }

        @Override
        public void log(String string) {
            IntrospectionFailureLogger.getLogger().info(string);
        }
    };

    @Nullable
    private static Log logger;

    void log(String string, @Nullable Object object, Exception exception) {
        String string2 = object != null ? " on " + object : "";
        this.log(string + string2 + ": " + exception);
    }

    abstract boolean isEnabled();

    abstract void log(String var1);

    private static Log getLogger() {
        Log log = logger;
        if (log == null) {
            logger = log = LogFactory.getLog(MergedAnnotation.class);
        }
        return log;
    }
}

