/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

final class AttributeMethods {
    static final AttributeMethods NONE = new AttributeMethods(null, new Method[0]);
    private static final Map<Class<? extends Annotation>, AttributeMethods> cache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, AttributeMethods>();
    private static final Comparator<Method> methodComparator = (method, method2) -> {
        if (method != null && method2 != null) {
            return method.getName().compareTo(method2.getName());
        }
        return method != null ? -1 : 1;
    };
    @Nullable
    private final Class<? extends Annotation> annotationType;
    private final Method[] attributeMethods;
    private final boolean[] canThrowTypeNotPresentException;
    private final boolean hasDefaultValueMethod;
    private final boolean hasNestedAnnotation;

    private AttributeMethods(@Nullable Class<? extends Annotation> clazz, Method[] methodArray) {
        this.annotationType = clazz;
        this.attributeMethods = methodArray;
        this.canThrowTypeNotPresentException = new boolean[methodArray.length];
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = this.attributeMethods[i];
            Class<?> clazz2 = method.getReturnType();
            if (method.getDefaultValue() != null) {
                bl = true;
            }
            if (clazz2.isAnnotation() || clazz2.isArray() && clazz2.getComponentType().isAnnotation()) {
                bl2 = true;
            }
            ReflectionUtils.makeAccessible(method);
            this.canThrowTypeNotPresentException[i] = clazz2 == Class.class || clazz2 == Class[].class || clazz2.isEnum();
        }
        this.hasDefaultValueMethod = bl;
        this.hasNestedAnnotation = bl2;
    }

    boolean hasOnlyValueAttribute() {
        return this.attributeMethods.length == 1 && "value".equals(this.attributeMethods[0].getName());
    }

    boolean isValid(Annotation annotation) {
        this.assertAnnotation(annotation);
        for (int i = 0; i < this.size(); ++i) {
            if (!this.canThrowTypeNotPresentException(i)) continue;
            try {
                this.get(i).invoke((Object)annotation, new Object[0]);
                continue;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    void validate(Annotation annotation) {
        this.assertAnnotation(annotation);
        for (int i = 0; i < this.size(); ++i) {
            if (!this.canThrowTypeNotPresentException(i)) continue;
            try {
                this.get(i).invoke((Object)annotation, new Object[0]);
                continue;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Could not obtain annotation attribute value for " + this.get(i).getName() + " declared on " + annotation.annotationType(), throwable);
            }
        }
    }

    private void assertAnnotation(Annotation annotation) {
        Assert.notNull((Object)annotation, "Annotation must not be null");
        if (this.annotationType != null) {
            Assert.isInstanceOf(this.annotationType, annotation);
        }
    }

    @Nullable
    Method get(String string) {
        int n = this.indexOf(string);
        return n != -1 ? this.attributeMethods[n] : null;
    }

    Method get(int n) {
        return this.attributeMethods[n];
    }

    boolean canThrowTypeNotPresentException(int n) {
        return this.canThrowTypeNotPresentException[n];
    }

    int indexOf(String string) {
        for (int i = 0; i < this.attributeMethods.length; ++i) {
            if (!this.attributeMethods[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    int indexOf(Method method) {
        for (int i = 0; i < this.attributeMethods.length; ++i) {
            if (!this.attributeMethods[i].equals(method)) continue;
            return i;
        }
        return -1;
    }

    int size() {
        return this.attributeMethods.length;
    }

    boolean hasDefaultValueMethod() {
        return this.hasDefaultValueMethod;
    }

    boolean hasNestedAnnotation() {
        return this.hasNestedAnnotation;
    }

    static AttributeMethods forAnnotationType(@Nullable Class<? extends Annotation> clazz) {
        if (clazz == null) {
            return NONE;
        }
        return cache.computeIfAbsent(clazz, AttributeMethods::compute);
    }

    private static AttributeMethods compute(Class<? extends Annotation> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        for (int i = 0; i < methodArray.length; ++i) {
            if (AttributeMethods.isAttributeMethod(methodArray[i])) continue;
            methodArray[i] = null;
            --n;
        }
        if (n == 0) {
            return NONE;
        }
        Arrays.sort(methodArray, methodComparator);
        Method[] methodArray2 = Arrays.copyOf(methodArray, n);
        return new AttributeMethods(clazz, methodArray2);
    }

    private static boolean isAttributeMethod(Method method) {
        return method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE;
    }

    static String describe(@Nullable Method method) {
        if (method == null) {
            return "(none)";
        }
        return AttributeMethods.describe(method.getDeclaringClass(), method.getName());
    }

    static String describe(@Nullable Class<?> clazz, @Nullable String string) {
        if (string == null) {
            return "(none)";
        }
        String string2 = clazz != null ? " in annotation [" + clazz.getName() + "]" : "";
        return "attribute '" + string + "'" + string2;
    }
}

