/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static final String VALUE = "value";
    private static final AnnotationFilter JAVA_LANG_ANNOTATION_FILTER = AnnotationFilter.packages("java.lang.annotation");
    private static final Map<Class<? extends Annotation>, Map<String, DefaultValueHolder>> defaultValuesCache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, Map<String, DefaultValueHolder>>();

    public static boolean isCandidateClass(Class<?> clazz, Collection<Class<? extends Annotation>> collection) {
        for (Class<? extends Annotation> clazz2 : collection) {
            if (!AnnotationUtils.isCandidateClass(clazz, clazz2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCandidateClass(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return AnnotationUtils.isCandidateClass(clazz, clazz2.getName());
    }

    public static boolean isCandidateClass(Class<?> clazz, String string) {
        if (string.startsWith("java.")) {
            return true;
        }
        return !AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz);
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Annotation annotation, Class<A> clazz) {
        if (clazz.isInstance(annotation)) {
            return (A)AnnotationUtils.synthesizeAnnotation(annotation, clazz);
        }
        if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotation)) {
            return null;
        }
        return (A)((Annotation)MergedAnnotations.from((Object)annotation, new Annotation[]{annotation}, RepeatableContainers.none()).get(clazz).withNonMergedAttributes().synthesize(AnnotationUtils::isSingleLevelPresent).orElse(null));
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> clazz) {
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.getAnnotation(clazz);
        }
        return (A)((Annotation)MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none()).get(clazz).withNonMergedAttributes().synthesize(AnnotationUtils::isSingleLevelPresent).orElse(null));
    }

    private static <A extends Annotation> boolean isSingleLevelPresent(MergedAnnotation<A> mergedAnnotation) {
        int n = mergedAnnotation.getDistance();
        return n == 0 || n == 1;
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz) {
        Method method2 = BridgeMethodResolver.findBridgedMethod(method);
        return AnnotationUtils.getAnnotation((AnnotatedElement)method2, clazz);
    }

    @Deprecated
    @Nullable
    public static Annotation[] getAnnotations(AnnotatedElement annotatedElement) {
        try {
            return AnnotationUtils.synthesizeAnnotationArray(annotatedElement.getAnnotations(), annotatedElement);
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, throwable);
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static Annotation[] getAnnotations(Method method) {
        try {
            return AnnotationUtils.synthesizeAnnotationArray(BridgeMethodResolver.findBridgedMethod(method).getAnnotations(), method);
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(method, throwable);
            return null;
        }
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotationUtils.getRepeatableAnnotations(annotatedElement, clazz, null);
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz, @Nullable Class<? extends Annotation> clazz2) {
        RepeatableContainers repeatableContainers = clazz2 != null ? RepeatableContainers.of(clazz, clazz2) : RepeatableContainers.standardRepeatables();
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.SUPERCLASS, repeatableContainers).stream(clazz).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getDeclaredRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotationUtils.getDeclaredRepeatableAnnotations(annotatedElement, clazz, null);
    }

    @Deprecated
    public static <A extends Annotation> Set<A> getDeclaredRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz, @Nullable Class<? extends Annotation> clazz2) {
        RepeatableContainers repeatableContainers = clazz2 != null ? RepeatableContainers.of(clazz, clazz2) : RepeatableContainers.standardRepeatables();
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.DIRECT, repeatableContainers).stream(clazz).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, @Nullable Class<A> clazz) {
        if (clazz == null) {
            return null;
        }
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.getDeclaredAnnotation(clazz);
        }
        return (A)((Annotation)MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none()).get(clazz).withNonMergedAttributes().synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Method method, @Nullable Class<A> clazz) {
        if (clazz == null) {
            return null;
        }
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(method)) {
            return method.getDeclaredAnnotation(clazz);
        }
        return (A)((Annotation)MergedAnnotations.from(method, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.none()).get(clazz).withNonMergedAttributes().synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Class<?> clazz, @Nullable Class<A> clazz2) {
        if (clazz2 == null) {
            return null;
        }
        if (AnnotationFilter.PLAIN.matches(clazz2) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
            A a = clazz.getDeclaredAnnotation(clazz2);
            if (a != null) {
                return a;
            }
            Class<?> clazz3 = clazz.getSuperclass();
            if (clazz3 == null || clazz3 == Object.class) {
                return null;
            }
            return AnnotationUtils.findAnnotation(clazz3, clazz2);
        }
        return (A)((Annotation)MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.none()).get(clazz2).withNonMergedAttributes().synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    @Deprecated
    @Nullable
    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> clazz, @Nullable Class<?> clazz2) {
        if (clazz2 == null) {
            return null;
        }
        return (Class)MergedAnnotations.from(clazz2, MergedAnnotations.SearchStrategy.SUPERCLASS).get(clazz, MergedAnnotation::isDirectlyPresent).getSource();
    }

    @Deprecated
    @Nullable
    public static Class<?> findAnnotationDeclaringClassForTypes(List<Class<? extends Annotation>> list, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.SUPERCLASS).stream().filter(MergedAnnotationPredicates.typeIn(list).and(MergedAnnotation::isDirectlyPresent)).map(MergedAnnotation::getSource).findFirst().orElse(null);
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> clazz, Class<?> clazz2) {
        return MergedAnnotations.from(clazz2).get(clazz).isDirectlyPresent();
    }

    @Deprecated
    public static boolean isAnnotationInherited(Class<? extends Annotation> clazz, Class<?> clazz2) {
        return MergedAnnotations.from(clazz2, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).stream(clazz).filter(MergedAnnotation::isDirectlyPresent).findFirst().orElseGet(MergedAnnotation::missing).getAggregateIndex() > 0;
    }

    @Deprecated
    public static boolean isAnnotationMetaPresent(Class<? extends Annotation> clazz, @Nullable Class<? extends Annotation> clazz2) {
        if (clazz2 == null) {
            return false;
        }
        if (AnnotationFilter.PLAIN.matches(clazz2) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
            return clazz.isAnnotationPresent(clazz2);
        }
        return MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none()).isPresent(clazz2);
    }

    public static boolean isInJavaLangAnnotationPackage(@Nullable Annotation annotation) {
        return annotation != null && JAVA_LANG_ANNOTATION_FILTER.matches(annotation);
    }

    public static boolean isInJavaLangAnnotationPackage(@Nullable String string) {
        return string != null && JAVA_LANG_ANNOTATION_FILTER.matches(string);
    }

    public static void validateAnnotation(Annotation annotation) {
        AttributeMethods.forAnnotationType(annotation.annotationType()).validate(annotation);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(null, annotation);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean bl) {
        return AnnotationUtils.getAnnotationAttributes(annotation, bl, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean bl, boolean bl2) {
        return AnnotationUtils.getAnnotationAttributes(null, annotation, bl, bl2);
    }

    public static AnnotationAttributes getAnnotationAttributes(@Nullable AnnotatedElement annotatedElement, Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotation, false, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(@Nullable AnnotatedElement annotatedElement, Annotation annotation, boolean bl, boolean bl2) {
        MergedAnnotation.Adapt[] adaptArray = MergedAnnotation.Adapt.values(bl, bl2);
        return MergedAnnotation.from(annotatedElement, annotation).withNonMergedAttributes().asMap(mergedAnnotation -> new AnnotationAttributes(mergedAnnotation.getType(), true), adaptArray);
    }

    public static void registerDefaultValues(AnnotationAttributes annotationAttributes) {
        Class<? extends Annotation> clazz = annotationAttributes.annotationType();
        if (clazz != null && Modifier.isPublic(clazz.getModifiers()) && !AnnotationFilter.PLAIN.matches(clazz)) {
            Map<String, DefaultValueHolder> map = AnnotationUtils.getDefaultValues(clazz);
            map.forEach(annotationAttributes::putIfAbsent);
        }
    }

    private static Map<String, DefaultValueHolder> getDefaultValues(Class<? extends Annotation> clazz) {
        return defaultValuesCache.computeIfAbsent(clazz, AnnotationUtils::computeDefaultValues);
    }

    private static Map<String, DefaultValueHolder> computeDefaultValues(Class<? extends Annotation> clazz) {
        AttributeMethods attributeMethods = AttributeMethods.forAnnotationType(clazz);
        if (!attributeMethods.hasDefaultValueMethod()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, DefaultValueHolder> linkedHashMap = new LinkedHashMap<String, DefaultValueHolder>(attributeMethods.size());
        if (!attributeMethods.hasNestedAnnotation()) {
            for (int i = 0; i < attributeMethods.size(); ++i) {
                Method method = attributeMethods.get(i);
                Object object = method.getDefaultValue();
                if (object == null) continue;
                linkedHashMap.put(method.getName(), new DefaultValueHolder(object));
            }
        } else {
            AnnotationAttributes annotationAttributes = MergedAnnotation.of(clazz).asMap(mergedAnnotation -> new AnnotationAttributes(mergedAnnotation.getType(), true), MergedAnnotation.Adapt.ANNOTATION_TO_MAP);
            for (Map.Entry entry : annotationAttributes.entrySet()) {
                linkedHashMap.put((String)entry.getKey(), new DefaultValueHolder(entry.getValue()));
            }
        }
        return linkedHashMap;
    }

    public static void postProcessAnnotationAttributes(@Nullable Object object, @Nullable AnnotationAttributes annotationAttributes, boolean bl) {
        Object object2;
        if (annotationAttributes == null) {
            return;
        }
        if (!annotationAttributes.validated) {
            Class<? extends Annotation> clazz = annotationAttributes.annotationType();
            if (clazz == null) {
                return;
            }
            AnnotationTypeMapping object3 = AnnotationTypeMappings.forAnnotationType(clazz).get(0);
            for (int i = 0; i < object3.getMirrorSets().size(); ++i) {
                object2 = object3.getMirrorSets().get(i);
                int n = ((AnnotationTypeMapping.MirrorSets.MirrorSet)object2).resolve(annotationAttributes.displayName, (AnnotationAttributes)annotationAttributes, AnnotationUtils::getAttributeValueForMirrorResolution);
                if (n == -1) continue;
                Method method = object3.getAttributes().get(n);
                Object v = annotationAttributes.get(method.getName());
                for (int j = 0; j < ((AnnotationTypeMapping.MirrorSets.MirrorSet)object2).size(); ++j) {
                    Method method2 = ((AnnotationTypeMapping.MirrorSets.MirrorSet)object2).get(j);
                    if (method2 == method) continue;
                    annotationAttributes.put(method2.getName(), AnnotationUtils.adaptValue(object, v, bl));
                }
            }
        }
        for (Map.Entry entry : annotationAttributes.entrySet()) {
            String string = (String)entry.getKey();
            object2 = entry.getValue();
            if (!(object2 instanceof DefaultValueHolder)) continue;
            object2 = ((DefaultValueHolder)object2).defaultValue;
            annotationAttributes.put(string, AnnotationUtils.adaptValue(object, object2, bl));
        }
    }

    private static Object getAttributeValueForMirrorResolution(Method method, Object object) {
        Object v = ((AnnotationAttributes)object).get(method.getName());
        return v instanceof DefaultValueHolder ? ((DefaultValueHolder)v).defaultValue : v;
    }

    @Nullable
    private static Object adaptValue(@Nullable Object object, @Nullable Object object2, boolean bl) {
        if (bl) {
            if (object2 instanceof Class) {
                return ((Class)object2).getName();
            }
            if (object2 instanceof Class[]) {
                Class[] classArray = (Class[])object2;
                String[] stringArray = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[i] = classArray[i].getName();
                }
                return stringArray;
            }
        }
        if (object2 instanceof Annotation) {
            Annotation annotation = (Annotation)object2;
            return MergedAnnotation.from(object, annotation).synthesize();
        }
        if (object2 instanceof Annotation[]) {
            Annotation[] annotationArray = (Annotation[])object2;
            Annotation[] annotationArray2 = (Annotation[])Array.newInstance(annotationArray.getClass().getComponentType(), annotationArray.length);
            for (int i = 0; i < annotationArray.length; ++i) {
                annotationArray2[i] = MergedAnnotation.from(object, annotationArray[i]).synthesize();
            }
            return annotationArray2;
        }
        return object2;
    }

    @Nullable
    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    @Nullable
    public static Object getValue(@Nullable Annotation annotation, @Nullable String string) {
        if (annotation == null || !StringUtils.hasText(string)) {
            return null;
        }
        try {
            Method method = annotation.annotationType().getDeclaredMethod(string, new Class[0]);
            ReflectionUtils.makeAccessible(method);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            AnnotationUtils.rethrowAnnotationConfigurationException(invocationTargetException.getTargetException());
            throw new IllegalStateException("Could not obtain value for annotation attribute '" + string + "' in " + annotation, invocationTargetException);
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(annotation.getClass(), throwable);
            return null;
        }
    }

    static void rethrowAnnotationConfigurationException(Throwable throwable) {
        if (throwable instanceof AnnotationConfigurationException) {
            throw (AnnotationConfigurationException)throwable;
        }
    }

    static void handleIntrospectionFailure(@Nullable AnnotatedElement annotatedElement, Throwable throwable) {
        AnnotationUtils.rethrowAnnotationConfigurationException(throwable);
        IntrospectionFailureLogger introspectionFailureLogger = IntrospectionFailureLogger.INFO;
        boolean bl = false;
        if (annotatedElement instanceof Class && Annotation.class.isAssignableFrom((Class)annotatedElement)) {
            introspectionFailureLogger = IntrospectionFailureLogger.DEBUG;
            bl = true;
        }
        if (introspectionFailureLogger.isEnabled()) {
            String string = bl ? "Failed to meta-introspect annotation " : "Failed to introspect annotations on ";
            introspectionFailureLogger.log(string + annotatedElement + ": " + throwable);
        }
    }

    @Nullable
    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    @Nullable
    public static Object getDefaultValue(@Nullable Annotation annotation, @Nullable String string) {
        return annotation != null ? AnnotationUtils.getDefaultValue(annotation.annotationType(), string) : null;
    }

    @Nullable
    public static Object getDefaultValue(Class<? extends Annotation> clazz) {
        return AnnotationUtils.getDefaultValue(clazz, VALUE);
    }

    @Nullable
    public static Object getDefaultValue(@Nullable Class<? extends Annotation> clazz, @Nullable String string) {
        if (clazz == null || !StringUtils.hasText(string)) {
            return null;
        }
        return MergedAnnotation.of(clazz).getDefaultValue(string).orElse(null);
    }

    public static <A extends Annotation> A synthesizeAnnotation(A a, @Nullable AnnotatedElement annotatedElement) {
        if (a instanceof SynthesizedAnnotation || AnnotationFilter.PLAIN.matches(a)) {
            return a;
        }
        return MergedAnnotation.from(annotatedElement, a).synthesize();
    }

    public static <A extends Annotation> A synthesizeAnnotation(Class<A> clazz) {
        return AnnotationUtils.synthesizeAnnotation(Collections.emptyMap(), clazz, null);
    }

    public static <A extends Annotation> A synthesizeAnnotation(Map<String, Object> map, Class<A> clazz, @Nullable AnnotatedElement annotatedElement) {
        try {
            return MergedAnnotation.of(annotatedElement, clazz, map).synthesize();
        }
        catch (IllegalStateException | NoSuchElementException runtimeException) {
            throw new IllegalArgumentException(runtimeException);
        }
    }

    static Annotation[] synthesizeAnnotationArray(Annotation[] annotationArray, AnnotatedElement annotatedElement) {
        if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotationArray;
        }
        Annotation[] annotationArray2 = (Annotation[])Array.newInstance(annotationArray.getClass().getComponentType(), annotationArray.length);
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = AnnotationUtils.synthesizeAnnotation(annotationArray[i], annotatedElement);
        }
        return annotationArray2;
    }

    public static void clearCache() {
        AnnotationTypeMappings.clearCache();
        AnnotationsScanner.clearCache();
    }

    private static class DefaultValueHolder {
        final Object defaultValue;

        public DefaultValueHolder(Object object) {
            this.defaultValue = object;
        }

        public String toString() {
            return "*" + this.defaultValue;
        }
    }
}

