/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.lang.Nullable;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    @Nullable
    protected Integer findOrder(Object object) {
        Integer n = super.findOrder(object);
        if (n != null) {
            return n;
        }
        return this.findOrderFromAnnotation(object);
    }

    @Nullable
    private Integer findOrderFromAnnotation(Object object) {
        MergedAnnotations mergedAnnotations;
        Class<?> clazz = object instanceof AnnotatedElement ? (Class<?>)object : object.getClass();
        Integer n = OrderUtils.getOrderFromAnnotations(clazz, mergedAnnotations = MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
        if (n == null && object instanceof DecoratingProxy) {
            return this.findOrderFromAnnotation(((DecoratingProxy)object).getDecoratedClass());
        }
        return n;
    }

    @Override
    @Nullable
    public Integer getPriority(Object object) {
        if (object instanceof Class) {
            return OrderUtils.getPriority((Class)object);
        }
        Integer n = OrderUtils.getPriority(object.getClass());
        if (n == null && object instanceof DecoratingProxy) {
            return this.getPriority(((DecoratingProxy)object).getDecoratedClass());
        }
        return n;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            list.sort(INSTANCE);
        }
    }

    public static void sort(Object[] objectArray) {
        if (objectArray.length > 1) {
            Arrays.sort(objectArray, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object object) {
        if (object instanceof Object[]) {
            AnnotationAwareOrderComparator.sort((Object[])object);
        } else if (object instanceof List) {
            AnnotationAwareOrderComparator.sort((List)object);
        }
    }
}

