/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ParameterizedTypeReference<T> {
    private final Type type;

    protected ParameterizedTypeReference() {
        Class<?> clazz = ParameterizedTypeReference.findParameterizedTypeReferenceSubclass(this.getClass());
        Type type = clazz.getGenericSuperclass();
        Assert.isInstanceOf(ParameterizedType.class, (Object)type, "Type must be a parameterized type");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Assert.isTrue(typeArray.length == 1, "Number of type arguments must be 1");
        this.type = typeArray[0];
    }

    private ParameterizedTypeReference(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof ParameterizedTypeReference && this.type.equals(((ParameterizedTypeReference)object).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "ParameterizedTypeReference<" + this.type + ">";
    }

    public static <T> ParameterizedTypeReference<T> forType(Type type) {
        return new ParameterizedTypeReference<T>(type){};
    }

    private static Class<?> findParameterizedTypeReferenceSubclass(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (Object.class == clazz2) {
            throw new IllegalStateException("Expected ParameterizedTypeReference superclass");
        }
        if (ParameterizedTypeReference.class == clazz2) {
            return clazz;
        }
        return ParameterizedTypeReference.findParameterizedTypeReferenceSubclass(clazz2);
    }
}

